/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects;

import java.io.File;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.nakedobjects.Application;
import org.nakedobjects.ObjectViewingMechanism;
import org.nakedobjects.basicgui.application.GraphicalViewingMechanism;
import org.nakedobjects.basicgui.application.ViewNotifier;
import org.nakedobjects.object.AbstractNakedObject;
import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.NakedClassList;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedObjectStore;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.utility.ConfigurationException;
import org.nakedobjects.utility.ConfigurationParameters;

public abstract class Exploration
extends Application {
    private static final Category LOG = Category.getInstance((Class)(class$org$nakedobjects$Exploration == null ? (class$org$nakedobjects$Exploration = Exploration.class$("org.nakedobjects.Exploration")) : class$org$nakedobjects$Exploration));
    private static final String DEFAULT_CONFIG = "./exploration.properties";
    private static final String OBJECT_STORE = "nakedobjects.object-store";
    private NakedObjectStore objectStore;
    private Vector newInstances = new Vector();
    static /* synthetic */ Class class$org$nakedobjects$Exploration;
    static /* synthetic */ Class class$org$nakedobjects$security$User;
    static /* synthetic */ Class class$org$nakedobjects$object$NakedObjectStore;
    static /* synthetic */ Class class$org$nakedobjects$object$TransientObjectStore;

    public Exploration() {
        try {
            this.init();
        }
        catch (ConfigurationException configurationException) {
            System.out.println("Failed to start");
            configurationException.printStackTrace();
        }
        catch (ObjectStoreException objectStoreException) {
            System.out.println("Failed to start object store");
            objectStoreException.printStackTrace();
        }
    }

    public abstract void classSet(NakedClassList var1);

    protected NakedObjectStore getObjectStore() {
        return this.objectStore;
    }

    protected String configurationFile() {
        return null;
    }

    protected NakedObject createInstance(Class clazz) {
        NakedClass nakedClass = NakedClass.getNakedClass(clazz.getName());
        if (nakedClass == null) {
            return null;
        }
        NakedObject nakedObject = nakedClass.acquireInstance();
        nakedObject.created();
        this.newInstances.addElement(nakedObject);
        return nakedObject;
    }

    protected boolean hasNoInstances(Class clazz) throws ObjectStoreException {
        NakedClass nakedClass = NakedClass.getNakedClass(clazz);
        return !this.objectStore.hasInstances(nakedClass);
    }

    protected void init() throws ConfigurationException, ObjectStoreException {
        NakedObject nakedObject;
        String string = this.configurationFile();
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        if (string != null) {
            if (new File(string).exists()) {
                ConfigurationParameters.getInstance().load(string);
                PropertyConfigurator.configure((Properties)ConfigurationParameters.getInstance().getProperties());
            } else {
                System.out.println("No configuration file found or loaded.");
                System.exit(1);
            }
        } else if (new File(DEFAULT_CONFIG).exists()) {
            ConfigurationParameters.getInstance().load(DEFAULT_CONFIG);
            PropertyConfigurator.configure((Properties)ConfigurationParameters.getInstance().getProperties());
        }
        this.displayCopyrightNotice();
        this.objectStore = this.installObjectStore();
        ObjectViewingMechanism objectViewingMechanism = this.installApplication(this.objectStore);
        ViewNotifier viewNotifier = new ViewNotifier();
        this.objectStore.setUpdateNotifier(viewNotifier);
        AbstractNakedObject.init(this.objectStore);
        this.initObjects();
        int n = 0;
        while (n < this.newInstances.size()) {
            nakedObject = (NakedObject)this.newInstances.elementAt(n);
            if (!nakedObject.isPersistent()) {
                this.objectStore.makePersistent(nakedObject);
            }
            ++n;
        }
        nakedObject = new NakedClassList("");
        this.classSet((NakedClassList)nakedObject);
        objectViewingMechanism.init((NakedClassList)nakedObject);
        if (this.objectStore.hasInstances(NakedClass.getNakedClass(class$org$nakedobjects$security$User == null ? (class$org$nakedobjects$security$User = Exploration.class$("org.nakedobjects.security.User")) : class$org$nakedobjects$security$User))) {
            this.login();
        }
        objectViewingMechanism.start();
    }

    protected void initObjects() throws ObjectStoreException {
    }

    protected ObjectViewingMechanism installApplication(NakedObjectStore nakedObjectStore) throws ConfigurationException {
        return new GraphicalViewingMechanism(nakedObjectStore);
    }

    protected NakedObjectStore installObjectStore() throws ConfigurationException, ObjectStoreException {
        NakedObjectStore nakedObjectStore = (NakedObjectStore)this.loadComponent(OBJECT_STORE, class$org$nakedobjects$object$NakedObjectStore == null ? (class$org$nakedobjects$object$NakedObjectStore = Exploration.class$("org.nakedobjects.object.NakedObjectStore")) : class$org$nakedobjects$object$NakedObjectStore, (class$org$nakedobjects$object$TransientObjectStore == null ? (class$org$nakedobjects$object$TransientObjectStore = Exploration.class$("org.nakedobjects.object.TransientObjectStore")) : class$org$nakedobjects$object$TransientObjectStore).getName());
        nakedObjectStore.init();
        return nakedObjectStore;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

