/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Vector;
import org.nakedobjects.basicgui.application.OvalBackground;
import org.nakedobjects.basicgui.event.popup.MenuOption;
import org.nakedobjects.basicgui.event.popup.MenuOptionSet;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.ViewBackground;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewContent;
import org.nakedobjects.object.NakedInterfaceEvent;
import org.nakedobjects.object.NakedObject;

public class View {
    private static int nextNo = 1;
    private final int no = nextNo++;
    private Vector options = new Vector();
    private String name;
    private ViewBackground viewBackground;
    private ViewContent viewContent;
    private ViewBorder viewBorder;
    private LayoutManager layout;

    public View(ViewBackground viewBackground, ViewContent viewContent, ViewBorder viewBorder, LayoutManager layoutManager) {
        this.viewBackground = viewBackground;
        this.viewContent = viewContent;
        this.viewBorder = viewBorder;
        this.layout = layoutManager;
        this.name = this.getClass().getName();
        this.name = this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public View(ViewContent viewContent, ViewBorder viewBorder) {
        this(null, viewContent, viewBorder, null);
    }

    public void addOption(MenuOption menuOption) {
        this.options.addElement(menuOption);
    }

    public String debugDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("View:         " + this + "\n");
        stringBuffer.append("  Background: " + this.viewBackground + "\n");
        stringBuffer.append("  Border:     " + this.viewBorder + "\n");
        stringBuffer.append("  Graphic:    " + this.viewContent + "\n");
        stringBuffer.append("  Layout:     " + this.layout + "\n");
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void drawBackground(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        if (objectViewer.status == 1) {
            new OvalBackground().paint(graphics, rectangle, objectViewer);
        }
        if (this.viewBackground != null) {
            this.viewBackground.paint(graphics, rectangle, objectViewer);
        }
    }

    public void drawBorder(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        if (this.viewBorder != null) {
            this.viewBorder.paint(graphics, rectangle, objectViewer);
        }
    }

    public void drawContent(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        if (this.viewContent != null) {
            this.viewContent.paint(graphics, rectangle, objectViewer);
        }
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        if (this.viewBorder == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.viewBorder.getBorderInsets(objectViewer);
    }

    public Dimension getContentSize(ObjectViewer objectViewer) {
        Dimension dimension = this.viewContent != null ? this.viewContent.getMinimumSize(objectViewer.getObject()) : new Dimension(0, 0);
        Dimension dimension2 = this.viewBackground != null ? this.viewBackground.getMinimumSize(objectViewer.getObject()) : new Dimension(0, 0);
        Dimension dimension3 = new Dimension(0, 0);
        dimension3.width = Math.max(dimension.width, dimension2.width);
        dimension3.height = Math.max(dimension.height, dimension2.height);
        if (this.viewBorder != null) {
            Dimension dimension4 = this.viewBorder.getMinimumSize(objectViewer);
            dimension3.width = Math.max(dimension3.width, dimension4.width);
            dimension3.height = Math.max(dimension3.height, dimension4.height);
        }
        return dimension3;
    }

    public LayoutManager getLayout() {
        return this.layout;
    }

    public Dimension getMiminumBorderSize(ObjectViewer objectViewer) {
        if (this.viewBorder != null) {
            return this.viewBorder.getMinimumSize(objectViewer);
        }
        return new Dimension(0, 0);
    }

    public String getName() {
        return this.name;
    }

    public String idString() {
        String string = this.getClass().getName();
        return string.substring(string.lastIndexOf(46) + 1) + this.no;
    }

    public void init(NakedObject nakedObject, ObjectViewer objectViewer, Display display) {
    }

    public void menuOptions(MenuOptionSet menuOptionSet) {
        int n = 0;
        while (n < this.options.size()) {
            menuOptionSet.add((MenuOption)this.options.elementAt(n));
            ++n;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public String toString() {
        return super.toString() + " [name=" + this.name + ",background=" + this.viewBackground + ",content=" + this.viewContent + ",border=" + this.viewBorder + "]";
    }

    public void update(NakedInterfaceEvent nakedInterfaceEvent, ObjectViewer objectViewer, Display display) {
        display.refresh();
    }
}

