/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.tomcat.logging.LogDaemon;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.util.Queue;

public class TomcatLogger
extends Logger {
    static LogDaemon logDaemon = null;
    static Queue logQueue = null;

    public TomcatLogger() {
        if (logDaemon == null || logQueue == null) {
            logQueue = new Queue();
            logDaemon = new LogDaemon(logQueue);
            logDaemon.start();
        }
    }

    public void flush() {
        logDaemon.flush();
    }

    protected void realLog(String message) {
        logQueue.put(new LogEntry(message, null));
    }

    protected void realLog(String message, Throwable t) {
        logQueue.put(new LogEntry(message, t));
    }

    class LogEntry {
        String logName;
        long date;
        String message;
        Throwable t;

        LogEntry(String message, Throwable t) {
            if (TomcatLogger.this.timeStamp) {
                this.date = System.currentTimeMillis();
            }
            this.message = message;
            this.t = t;
        }

        Writer getWriter() {
            return TomcatLogger.this.sink;
        }

        private String throwableToString(Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            if (t != null) {
                t.printStackTrace(w);
            }
            return sw.toString();
        }

        public String toString() {
            if (TomcatLogger.this.custom) {
                return this.t == null ? this.message : String.valueOf(this.message) + " " + this.throwableToString(this.t);
            }
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            w.print("<" + TomcatLogger.this.getName() + "> ");
            if (TomcatLogger.this.timeStamp) {
                w.print(new Date(this.date).toString());
            }
            w.print(' ');
            if (this.message != null) {
                w.print(this.message);
            }
            if (this.t != null) {
                this.t.printStackTrace(w);
            }
            w.println("</" + TomcatLogger.this.getName() + "> ");
            return sw.toString();
        }
    }
}

