/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import javax.servlet.http.Cookie;
import org.apache.tomcat.catalina.Request;

public final class SessionUtil {
    private static int counter = 1010;

    public static Cookie createCookie(Request req, String id) {
        String contextPath;
        Cookie cookie = new Cookie("JSESSIONID", id);
        String serverName = req.getRequest().getServerName();
        if (serverName != null) {
            cookie.setDomain(serverName);
        }
        if ((contextPath = req.getRequest().getContextPath()) != null && contextPath.length() > 0) {
            cookie.setPath(contextPath);
        } else {
            cookie.setPath("/");
        }
        cookie.setMaxAge(-1);
        cookie.setVersion(1);
        return cookie;
    }

    private static String encode(String id, String url) {
        if (id == null || url == null) {
            return url;
        }
        int question = url.indexOf(63);
        StringBuffer buf = new StringBuffer();
        if (question < 0) {
            buf.append(url);
        } else {
            buf.append(url.substring(0, question));
        }
        buf.append(';');
        buf.append("jsessionid");
        buf.append('=');
        buf.append(id);
        if (question >= 0) {
            buf.append(url.substring(question));
        }
        return buf.toString();
    }

    public static String encodeRedirectURL(Request req, String id, String url) {
        return SessionUtil.encodeURL(req, id, url);
    }

    public static String encodeURL(Request req, String id, String url) {
        if (!url.startsWith("http:")) {
            if (!url.startsWith("#")) {
                return SessionUtil.encode(id, url);
            }
            return url;
        }
        String serverName = req.getRequest().getServerName();
        String match = "http://" + serverName;
        if (url.startsWith("http://" + serverName)) {
            return SessionUtil.encode(id, url);
        }
        return url;
    }

    public static String generateSessionId() {
        Integer i = new Integer(counter++);
        StringBuffer buf = new StringBuffer();
        String dString = Double.toString(Math.abs(Math.random()));
        buf.append("To");
        buf.append(i);
        buf.append("mC");
        buf.append(dString.substring(2));
        buf.append("At");
        return buf.toString();
    }

    public static String parseSessionId(String uri) {
        String match = ";jsessionid=";
        int m = uri.indexOf(match);
        if (m < 0) {
            return null;
        }
        String temp = uri.substring(m + match.length());
        int s = temp.indexOf(59);
        int q = temp.indexOf(63);
        if (s < 0) {
            if (q < 0) {
                return temp;
            }
            return temp.substring(0, q);
        }
        if (q < 0) {
            return temp.substring(0, s);
        }
        if (q < s) {
            return temp.substring(0, q);
        }
        return temp.substring(0, s);
    }

    public static String parseSessionId(Cookie[] cookies) {
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            if ("JSESSIONID".equals(cookies[i].getName())) {
                return cookies[i].getValue();
            }
            ++i;
        }
        return null;
    }
}

