//----------------------------------------------------------
#include <vcl\vcl.h>
#include <errno.h>
#include <assert.h>

#pragma hdrstop

#include "FrmDxfMd.h"
#include "FrmSplsh.h"
//----------------------------------------------------------
#pragma link "FrmCnv"
#pragma resource "*.dfm"
TDxfModCnvForm *DxfModCnvForm;
//----------------------------------------------------------
static void OnProgress(long now, long total) {
  TProgressRange max = ::DxfModCnvForm->ProgressBar->Max;
  TProgressRange pos = TProgressRange(float(now)/total*max);
  ::DxfModCnvForm->ProgressBar->Position = pos;
  Application->ProcessMessages(); //   
  // Abort .........
}//---------------------------------------------------------
__fastcall TDxfModCnvForm::TDxfModCnvForm(TComponent* Owner)
   : TConvertForm(Owner)
{
  DxfModel = new TDxfMeshModel;
  DxfModel->DoSkipBlocks = true;
  DxfModel->OnProgress   = OnProgress;
}//---------------------------------------------------------
__fastcall TDxfModCnvForm::~TDxfModCnvForm() {
  delete DxfModel;
  RCTable.Clear();
  VertList.Clear();
  FaceTable.Clear();
  DFTable.Clear();
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::WMHelp(TMessage &Message) {
  if (!FileExists(Application->HelpFile))
     SplashForm->ShowModal();
  else Application->HelpCommand(HELP_CONTENTS,0);
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::btnConvertClick(TObject*) {
  char buf[512];
  AnsiString DxfFile, ModFile;
  //    :
  DxfFile = NameEdit->Text;
  if (!FileExists(DxfFile)) {
     sprintf(buf,
        "File \"%s\" not found!\n", DxfFile.c_str());
     Application->MessageBox(buf,
        Application->Title.c_str(),
        MB_OK | MB_ICONERROR);
     return;
  }
  //     
  // :
  ModFile =  ChangeFileExt(DxfFile, ".mod");
  if (FileExists(ModFile)) {
     sprintf(buf,
        "File \"%s\" already exists!\nOk to overwrite?",
        ModFile.c_str());
     if (Application->MessageBox(buf,
         Application->Title.c_str(),
         MB_YESNO | MB_ICONQUESTION) == ID_NO)
     return;
  }
  //   :
  btnConvert->Enabled = false;
  btnAbort->Enabled   = true;
  //  :
  try {
     DxfModel->ReadFromFile(DxfFile.c_str());
     WriteMod(ModFile.c_str());
  } catch(Exception &exception) {
     //   ,  , 
     //     
     Application->ShowException(&exception);
  }
  //      :
  btnConvert->Enabled   = true;
  btnAbort->Enabled     = false;
  ProgressBar->Position = 0;
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::btnAbortClick(TObject*) {
  DxfModel->Aborted = true;
  ProgressBar->Position = 0;
}//---------------------------------------------------------
bool __fastcall TDxfModCnvForm::IsFeaLyer(string &lname) {
  if (lname.find("_") != NPOS) return true;
  return false;
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::MakeRCTable() {
  RCTable.Clear();
  TBlockIter BlockIter(DxfModel->BlockTable);
  if (BlockIter.home()) do {
     TLayIter LayIter(BlockIter.current()->LayTable);
     if (LayIter.home()) do {
        string lname = *LayIter.currentID();
        if (IsFeaLyer(lname)) RCTable[lname] = 0;
     } while(LayIter.next());
  } while(BlockIter.next());
  int rc = 1;
  ChainIter<int, string> RCIter(RCTable);
  for (int *pInt = RCIter.home(); pInt; pInt = ++RCIter)
     *pInt = rc++;
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::MakeVertList() {
  VertList.Clear();
  TBlock *Entities = &DxfModel->BlockTable["Entities"];
  TLayIter LayIter(Entities->LayTable);
  if (LayIter.home()) do {
     string lname = *LayIter.currentID();
     if (!IsFeaLyer(lname)) continue;
     TVertIter VertIter(VertList);
     TVertIter LVerIter(LayIter.current()->VertList);
     VECTOR *pOld, *pNew;
     for (pNew = LVerIter.home(); pNew; pNew = ++LVerIter) {
        for (pOld = VertIter.home(); pOld; pOld = ++VertIter)
           if (*pOld == *pNew) break;
        if (!pOld) VertList.add(*pNew);
     }
  } while(LayIter.next());
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::MakeFaceTable() {
  FaceCount = BadCount = DupCount = 0;
  FaceTable.Clear();
  TBlock *Entities = &DxfModel->BlockTable["Entities"];
  TLayIter LayIter(Entities->LayTable);
  if (LayIter.home()) do {
     string lname = *LayIter.currentID();
     if (!IsFeaLyer(lname)) continue;
     BadCount += LayIter.current()->BadCount;
     DupCount += LayIter.current()->DupCount;
     TVertList *VList = &LayIter.current()->VertList;
     TFaceList *pFaceList = &FaceTable[lname];
     TFaceIter FaceIter(LayIter.current()->FaceList);
     for (TFace *pF = FaceIter.home(); pF; pF = ++FaceIter){
        TFace Face;
        TIndexIter IdxIter(*pF);
        for (DWORD *idx = IdxIter.home(); idx; idx = ++IdxIter){
           VECTOR *pV = VList->data(*idx);
           assert(pV);
           int idx = VertIndex(*pV);
           assert(idx);
           Face.AddVertex(idx);
        }
        pFaceList->add(Face);
        FaceCount++;
     }
  } while(LayIter.next());
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::MakeDFTable() {
  BadNodes = 0;
  DFTable.Clear();
  TBlock *Entities = &DxfModel->BlockTable["Entities"];
  TInsIter InsIter(Entities->InsList);
  if (InsIter.home()) do {
     TInsert *pIns = InsIter.current();
     if (pIns->bname == "FE-NODE") {
        int idx=VertIndex(VECTOR(pIns->x,pIns->y,pIns->z));
        if (!idx) BadNodes++;
        else DFTable[idx] = *pIns;
     }
  } while(InsIter.next());
}//---------------------------------------------------------
int __fastcall TDxfModCnvForm::VertIndex(VECTOR &v) {
  VECTOR *pV; int result = 1;
  TVertIter VertIter(VertList);
  for (pV = VertIter.home(); pV; pV = ++VertIter) {
     if (*pV == v) return result;
     result++;
  }
  return 0;
}//---------------------------------------------------------
void __fastcall TDxfModCnvForm::WriteMod(char *fname) {
  MakeRCTable();
  MakeVertList();
  MakeFaceTable();
  MakeDFTable();
  FILE *MOD = fopen(fname, "wt");
  fprintf(MOD,  "C**************************************************");
  fprintf(MOD,"\nC* Finite element interpreting of DXF files       *");
  fprintf(MOD,"\nC* Generated by utility of Ph.D. Shauki Z.Baghdadi*");
  fprintf(MOD,"\nC* COSMOS/M mod-file format                       *");
  fprintf(MOD,"\nC**************************************************");
  fprintf(MOD,"\nC* Total nodes .............. = %d", VertList.Count());
  fprintf(MOD,"\nC* Total shells ............. = %d", FaceCount);
  fprintf(MOD,"\nC* 3DFaces analysed ......... = %d", DxfModel->DxfFaceCount);
  fprintf(MOD,"\nC* Meshes  analysed ......... = %d", DxfModel->DxfMeshCount);
  fprintf(MOD,"\nC* Bad shells removed ....... = %d", BadCount);
  fprintf(MOD,"\nC* Duplicate shells removed . = %d", DupCount);
  fprintf(MOD,"\nC* Displaced node blocks .. . = %d", BadNodes);
  fprintf(MOD,"\nC* P R O P E R T I E S ============================");
  fprintf(MOD,"\nEG,   1, SHELL4T , 1, 0, 2, 0, 0, 0, 0, 0");
  fprintf(MOD,"\nEX,   1, 2.1E+05");
  fprintf(MOD,"\nNUXY, 1, 3.0E-01");
  fprintf(MOD,"\nGXY,  1, 8.0E+04");
  fprintf(MOD,"\nC* R E A L   C O N S T A N T S ====================");
  ChainIter<int, string> RCIter(RCTable);
  if (RCIter.home()) do {
     int rc = *RCIter.current();
     string lname = *RCIter.currentID();
     fprintf(MOD, "\nC* LAYER %s", lname.c_str());
     // LAYERNAME_THICK_15
     float t = atof(lname.substr(lname.rfind("_")+1).c_str());
     if (t<=0) t = 1;
     fprintf(MOD,"\nRC, 1, %d, %g", rc, t);
  } while(RCIter.next());
  fprintf(MOD,"\nC* N O D E S ======================================");
  VECTOR *pNode; int n = 1;
  TVertIter VertIter(VertList);
  for (pNode = VertIter.home(); pNode; pNode = ++VertIter)
     fprintf(MOD,"\nN,%d, %g,%g,%g",
                       n++, pNode->x, pNode->y, pNode->z);
  fprintf(MOD,"\nC* S H E L L S ====================================");
  int e = 1;
  if (FaceTable.home()) do {
     string lname = *FaceTable.currentID();
     fprintf(MOD,"\nACTIVE REAL %d", RCTable[lname]);
     TFaceIter FaceIter(*FaceTable.current());
     for (TFace *pF = FaceIter.home(); pF; pF = ++FaceIter){
        TIndexIter IdxIter(*pF);
        fprintf(MOD,"\nE,%d ", e++);
        int four = 0;
        for (DWORD *idx = IdxIter.home(); idx; idx = ++IdxIter) {
           fprintf(MOD,",%d", *idx);
           four++;
        }
        if (four < 4) fprintf(MOD,",%d", *IdxIter.home());
     }
  } while(FaceTable.next());
  fprintf(MOD,"\nC* B O U N D A R Y ================================");
  char *disp   = "UX UY UZ ROTX ROTY ROTZ";
  char *force  = "FX FY FZ";
  char *moment = "MX MY MZ";
  char *dtmpl  = "\nD,%d, %s,%g,,,,";
  char *ftmpl  = "\nF,%d, %s,%g,,,,";
  char *mtmpl  = "\nF,%d, %s,%g,,,,";
  if (DFTable.home()) do {
     float f;
     int n = *DFTable.currentID();
     TInsert *pIns = DFTable.current();
     TAttribIter AttIter(pIns->AttribList);
     if (AttIter.home()) do {
        string atname = *AttIter.currentID();
        string atval  = *AttIter.current();
        if (atval == "") continue;
        f = atof(atval.c_str());
        if (errno == ERANGE) continue;
        if (strstr(disp, atname.c_str()))
           fprintf(MOD, dtmpl , n, atname.c_str(), f);
        else
        if (strstr(force, atname.c_str()))
           fprintf(MOD, ftmpl , n, atname.c_str(), f);
        else
        if (strstr(moment, atname.c_str())) {
           //     if (atname == "MX") atname = "ROTX";
           //else if (atname == "MY") atname = "ROTY";
           //else if (atname == "MZ") atname = "ROTZ";
           fprintf(MOD, mtmpl , n, atname.c_str(), f);
        }
     } while (AttIter.next());
  } while (DFTable.next());

  fprintf(MOD, "\n\nRENUM ON");
  fclose(MOD);
}//---------------------------------------------------------
