//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\registry.hpp>
#pragma hdrstop

#include "Unit1.h"
#include "Unit2.h"
#include "Unit3.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TColorForm *ColorForm;

//---------------------------------------------------------------------------
__fastcall TColorForm::TColorForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::FormClick(TObject *Sender)
{
   ColorDialog1->Color = MainForm->Color;
   if (!ColorDialog1->Execute()) return;
   MainForm->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------
void TColorForm::SetEdit(TColor Color)
{
   for (int i=0; i<(MainForm->ComponentCount); i++)
      if (dynamic_cast<TEdit *>(MainForm->Components[i]))
         dynamic_cast<TEdit *>(MainForm->Components[i])->Color = Color;
      else if (dynamic_cast<TComboBox *>(MainForm->Components[i]))
         dynamic_cast<TComboBox *>(MainForm->Components[i])->Color = Color;
}

void __fastcall TColorForm::EditClick(TObject *Sender)
{
   ColorDialog1->Color = MainForm->NameEdit->Color;
   if (!ColorDialog1->Execute()) return;
   SetEdit(ColorDialog1->Color);
}
//---------------------------------------------------------------------------
void TColorForm::SetEditText(TColor Color)
{
   for (int i=0; i<(MainForm->ComponentCount); i++)
      if (dynamic_cast<TEdit *>(MainForm->Components[i]))
         dynamic_cast<TEdit *>(MainForm->Components[i])->Font->Color = Color;
      else if (dynamic_cast<TComboBox *>(MainForm->Components[i]))
         dynamic_cast<TComboBox *>(MainForm->Components[i])->Font->Color = Color;
}

void __fastcall TColorForm::EditTextClick(TObject *Sender)
{
   ColorDialog1->Color = MainForm->NameEdit->Font->Color;
   if (!ColorDialog1->Execute()) return;
   SetEditText(ColorDialog1->Color);
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::Label1Click(TObject *Sender)
{
   ColorDialog1->Color = MainForm->Label1->Font->Color;
   if (!ColorDialog1->Execute()) return;
   MainForm->Label1->Font->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::Label2Click(TObject *Sender)
{
   ColorDialog1->Color = MainForm->Label2->Font->Color;
   if (!ColorDialog1->Execute()) return;
   MainForm->Label2->Font->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------
void TColorForm::SetLabels(TColor Color)
{
   TColor Color1 = MainForm->Label1->Font->Color,
          Color2 = MainForm->Label2->Font->Color;
   for (int i=0; i<(MainForm->ComponentCount); i++)
      if (dynamic_cast<TLabel *>(MainForm->Components[i]))
         dynamic_cast<TLabel *>(MainForm->Components[i])->Font->Color = Color;
   MainForm->Label1->Font->Color = Color1;
   MainForm->Label2->Font->Color = Color2;
}

void __fastcall TColorForm::LabelsClick(TObject *Sender)
{
   ColorDialog1->Color = MainForm->Label3->Font->Color;
   if (!ColorDialog1->Execute()) return;
   SetLabels(ColorDialog1->Color);
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::OKClick(TObject *Sender)
{
   Close();
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::DefaultClick(TObject *Sender)
{
   MainForm->Color = MainForm->formColor;
   SetEdit(MainForm->editColor);
   SetEditText(MainForm->edittextColor);
   MainForm->Label1->Font->Color = MainForm->label1Color;
   MainForm->Label2->Font->Color = MainForm->label2Color;
   SetLabels(MainForm->labelsColor);
}
//---------------------------------------------------------------------------
void __fastcall TColorForm::SaveClick(TObject *Sender)
{
   // Saving colors in registry
   TRegIniFile *RegFile = new TRegIniFile("SOFTWARE\\Birthday Scanner");
   RegFile->WriteInteger("Colors","Form",MainForm->Color);
   RegFile->WriteInteger("Colors","Edit",MainForm->NameEdit->Color);
   RegFile->WriteInteger("Colors","EditText",MainForm->NameEdit->Font->Color);
   RegFile->WriteInteger("Colors","Label1",MainForm->Label1->Font->Color);
   RegFile->WriteInteger("Colors","Label2",MainForm->Label2->Font->Color);
   RegFile->WriteInteger("Colors","Labels",MainForm->Label3->Font->Color);
   RegFile->Free();
}
//---------------------------------------------------------------------------