/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.game.card.Card;
import com.rexbot.game.card.HandCalculator;
import com.rexbot.game.card.History;
import com.rexbot.game.card.Opts;
import com.rexbot.game.card.Palette;
import com.rexbot.game.card.Player;
import com.rexbot.game.card.Table;
import com.rexbot.game.card.commands.NewGameCommand;
import com.rexbot.game.card.commands.RunSimCommand;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLayeredPane;
import org.apache.log4j.Category;

public class Hand
extends JLayeredPane {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Hand == null ? (class$com$rexbot$game$card$Hand = Hand.class$("com.rexbot.game.card.Hand")) : class$com$rexbot$game$card$Hand);
    private int nextLayer = 0;
    private List cards = new ArrayList();
    private List showableCards = new ArrayList();
    public static int DEALER_HAND = 0;
    public static int PLAYER_HAND = 1;
    private int handType = PLAYER_HAND;
    private Table table = null;
    private Player player;
    private boolean faceUp = true;
    static /* synthetic */ Class class$com$rexbot$game$card$Hand;

    public Hand(int handType, Table table, Player player) {
        this.table = table;
        this.setPlayer(player);
        this.setMessage("", Color.black, Color.black);
        this.handType = handType;
        if (player != null) {
            player.setHand(this);
            if (!RunSimCommand.run && player.getNumber() != Opts.getInstance().getHumanPlayer()) {
                this.setFaceUp(false);
            }
        }
    }

    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        if (NewGameCommand.run && this.getPlayer() == null) {
            g2d.setColor(Palette.backgroundColor);
            g2d.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), 50, 50);
        }
        super.paint(g2d);
    }

    public void addCard(Card card, boolean show) {
        if (show) {
            History.getInstance().add((this.getPlayer() == null ? "Widow" : this.getPlayer().toString()) + " recieved " + card);
        }
        this.cards.add(card);
        if (show) {
            this.showableCards.add(card);
            card.setHand(this);
            this.setLayer(card, this.nextLayer++);
            int widthOverLay = 0;
            int heightOverLay = 0;
            this.add(card);
            if (this.handType == PLAYER_HAND) {
                widthOverLay = card.getOverlay();
                heightOverLay = card.getOverlay();
            }
            if (this.handType == DEALER_HAND) {
                widthOverLay = card.getOverlay() * 5;
                heightOverLay = 0;
            }
            for (int i = 0; i < this.showableCards.size(); ++i) {
                Card c = (Card)this.showableCards.get(i);
                c.setLocation(5 + i * widthOverLay, 5 + i * heightOverLay);
                c.setAlignmentX(i / widthOverLay);
                if (heightOverLay <= 0) continue;
                c.setAlignmentY(i / heightOverLay);
            }
            this.setPreferredSize(new Dimension(Math.abs((this.nextLayer + 7) * widthOverLay), Math.abs((this.nextLayer + 5) * heightOverLay)));
            this.setMinimumSize(new Dimension(Math.abs((this.nextLayer + 7) * widthOverLay), Math.abs((this.nextLayer + 5) * heightOverLay)));
            this.revalidate();
        }
        this.table.revalidate();
        long value = HandCalculator.getPokerValue(this.cards);
        this.setToolTipText("Total: " + HandCalculator.pokerValueToString(value) + " : " + value + ": " + this.cards.size() + ": " + this.cards);
    }

    public List getShowableCards() {
        return this.showableCards;
    }

    public List getCards() {
        return this.cards;
    }

    public Table getTable() {
        return this.table;
    }

    public double getPokerValue() {
        return HandCalculator.getPokerValue(this.cards);
    }

    public int getTotal() {
        int total = 0;
        int aces = 0;
        Iterator it = this.cards.iterator();
        while (it.hasNext()) {
            Card card = (Card)it.next();
            total += card.getAceHighValue();
            if (1 != card.getValue()) continue;
            ++aces;
        }
        for (int i = 0; i < aces; ++i) {
            if (total <= 21) continue;
            total -= 10;
        }
        return total;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isFaceUp() {
        if (Opts.getInstance().isAllCardsFaceUp()) {
            return true;
        }
        return this.faceUp;
    }

    public void setFaceUp(boolean faceUp) {
        this.faceUp = faceUp;
        this.repaint();
    }

    public void setMessage(String message, Color borderColor, Color textColor) {
        Player player = this.getPlayer();
        if (player != null) {
            player.setMessage(message, borderColor, textColor);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

