unit BinaryClock3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, Spin;

type
  TForm3 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioGroup2: TRadioGroup;
    Edit1: TEdit;
    Button1: TButton;
    CheckBox3: TCheckBox;
    Label3: TLabel;
    CheckBox4: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    SpinEdit3: TSpinEdit;
    SpinEdit4: TSpinEdit;
    SpinEdit5: TSpinEdit;
    SpinEdit6: TSpinEdit;
    SpinEdit7: TSpinEdit;
    Label1: TLabel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    CheckBox5: TCheckBox;
    Panel6: TPanel;
    Panel7: TPanel;
    Label2: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure SpinEdit4Change(Sender: TObject);
    procedure SpinEdit5Change(Sender: TObject);
    procedure SpinEdit6Change(Sender: TObject);
    procedure NewLights;
    procedure BitBtn2Click(Sender: TObject);
    procedure SpinEdit7Change(Sender: TObject);
    procedure Panel5Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Panel7MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure CheckBox5Click(Sender: TObject);
    procedure Panel7Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses BinaryClock2, BinaryClock1, BinaryClock4;

{$R *.DFM}

procedure TForm3.BitBtn1Click(Sender: TObject);
begin
   Application.HelpJump('Contents');
end;

procedure TForm3.Button2Click(Sender: TObject);
begin
   Halt;
end;

procedure TForm3.NewLights;  {Recolor according to new user settings}
begin
   LedOnIn  :=StringToColor('$00'+IntToHex(CB1,2)+IntToHex(CG1,2)+IntToHex(CR1,2));
   LedOnOut :=StringToColor('$00'+IntToHex(DB1,2)+IntToHex(DG1,2)+IntToHex(DR1,2));
   LedOffIn :=StringToColor('$00'+IntToHex(CB2,2)+IntToHex(CG2,2)+IntToHex(CR2,2));
   LedOffOut:=StringToColor('$00'+IntToHex(DB2,2)+IntToHex(DG2,2)+IntToHex(DR2,2));
   Label4.Font.Color:=LedOnIn;
   Label5.Font.Color:=LedOffIn;
end;


procedure TForm3.SpinEdit1Change(Sender: TObject);  {The following edits are for the LED colors}
begin
   try
      CR1:=SpinEdit1.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DR1:=CR1-75;
   if (DR1<0) then DR1:=0;
   NewLights;
end;


procedure TForm3.SpinEdit2Change(Sender: TObject);
begin
   try
      CG1:=SpinEdit2.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DG1:=CG1-75;
   if (DG1<0) then DG1:=0;
   NewLights;
end;

procedure TForm3.SpinEdit3Change(Sender: TObject);
begin
   try
      CB1:=SpinEdit3.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DB1:=CB1-75;
   if (DB1<0) then DB1:=0;
   NewLights;
end;

procedure TForm3.SpinEdit4Change(Sender: TObject);
begin
   try
      CR2:=SpinEdit4.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DR2:=CR2-75;
   if (DR2<0) then DR2:=0;
   NewLights;
end;

procedure TForm3.SpinEdit5Change(Sender: TObject);
begin
   try
      CG2:=SpinEdit5.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DG2:=CG2-75;
   if (DG2<0) then DG2:=0;
   NewLights;
end;

procedure TForm3.SpinEdit6Change(Sender: TObject);
begin
   try
      CB2:=SpinEdit6.value;
   except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
   end;
   DB2:=CB2-75;
   if (DB2<0) then DB2:=0;
   NewLights;
end;

procedure TForm3.BitBtn2Click(Sender: TObject);  {Resets LED to default color and size}
begin
   CR1:=200;CB1:=1;CG1:=1;CR2:=125;CB2:=1;CG2:=1;
   DR1:=125;DB1:=0;DG1:=0;DR2:=50;DB2:=0;DG2:=0;
   Form3.SpinEdit1.Value:=CR1;
   Form3.SpinEdit2.Value:=CG1;
   Form3.SpinEdit3.Value:=CB1;
   Form3.SpinEdit4.Value:=CR2;
   Form3.SpinEdit5.Value:=CG2;
   Form3.SpinEdit6.Value:=CB2;
   LEDSize:=16;
   Form3.SpinEdit7.Value:=LEDSize;
   NewLights;
end;

procedure TForm3.SpinEdit7Change(Sender: TObject);
begin
  try
     LEDSize:=SpinEdit7.value;
  except
      on EConvertError do  ShowMessage('Invalid number entered! Valid range is 0 to 255.');
  end;


end;

procedure TForm3.Panel5Click(Sender: TObject);
begin
  Halt;
end;

procedure TForm3.CheckBox3Click(Sender: TObject);
begin
   If (Moveable=true) then Moveable:=false
   else Moveable:=true;
end;


procedure TForm3.RadioGroup2Click(Sender: TObject);
begin
   If (RadioGroup2.ItemIndex=0) then Back:=0;
   If (RadioGroup2.ItemIndex=1) then Back:=1;
   If (RadioGroup2.ItemIndex=2) then Back:=2;
end;

procedure TForm3.Edit1Change(Sender: TObject);
begin
  PicStr:=Edit1.Text;
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  Label4.Font.Color:=LedOnIn;
  Label5.Font.Color:=LedOffIn;
  Form3.SpinEdit1.Value:=CR1;
  Form3.SpinEdit2.Value:=CG1;
  Form3.SpinEdit3.Value:=CB1;
  Form3.SpinEdit4.Value:=CR2;
  Form3.SpinEdit5.Value:=CG2;
  Form3.SpinEdit6.Value:=CB2;
  Form3.SpinEdit7.Value:=LEDSize;

  if (TempStr1='false') then
     begin
         Form3.CheckBox3.Checked:=false;
         Moveable:=false;
     end
  else
     begin
         Form3.CheckBox3.Checked:=true;
         Moveable:=true;
     end;

  if (TempStr2='true') then
     begin
         Form3.CheckBox1.Checked:=true;
         UpperDisplay:=true;
     end
  else
     begin
         Form3.CheckBox1.Checked:=false;
         UpperDisplay:=false;
     end;

  if (TempStr3='false') then
     begin
         Form3.CheckBox4.Checked:=false;
         Colons:=false;
     end
  else
     begin
         Form3.CheckBox4.Checked:=true;
         Colons:=true;
     end;

  if (TempStr4='false') then
     begin
         Form3.CheckBox2.Checked:=false;
         Seconds:=false;
     end
  else
     begin
         Form3.CheckBox2.Checked:=true;
         Seconds:=true;
     end;

  if (TempStr5='false') then
     begin
         Form3.CheckBox5.Checked:=false;
         PMLite:=false;
     end
  else
     begin
         Form3.CheckBox5.Checked:=true;
         PMLite:=true;
     end;

  if (Back=0) then Form3.RadioGroup2.ItemIndex:=0;
  if (Back=1) then
      begin
         Form3.RadioGroup2.ItemIndex:=1;
         Form3.Edit1.Text:=PicStr;
      end;
   if (Back=2) then Form3.RadioGroup2.ItemIndex:=2;

   Edit1.Text:=PicStr;

end;


procedure TForm3.Panel7MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   Form1.RepaintForm;
end;

procedure TForm3.CheckBox5Click(Sender: TObject);
begin
  If (PMLite=true) then PMLite:=false
  else PMLite:=true;
end;

procedure TForm3.Panel7Click(Sender: TObject);
begin
   If (CheckBox1.Checked=true) then
      begin
         UpperDisplay:=true;
         Form1.Image1DblClick(Form3);
      end
   else
      begin
         UpperDisplay:=false;
         Form1.Image1DblClick(Form3);
      end;

   if (Back=0) then
      begin
         Form1.Image1.Picture:=Form1.Image2.Picture;
      end;

   If (CheckBox2.Checked=true) then Seconds:=true
   else Seconds:=false;

   If (CheckBox4.Checked=true) then Colons:=true
   else Colons:=false;

   If (CheckBox5.Checked=true) then PMLite:=true
   else PMLite:=false;

   Form1.RepaintForm;
   Form1.RepaintForm;

end;



procedure TForm3.Button1Click(Sender: TObject);
begin
  Form4.visible:=true;
end;

procedure TForm3.CheckBox1Click(Sender: TObject);
begin
   If (UpperDisplay=true) then UpperDisplay:=false
   else UpperDisplay:=true;

end;

procedure TForm3.CheckBox2Click(Sender: TObject);
begin
   If (Seconds=true) then Seconds:=false
   else Seconds:=true;

end;

procedure TForm3.CheckBox4Click(Sender: TObject);
begin
   If (Colons=true) then Colons:=false
   else Colons:=true;

end;

end.
