// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: grocery.h 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/18/1997
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program use to test the Persistent base class.
*/
// ----------------------------------------------------------- //   
#ifndef __GROCERY_HPP__
#define __GROCERY_HPP__

#include "gpersist.h"
#include "gxfloat.h"

// Type definitions
typedef char * Name_t;         // String type
typedef gxFLOAT64 Price_t;     // Floating point type         
typedef gxINT32 StockNumber_t; // Integer type

// Constants
const unsigned MAX_NAME_LENGTH = 64;   // Max object name length
const gxClassID ClassGroceryID = 1024; // Arbitrary class ID
const Name_t null_name = 0;            // Value used for null item names 

// Primary key type used by this database
struct GroceryKey_t
{
  char object_name[MAX_NAME_LENGTH]; // Object name
  gxObjectID object_id; // Object data file address/identification number
  gxClassID class_id;   // Object class identification number
};

// Primary key class used by this database 
class GroceryKey : public DatabaseKeyB
{
public:
  GroceryKey();
  GroceryKey(const char *name, gxObjectID oid = (gxObjectID_t)0,
	     gxClassID cid = (gxClassID_t)0);
  
public: // Base class interface
  size_t KeySize() { return sizeof(key); }
  int operator==(const DatabaseKeyB& k) const;
  int operator>(const DatabaseKeyB& k) const;

public:
  char *ObjectName() { return key.object_name; }
  gxObjectID ObjectID() const { return key.object_id; }
  gxClassID ClassID() const { return key.class_id; }
  void SetObjectName(const char *s);
  void SetObjectID(gxObjectID oid) { key.object_id = oid; }
  void SetClassID(gxClassID cid) { key.class_id = cid; }
  
private:
  GroceryKey_t key;
};

// Persistent object database
class Grocery : public gxPersistent
{ 
public:
  Grocery(POD *pod) : gxPersistent(pod) {
    name = null_name; stock_number = (StockNumber_t)0; price = (Price_t)0;
  }
  Grocery(const POD *pod) : gxPersistent(pod) {
    name = null_name; stock_number = (StockNumber_t)0; price = (Price_t)0;
  }
  Grocery() {
    name = null_name; stock_number = (StockNumber_t)0; price = (Price_t)0;
  }
  
public:
  StockNumber_t StockNumber() { return stock_number; }
  Price_t Price() { return price; }
  Name_t Name() { return name; }
  void SetStockNumber(StockNumber_t n) { stock_number = n; }
  void SetPrice(Price_t p) { price = p; }
  void SetName(Name_t n) { name = n; }
  void ClearName();

public: // Database utility functions
  int CompareIndex(unsigned index_number);
  int RebuildIndexFile(const char *fname, unsigned index_number,
		       int num_trees, BtreeNodeOrder_t node_order);

public: // Runtime type information functions
  gxClassID GetClassID() { return ClassGroceryID; }
  const char *GetClassName() { return (const char *)"Class Grocery"; }
  
private: // Base class interface
  virtual gxDatabaseError Write();
  virtual gxDatabaseError Read(FAU Address);
  virtual int Find();
  virtual int Delete();
  virtual __UWORD__ ObjectLength();

private:
  Name_t name;
  StockNumber_t stock_number; 
  Price_t price;
};

#endif // __GROCERY_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
