// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Author: Doug Gaer 
// File Creation Date: 11/29/1996  
// Date Last Modified: 06/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the gxString class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxstring.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  cout << "Testing constructors..." << endl;

  gxString a("The quick brown fox jumps over the lazy dog");
  cout << a << endl;
  
  gxString b;

  gxString c("This is a test");
  cout << c << endl;

  cout << "Copy constructing a string..." << endl;
  gxString d(c);
  cout << d << endl;

  cout << endl;
  cout << "Testing overloaded assignment operators..." << endl;
  b = a;
  cout << b << endl;
  b = c;
  cout << b << endl;
  b = "0123456789";
  cout << b << endl;
  
  cout << endl;
  cout << "Testing copy constructor..." << endl;
  gxString aa(a);
  cout << aa << endl;
  gxString bb(b);
  cout << bb << endl;

  PausePrg();

  cout << "Testing overloaded += operator..." << endl;
  gxString buf(" 0123456789");
  a += buf;
  cout << a << endl;
  c += " message";
  cout << c << endl;
  c += 'X';
  cout << c << endl;

  PausePrg();

  cout << "Testing concatenation..." << endl;
  gxString s1("String 1"), s2("String 2");
  char *str3 = " and String 3";
  s1.Cat(" and ", 5);
  s1 += s2;
  cout << s1 << endl; 
  s1.Cat(str3);
  cout << s1 << endl;

  PausePrg();
  
  cout << "Testing find functions..." << endl;
  if(s1.Find("xyz") == -1)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  if(s1.Find(str3, strlen(str3)) == -1)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  if(s1.Find(s2) == -1)
    cout << "Pattern not found!" << endl;
  else
    cout << "Pattern found." << endl;

  cout << "Testing repeated pattern finding..." << endl;
  s1 = "This is a test message";
  unsigned Offset = 0;
  while(1) {
    Offset = s1.Find("is", Offset);
    if (Offset == -1) break;
    cout << "Pattern match found at index: " << Offset << endl;
    Offset++;
  }

  PausePrg();

  cout << "Testing delete function..." << endl;
  gxString x1("The quick brown fox jumps over the lazy dog");
  cout << x1 << endl;
  char *xx = "fox";
  int Index = x1.Find(xx);
  cout << "Deleting fox from string..." << endl;
  x1.DeleteAt(Index, strlen(xx));
  cout << x1 << endl;

  PausePrg();
  
  cout << "Testing replace functions..." << endl;
  x1 = "The quick brown fox jumps over the lazy dog";
  cout << x1 << endl;
  char *xy = "cat";
  Index = x1.Find(xx);
  cout << "Replacing fox:" << endl;
  x1.ReplaceAt(Index, xy, strlen(xy));  
  cout << x1 << endl;
  cout << "Replacing jumps:" << endl;
  Index = x1.Find("jumps");
  x1.ReplaceAt(Index, "runs ");
  cout << x1 << endl;
  gxString x2("cow");
  cout << "Replacing dog:" << endl;
  Index = x1.Find("dog");
  x1.ReplaceAt(Index, x2);
  cout << x1 << endl;
  
  PausePrg();
  
  cout << "Testing the insert functions..." << endl;
  x1 = "The quick brown fox jumps over the lazy dog";
  cout << x1 << endl;
  char *xz = "and yellow ";
  cout << "Inserting text into string:" << endl;
  Index = x1.Find(xx);
  x1.InsertAt(Index, xz, strlen(xz));
  cout << x1 << endl;
  Index = x1.Find("over");
  x1.InsertAt(Index, "around and ");
  cout << x1 << endl;
  gxString x3("cow and ");
  Index = x1.Find("dog");
  x1.InsertAt(Index, x3);
  cout << x1 << endl;
  
  PausePrg();
  
  cout << "Testing c_str functions" << endl;
  gxString gs("COW");
  const gxString &cs = gs;
  cout << "String = " << gs.c_str() << endl;
  cout << "Const String = " << cs.c_str() << endl;
  PausePrg();
  
  cout << "Testing overload subscript operator..." << endl;
  char *Message = "This is a test message";
  gxString ss(Message);
  for(unsigned i = 0; i < strlen(Message); i++)
    cout << ss[i];
  cout << endl;
  
  PausePrg();

  cout << "Testing general-purpose filter funftions" << endl;
  cout << endl;
  
    gxString s("         ?The quick brown fox jumps over the lazy dog\n\r\
0123456789\r\n?~!@#$%^&*()_+<>            ");

  unsigned num;
  cout << "Original string: " << endl;
  cout << s.c_str() << endl;
  cout << endl;

  cout << "Trimming all leading and trailing spaces" << endl;
  cout << "begin" << s.c_str() << "end" << endl;
  num = s.TrimLeadingSpaces();
  cout << "Leading spaces = " << num << endl;
  cout << s.c_str() << endl;
  num = s.TrimTrailingSpaces();
  cout << "Trialing spaces = " << num << endl;
  cout << s.c_str();
  cout << "end";

  PausePrg();
  
  cout << "Changing to upper case" << endl;
  if(s.ToUpper()) cout << s.c_str() << endl;
  cout << "Changing to lower case" << endl;
  if(s.ToLower()) cout << s.c_str() << endl;

  PausePrg();
  
  cout << "Replacing carriage returns/line feeds with spaces" << endl;
  num = s.ReplaceChar('\r', ' ');
  num = s.ReplaceChar('\n', ' ');
  cout << s.c_str() << endl;

  PausePrg();
  
  cout << "Filtering all \'?\' characters" << endl;
  num = s.FilterChar('?');
  cout << s.c_str() << endl;

  PausePrg();
  
  cout << "Filtering the \"he\" string" << endl;
  s.FilterString("he");
  cout << s.c_str() << endl;
  
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
