// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: eds101.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 10/15/1999 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to generate platform dependent randomly encrypted 
data sets.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_EDS101_HPP__
#define __GX_EDS101_HPP__

// ---------------------------------------------------------------------
// Global and type defines constants for current EDS version 
// ---------------------------------------------------------------------
typedef unsigned short edsWORD; // Data type used for encrypted characters
const unsigned long edsRandomSeed = 123494; // Default random seed
const unsigned edsTableSize = 256;          // Size of EDS tables
const unsigned edsMaxLine = 255;            // Max chars per line
const edsWORD edsEOT = 0x0000;              // End of text marker
const double edsVersionNumber = 4000.101;   // Current version number

// Class used to read and write encrypted data sets strings
class edsString
{
public:
  edsString();
  virtual ~edsString();
  edsString(const edsString &ob);
  edsString operator=(const edsString &ob);
  
public:
  edsWORD GenRandomNumber();
  void InitDynamicTable(unsigned long r_seed = edsRandomSeed);
  void LoadStaticTable();
  edsWORD EncryptString(unsigned char c);
  int DecryptString(edsWORD val, unsigned char &c);
  
protected:
  void TestDynamicTable();
  void edsCopy(const edsString &ob);
  
public:
  edsWORD eds_table[edsTableSize]; // Dynamic table
};

#ifdef __USE_EDS_TEST_FUNCTIONS__
// Standalone functions used to create and test static encryption tables
#include <iostream.h>
int edsPrintStaticEncryptionTable(ostream &stream);
int edsTestStaticEncryptionTable(ostream &stream);
#endif // __USE_EDS_TEST_FUNCTIONS__

#endif // __GX_EDS101_HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
