// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Header File Name: htmldrv.h 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 03/09/1999 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The HyperTextDrv and HyperText class is used to create HTML
documents. The HyperTextDrv class is a base class that uses
the C++ ostream library to write HTML tags and text to a
specified stream. The HyperText class is used to write
HTML document templates to a specified stream,
*/
// ----------------------------------------------------------- //   
#ifndef __GX_HTMLDRV_HPP__
#define __GX_HTMLDRV_HPP__

#include <fstream.h>

// Constants
const int DefaultPrecision = 2; // Default precision for floating points

// Define some common HTML colors
const int NumHTMLColors = 16;
enum htmCOLORS { 
  htmBLACK       = 0x000000,
  htmDARKBLUE    = 0x000080,
  htmBLUE        = 0x0000ff,
  htmGREEN       = 0x008000,
  htmTEAL        = 0x008080,
  htmBRIGHTGREEN = 0x00ff00,
  htmTURQUOISE   = 0x00ffff,
  htmDARKRED     = 0x800000,
  htmVIOLET      = 0x800080,
  htmDARKYELLOW  = 0x808000,
  htmDARKGRAY    = 0x808080,
  htmGRAY        = 0xC0C0C0,
  htmRED         = 0xff0000,
  htmPINK        = 0xff00ff,
  htmYELLOW      = 0xffff00,
  htmWHITE       = 0xffffff
};

// Define some common HTML fonts
const int NumHTMLFonts = 4;
enum htmFONTS {
  htmARIAL,       // Arial
  htmARIALBLACK,  // Arial Black
  htmARIALNARROW, // Arial Narrow
  htmCOURIER      // Courier New
};

// Functions used to print characters with special meaning 
inline ostream& lt(ostream &s)   { return s << "<";  } // Less than sign
inline ostream& gt(ostream &s)   { return s << ">";  } // Greater than sign
inline ostream& amp(ostream &s)  { return s << "&";  } // Ampersand
inline ostream& quot(ostream &s) { return s << "\""; } // Double quote sign

// Functions used to print special characters
inline ostream& nbsp(ostream &s) { return s << "&nbsp;"; }   //Non-brk space
inline ostream& hyphen(ostream &s) { return s << "&shy;"; }  // Soft-hyphen
inline ostream& copyright(ostream &s) { return s << "&copy;"; } 
inline ostream& registered(ostream &s) { return s << "&reg;"; }

// Functions used to create HMTL tags
inline ostream& stag(ostream &s) { return s << "<";  } // Start tag  
inline ostream& etag(ostream &s) { return s << "</"; } // End tag
inline ostream& ctag(ostream &s) { return s << ">";  } // Close tag 

// HTML document formatting functions
inline ostream& anchor(ostream &s) { return s << "<A>"; }
inline ostream& eanchor(ostream &s) { return s << "</A>"; }
inline ostream& comment(ostream &s) { return s << "<!-- "; }
inline ostream& ecomment(ostream &s) { return s << " -->"; }
inline ostream& body(ostream &s) { return s << "<BODY>"; }
inline ostream& ebody(ostream &s) { return s << "</BODY>"; }
inline ostream& br(ostream &s) { return s << "<BR>"; }
inline ostream& head(ostream &s) { return s << "<HEAD>"; }
inline ostream& ehead(ostream &s) { return s << "</HEAD>"; }
inline ostream& html(ostream &s) { return s << "<HTML>"; }
inline ostream& ehtml(ostream &s) { return s << "</HTML>"; }
inline ostream& hr(ostream &s) { return s << "<HR>"; }
inline ostream& par(ostream &s) { return s << "<P>"; }     
inline ostream& epar(ostream &s) { return s << "</P>"; }   
inline ostream& pre(ostream &s) { return s << "<PRE>"; }   
inline ostream& epre(ostream &s) { return s << "</PRE>"; } 
inline ostream& title(ostream &s) { return s << "<TITLE>"; }
inline ostream& etitle(ostream &s) { return s << "</TITLE>"; }

// HTML font formatting functions
inline ostream& bold(ostream &s) { return s << "<B>"; } 
inline ostream& ebold(ostream &s) { return s << "</B>"; } 
inline ostream& center(ostream &s) { return s << "<CENTER>"; } 
inline ostream& ecenter(ostream &s) { return s << "</CENTER>"; } 
inline ostream& font(ostream &s) { return s << "<FONT>"; }
inline ostream& efont(ostream &s) { return s << "</FONT>"; }
inline ostream& h1(ostream &s) { return s << "<H1>"; } 
inline ostream& eh1(ostream &s) { return s << "</H1>"; } 
inline ostream& h2(ostream &s) { return s << "<H2>"; } 
inline ostream& eh2(ostream &s) { return s << "</H2>"; } 
inline ostream& h3(ostream &s) { return s << "<H3>"; } 
inline ostream& eh3(ostream &s) { return s << "</H3>"; }
inline ostream& italic(ostream &s) { return s << "<I>"; }
inline ostream& eitalic(ostream &s) { return s << "</I>"; }
inline ostream& underline(ostream &s) { return s << "<U>"; }
inline ostream& eunderline(ostream &s) { return s << "</U>"; }

// HTML table functions
inline ostream& table(ostream &s) { return s << "<TABLE>"; } 
inline ostream& otable(ostream &s) { return s << "<TABLE "; } 
inline ostream& etable(ostream &s) { return s << "</TABLE>"; } 
inline ostream& tr(ostream &s) { return s << "<TR>"; } 
inline ostream& etr(ostream &s) { return s << "</TR>"; } 
inline ostream& th(ostream &s) { return s << "<TH>"; } 
inline ostream& eth(ostream &s) { return s << "</TH>"; } 
inline ostream& td(ostream &s) { return s << "<TD>"; } 
inline ostream& etd(ostream &s) { return s << "</TD>"; } 

// HTML driver base class
class HyperTextDrv
{
public:
  HyperTextDrv(ostream &s);
  virtual ~HyperTextDrv();

protected: // Filtered output functions used to write HTML text 
  virtual void WriteString(const char *s);
  virtual void WriteChar(const unsigned char c) const;

public: // Functions used to write built-in data types 
  void Write(const char c) const;
  void Write(const unsigned char c) const;
  void Write(char c);
  void Write(unsigned char c);
  void Write(const char *s);
  void Write(char *s);
  void Write(const unsigned char *s);
  void Write(unsigned char *s);
  void Write(const long val) const;
  void Write(long val);
  void Write(const unsigned long val) const;
  void Write(unsigned long val);
  void Write(const int val) const;
  void Write(int val);
  void Write(const unsigned int val) const;
  void Write(unsigned int val);
  void Write(double val); 
  void Write(const double val) const; 
  void Write(float val); 
  void Write(const float val) const; 

public: 
  void precision(int p) { dec_precision = p; } // Floating precision
  void eat_space() { non_breaking_sp = 1; }    // Use non-breaking spaces
  void put_space() { non_breaking_sp = 0; }    // Use breaking spaces
  
public: // Overloaded operators
  ostream &operator<<(ostream & (*_f)(ostream&));
  HyperTextDrv &operator<<(char *s);
  HyperTextDrv &operator<<(const char *s);
  HyperTextDrv &operator<<(unsigned char *s);
  HyperTextDrv &operator<<(const unsigned char *s);
  HyperTextDrv &operator<<(char c);
  const HyperTextDrv &operator<<(const char c) const;
  HyperTextDrv &operator<<(unsigned char c);
  const HyperTextDrv &operator<<(const unsigned char c) const;
  HyperTextDrv &operator<<(long val);
  const HyperTextDrv &operator<<(const long val) const;
  HyperTextDrv &operator<<(unsigned long val);
  const HyperTextDrv &operator<<(const unsigned long val) const;
  HyperTextDrv &operator<<(int val);
  const HyperTextDrv &operator<<(const int val) const;
  HyperTextDrv &operator<<(unsigned int val);
  const HyperTextDrv &operator<<(const unsigned int val) const;
  const HyperTextDrv &operator<<(const float val) const;
  HyperTextDrv &operator<<(float val);
  const HyperTextDrv &operator<<(const double val) const;
  HyperTextDrv &operator<<(double val);
  
public: // HTML document formatting functions
  void ANCHOR(const char *s) { *(stream) << "<A" << s << ">"; }
  void ANCHOR(char *s) { *(stream) << "<A" << s << ">"; }
  void BODY(const char *s) { *(stream) << "<BODY " << s << ">"; }
  void BODY(char *s) { *(stream) << "<BODY " << s << ">"; }
  void COMMENT(const char *s) { *(stream) << "<!-- " << s << " -->"; }
  void COMMENT(char *s) { *(stream) << "<!-- " << s << " -->"; }
  void PAR(const char *s) { *(stream) << "<P " << s << ">"; }
  void PAR(char *s) { *(stream) << "<P " << s << ">"; }
  
public: // HTML font formatting functions
  void BOLD(const char *s) { *(stream) << "<B>" << s << "</B>"; } 
  void BOLD(char *s) { *(stream) << "<B>" << s << "</B>"; } 
  void CENTER(const char *s) { *(stream) << "<CENTER>" << s << "</CENTER>"; } 
  void CENTER(char *s) { *(stream) << "<CENTER>" << s << "</CENTER>"; } 
  void FONT(const char *s) { *(stream) << "<FONT " << s << ">"; }
  void FONT(char *s) { *(stream) << "<FONT " << s << ">"; }
  void H1(const char *s) { *(stream) << "<H1>" << s << "</H1>"; } 
  void H1(char *s) { *(stream) << "<H1>" << s << "</H1>"; } 
  void H2(const char *s) { *(stream) << "<H2>" << s << "</H2>"; } 
  void H2(char *s) { *(stream) << "<H2>" << s << "</H2>"; } 
  void H3(const char *s) { *(stream) << "<H3>" << s << "</H3>"; } 
  void H3(char *s) { *(stream) << "<H3>" << s << "</H3>"; } 
  void ITALIC(const char *s) { *(stream) << "<I>" << s << "</I>"; }
  void ITALIC(char *s) { *(stream) << "<I>" << s << "</I>"; }
  void UNDERLINE(const char *s) { *(stream) << "<U>" << s << "</U>"; }
  void UNDERLINE(char *s) { *(stream) << "<U>" << s << "</U>"; }
  
public: // HTML table functions
  void TABLE(const char *s) { *(stream) << "<TABLE " << s << ">"; } 
  void TABLE(char *s) { *(stream) << "<TABLE " << s << ">"; } 
  void TD(const char *s) { *(stream) << "<TD " << s << ">"; }
  void TD(char *s) { *(stream) << "<TD " << s << ">"; }
  void TH(const char *s) { *(stream) << "<TH " << s << ">"; }
  void TH(char *s) { *(stream) << "<TH " << s << ">"; }
  void TR(const char *s) { *(stream) << "<TR " << s << ">"; }
  void TR(char *s) { *(stream) << "<TR " << s << ">"; }

protected:
  ostream *stream;     // Stream to output HTML data
  int dec_precision;   // Decimal point precision for floating points  
  int non_breaking_sp; // True if using non-breaking spaces
};

class HyperText : public HyperTextDrv
{
public:
  HyperText(ostream &s) : HyperTextDrv(s) { }
  ~HyperText() { }
  
public: // Functions used to create HTML document templates
  void Prologue(const char *doc_title = 0);
  void StartBody(const char *parameters = 0);
  void StartBody(htmCOLORS color = htmWHITE);
  void Epilogue();
  void DocHeader(const char *doc_title = 0);
  void DocTrailer();
  
public: // Table Functions
  void GenTable(int cell_spacing = 1, int cell_padding = 4, int width = 75,
		int border = 1, htmCOLORS bordercolor = htmBLACK); 
  void StartTableRow();
  void EndTableRow() { *(stream) << etr << endl; }
  void TableHeader(char *valign="CENTER", int colspan = 1, int rowspan = 1,
		   int width = 10);
  void EndTableHeader() { *(stream) << eth << endl; }
  void TableData(char *valign="TOP", int colspan = 1, int rowspan = 1,
		 int width = 10);
  void EndTableData() { *(stream) << etd << endl; }
  void EndTable() { *(stream) << etable << endl; }
  
public: // Reporting functions
  void GetSystemTime(char *s, int full_month_name = 1);
};

#endif  // __GX_HTMLDRV_HPP__ 
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

