// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: fstring.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/21/1997
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Fixed length string class used by database key types or members 
that must be fixed in length.
*/
// ----------------------------------------------------------- // 
#include "fstring.h"

// Initialize FString Global Variables
int FStringCaseCompare = 1;

void FString::Clear()
{
  for(unsigned i = 0; i < FStringLength; i++) sptr[i] = 0;
}

int FString::SetString(const char *s, unsigned bytes)
// Set the string value for this object. This function will truncate 
// the number of bytes requested if the number of bytes exceeds maximum
// fixed string length. Returns true if successful or false if the 
// string was truncated. NOTE: The FString class guarantees that each
// string object is unique by storing a unique copy of the string with
// each object. This ensures that FString objects can be safely copy
// constructed, assigned, resized, and deleted by multiple threads.
// Multiple threads accessing shared memory segments must be handled
// by the application.
{
  // Calculate the length of this string if no bytes size is specified
  if(bytes == 0) bytes = strlen(s);
  int truncate = 0;  
  if(bytes > FStringLength) {
    bytes = FStringLength;
    truncate = 1;
  }
  memmove(sptr, s, bytes);
  sptr[bytes] = 0; // Null terminate the string
  return truncate == 0;
}

void FString::Copy(const FString &s)
{
  memmove(sptr, s.sptr, s.length());
  sptr[s.length()] = 0; // Null terminate the string
}

FString *FString::strdup()
// Returns a duplicate string object or a null value if an error
// occurs.
{
  return (FString *)new FString(sptr);
}

FString *FString::strdup() const
// Returns a duplicate string object or a null value if an error
// occurs.
{
  return (FString *)new FString(sptr);
}

int operator==(const FString &a, const FString &b) 
{
  if(FStringCaseCompare)
    return strcmp(a.sptr, b.sptr) == 0;
  else
    return CaseICmp(a, b) == 0;
}

int operator<(const FString &a, const FString &b) 
{
  if(FStringCaseCompare)
    return strcmp(a.sptr, b.sptr) < 0;
  else
    return CaseICmp(a, b) < 0;
}

int operator>(const FString &a, const FString &b) 
{
  if(FStringCaseCompare)
    return strcmp(a.sptr, b.sptr) > 0;
  else
    return CaseICmp(a, b) > 0;
}

int operator!=(const FString &a, const FString &b) 
{
  if(FStringCaseCompare)
    return strcmp(a.sptr, b.sptr) != 0;
  else
    return CaseICmp(a, b) != 0;
}

int CaseICmp(const FString &s1, const FString &s2)
{
  return CaseICmp(s1.c_str(), s2.c_str()); 
}

int CaseICmp(FString &s1, FString &s2)
{
  return CaseICmp(s1.c_str(), s2.c_str()); 
}

int CaseICmp(const FString &s1, const char *s)
{
  return CaseICmp(s1.c_str(), s); 
}

int CaseICmp(const char *s, const FString &s2)
{
  return CaseICmp(s, s2.c_str()); 
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
