// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: gxderror.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/14/1996  
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The gxdError functions and classes are used to catch and/or
record database exceptions that occur during run-time. This
implementation can be used with or without C++ built-in exception
handling. If C++ exception handling is not enabled with the
__CPP_EXCEPTIONS__ macro, then the gxDatabaseError enumerated
constants can be used to record database errors.
*/
// ----------------------------------------------------------- // 
#include "gxderror.h"

// NOTE: This array must contain the same number of exceptions as the
// gxDatabaseError enumeration. 
const int gxdMaxExceptionMessages = 48;
const char *gxdExceptionMessages[gxdMaxExceptionMessages] = {
  "Database exception: No exception reported",               // None
  "Database exception: Invalid error code reported",         // Invalid
  "Database exception: Access Violation",                    // AccessViolation
  "Database exception: Assertion failed",                    // AssertError
  "Database exception: Wrong object type",                   // BadClassID
  "Database exception: Bad object address",                  // BadObjectAddr
  "Database exception: Bad reference",                       // BadReference
  "Database exception: Block allocation error",              // BlockAllocError
  "Database exception: Cache full",                          // CacheFull
  "Database exception: Checksum error",                      // ChecksumError
  "Database exception: Divide by zero error",                // DivideByZero
  "Database exception: Duplicate entry error",               // DupEntryError
  "Database exception: Specified entry was not found",       // EntryNotFound
  "Database exception: Unexpected end of file was reached",  // EOFError
  "Database exception: Error closing file",                  // FileCloseError
  "Database exception: File is corrupt",                     // FileCorrupt
  "Database exception: Error creating file",                 // CreationError
  "Database exception: File already exists",                 // FileExists
  "Database exception: Trying to use a closed file",         // FileNotOpenErr
  "Database exception: File not ready for reading/writing",  // FileNotReady
  "Database exception: Could not write to file",             // NotWriteable
  "Database exception: Error opening file",                  // FileOpenError
  "Database exception: Cannot obtain a file position",       // FilePostionErr
  "Database exception: Error reading from file",             // FileReadError
  "Database exception: Error seeking in file",               // FileSeekError
  "Database exception: Error writing to file",               // FileWriteError
  "Database exception: Error inserting database entry",      // InsertionError
  "Database exception: Memory allocation error",             // MemoryAllocErr
  "Database exception: No database open",                    // NoDatabaseOpen
  "Database exception: No such file exists",                 // NoFileExists
  "Database exception: No objects exist",                    // NoObjectsExist
  "Database exception: Accessing a null pointer",            // NullPtr
  "Database exception: Object already exists",               // ObjectExists
  "Database exception: Another object is referencing this file", // Referenced
  "Database exception: Math overflow error",                 // OverFlow
  "Database exception: Parse error",                         // ParseError
  "Database exception: Invalid path",                        // PathError
  "Database exception: Trying to write to a read-only file", // ReadOnlyFile
  "Database exception: Stack empty",                         // StackEmpty
  "Database exception: Stack full",                          // StackFull
  "Database exception: Synchronization Error",               // SyncError    
  "Database exception: Math under-flow error",               // UnderFlow
  "Database exception: Wrong file type",                     // WrongFileType

  // Persistent lock error messages
  "Database exception: Invalid lock type specified",          // LOCK_TYPE
  "Database exception: Cannot access the file lock header",   // FLK_ACCESS
  "Database exception: Cannot lock the file",                 // FLK_ERROR
  "Database exception: Cannot access the record lock header", // RLK_ACCESS
  "Database exception: Cannot lock the specified record"      // RLK_ERROR
};

const char *gxDatabaseExceptionMessage(gxDatabaseError err)
// Standalone function that returns a null terminated string that can
// be use to log or print a database exception message.
{
  int error = (int)err;
  if(error > gxdMaxExceptionMessages) error = gxDBASE_INVALID_CODE;

  // Find the corresponding message in the exception array
  return gxdExceptionMessages[error];
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

