// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- //
// C++ Source Code File Name: gxdstats.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 02/03/1997  
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

The database file statistics functions are used to display
detailed file information about open database files. 
This information is used to analyze and troubleshoot 
database files. 
*/
// ----------------------------------------------------------- // 
#include "gxdstats.h"
#include <iostream.h>
#include <iomanip.h>

void DatabaseStats(gxDatabase *f)
{
  cout << endl;
  const char *FName = f->DatabaseName();
  char rev_letter = f->GetRevLetter();
  char *signature = f->GetSignature();
  cout << "----- Database file statistics -----" << endl;
  cout << endl;
  cout << "----- Static information -----" << endl;
  cout << "File Name:         " << FName << endl;
  cout << "File Signature:    " << signature << endl; 
  if(rev_letter == ' ' || rev_letter == 0)
    cout << "Revision Letter:   " << "Zero" << endl;
  else
    cout << "Revision Letter:   " << rev_letter << endl;
  cout << "Library Version:   " << f->GetVersion() << endl;
  cout << "File Header Size:  " << f->FileHeaderSize() << endl;
  cout << "Block Header Size: " << f->BlockHeaderSize() << endl;
  cout << "Static area size:  " << f->StaticArea() << endl;
  cout << "Static file size:  " << f->FileSize(FName) << endl;
  cout << endl;
  cout << "----- Dynamic Information -----" << endl;
  cout << "File Status:     ";
  if(f->IsOpen()) cout << "Open "; else cout << "Closed ";
  if(f->ReadyForWriting()) cout << "Read/Write "; else cout << "Read/Only ";
  cout << endl;
  cout << "Free Space:      " << f->GetDatabaseFreeSpace() << endl;
  cout << "End of File:     " << f->GetEOF() << endl;
  cout << "Heap Start:      " << f->GetHeapStart() << endl;
  cout << "Highest Block:   " << f->GetHighestBlock() << endl;
  cout << "Total Blocks:    " << f->TotalBlocks() << endl;
  FAU tl, dl, rm;
  tl = f->DeleteBlocks(&dl, &rm);
  cout << "Deleted/Removed: " << dl << "/" << rm << " (" << tl << ")"
       << endl;

  gxFileLockHeader flh;
  switch(rev_letter) {
    case 'b': case 'B': case 'c': case 'C':
      cout << endl;
      cout << "----- Lock Header Information -----" << endl;
      f->ReadFileLockHdr(flh);
      cout << "File Lock Protect:     " << (int)flh.file_lock_protect << endl;
      cout << "File Read Lock Value:  " << (int)flh.file_read_lock << endl;
      cout << "File Write Lock Value: " << (int)flh.file_write_lock << endl;
      break;
    default:
      break;
  }

  delete signature;
  cout << endl;
}

void BlockStats(gxDatabase *f, FAU oa)
{
  gxBlockHeader blk_hdr;
  FAU blk_address = oa - f->BlockHeaderSize();
  f->Read(&blk_hdr, sizeof(gxBlockHeader), blk_address);
  char rev_letter = f->GetRevLetter();
  __ULWORD__ object_crc, calc_crc;
  
  cout << endl;
  cout << "----- Block Statistics -----" << endl;
  
  cout << "Check Word   = ";
  cout.setf(ios::uppercase);
  cout << "0x" << setfill('0') << setw(8) << hex << blk_hdr.block_check_word 
       << endl;
  cout.unsetf(ios::uppercase);
  cout << "Length       = " << dec << blk_hdr.block_length << endl;
  cout << "Status       = " << (__SBYTE__)(blk_hdr.block_status & 0xff) << endl;
  cout << "Next Deleted = " << blk_hdr.block_nd_fptr << endl;
  cout << endl;
  cout << "----- Object Statistics -----" << endl;
  cout << "Object Length  = " << f->ObjectLength(oa) << endl;

  if((rev_letter != '\0') || (rev_letter != ' ')) {
    if(f->ReadObjectChecksum(oa, &object_crc, &calc_crc)) {
      cout.setf(ios::uppercase);
      cout << "Stored CRC     = 0x" << setfill('0') << setw(8) << hex
	   << object_crc << endl;
      cout << "Calculated CRC = 0x" << setfill('0') << setw(8) << hex
	   << calc_crc << dec << endl;
    }
    else {
      CheckError(f);
    }
  }

  if((rev_letter == 'c') || (rev_letter == 'C')) {
  gxRecordLockHeader rlh;
  cout << endl;
  cout << "----- Record Lock Statistics -----" << endl;
  f->ReadRecordLockHdr(rlh, blk_address);
  cout << "Record Lock Protect:     " << (int)rlh.record_lock_protect 
       << endl;
  cout << "Record Read Lock Value:  " << (int)rlh.record_read_lock
       << endl;
  cout << "Record Write Lock Value: " << (int)rlh.record_write_lock
       << endl;

  }

  cout << endl;
}

int CheckError(gxDatabase *f)
// Check the last reported error. Prints the error
// and returns a non-zero value if an error condition
// was reached.
{
  if(f->GetDatabaseError() != gxDBASE_NO_ERROR) {
    cout << f->DatabaseExceptionMessage() << endl;
    return 1;
  }
  return 0;
}

int CheckError(gxDatabaseError err)
// Check the last reported error. Prints the error
// and returns a non-zero value if an error condition 
// was reached.
{
  if(err != gxDBASE_NO_ERROR) {
    cout << gxDatabaseExceptionMessage(err) << endl;
    return 1;
  }
  return 0;
}

void EchoDatabaseVersion()
// Echo the current library version and revision to the console.
{
  cout.setf(ios::showpoint | ios::fixed);
  cout.precision(3);
  cout << "Database Library Version:  " << gxDatabaseVersion << endl;
  cout << "Database Library Revision: " << gxDatabaseRevisionLetter << endl;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
