// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 07/31/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the gxINT64 class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxint64.h"

// Positive and Negitive limits Constants 
#if defined (__WIN32__)
const __LLWORD__   LLWORDPositiveLimit = 9223372036854775807;
const __LLWORD__   LLWORDNegitiveLimit = 9223372036854775808;
const __ULLWORD__  ULLWORDLimit        = 18446744073709551615;
#elif defined (__UNIX__)
const __LLWORD__   LLWORDPositiveLimit = 9223372036854775807LL;
const __LLWORD__   LLWORDNegitiveLimit = 9223372036854775808LL;
const __ULLWORD__  ULLWORDLimit        = 18446744073709551615LL;
#else
#error You must define a target platform: __WIN32__ or __UNIX__
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press enter to continue..." << endl;
  cin.get();
}

void SkipToEol(istream &s)
// Used to clear istream
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

template<class TYPEX, class TYPEY>
inline void OperatorTest(TYPEX x, TYPEY y)
{
  char *tf[2] = {"FALSE", "TRUE"};
  cout << endl;

  cout << "Value x = " << x << ", Value y = " << y << endl;
  TYPEX z;
  cout << x << " += " << y << " = "; z = x; z += y; cout << z << endl;
  cout << x << " -= " << y << " = "; z = x; z -= y; cout << z << endl;
  cout << x << " *= " << y << " = "; z = x; z *= y; cout << z << endl;
  cout << x << " /= " << y << " = "; z = x; z /= y; cout << z << endl;
  cout << x << " * " << y << " = " ; z = (x * y); cout << z << endl;
  cout << x << " / " << y << " = " ; z = (x / y); cout << z << endl;
  cout << x << " + " << y << " = " ; z = (x + y); cout << z << endl;
  cout << x << " - " << y << " = " ; z = (x - y); cout << z << endl;
  cout << x << " == " << y << " = " << tf[(x == y)] << endl;
  cout << x << " != " << y << " = " << tf[(x != y)] << endl;
  cout << x << " <= " << y << " = " << tf[(x <= y)] << endl;
  cout << x << " >= " << y << " = " << tf[(x >= y)] << endl;
  cout << x << " < " << y << " = " << tf[(x < y)] << endl;
  cout << x << " > " << y << " = " << tf[(x > y)] << endl;
  cout << x << "++ = "; z = x; z++; cout << z << endl;
  cout << x << "-- = "; z = x; z--; cout << z << endl; 
  cout << "++" << x << " = "; z = x; ++z; cout << z << endl;
  cout << "--" << x << " = "; z = x; --z; cout << z << endl;
}

int main()
{
  gxINT64 a = LLWORDPositiveLimit;
  cout << "gxINT64 positive limit = " << a << endl;

  gxINT64 b(LLWORDNegitiveLimit);
  cout << "gxINT64 negitive limit = " << b << endl;

  gxINT64 c;

  c = ULLWORDLimit;
  cout << "Assigning gxINT64 unsigned limit: " << c << endl;

  PausePrg();
  
  cout << "Testing gxINT64 copy consturctor..." << endl;
  gxINT64 d(a);
  cout << d << endl;

  cout << endl;
  cout << "Testing gxINT64 assignment operator..." << endl;
  gxINT64 e;
  e = a;
  cout << e << endl;

  PausePrg();

  cout << "Testing overloaded operators (gxINT64, gxINT64)..." << endl;
  gxINT64 buf1, buf2, al, bl;
  
  cout << "Enter first integer: ";
  cin >> buf1;
  if(cin) {
    a = buf1;
    al = buf1;
    cout << "Enter second integer: ";
    cin >> buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }
  if(cin) {
    b = buf2;
    bl = buf2;
  }
  else {
    cout << "Input stream broken. Exiting..." << endl;
    return 0;
  }

  SkipToEol(cin);
    
  cout << endl;
  
  OperatorTest(a, b);

  PausePrg();

  cout << "Testing overloaded operators (gxINT64, __LWORD__)..." << endl;
  OperatorTest(a, bl); 

  PausePrg();

  cout << "Testing overloaded operators (__LWORD__, gxINT64)..." << endl;
  OperatorTest(al, b);
  
  PausePrg();

  cout << "Testing overloaded operators (gxINT64, __WORD__)..." << endl;
  OperatorTest(a, (__WORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__WORD__, gxINT64)..." << endl;
  OperatorTest((__WORD__)al, b);

  PausePrg();

  cout << "Testing overloaded operators (gxINT64, __SWORD__)..." << endl;
  OperatorTest(a, (__SWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__SWORD__, gxINT64)..." << endl;
  OperatorTest((__SWORD__)al, b);

  PausePrg();
  
  cout << "Testing overloaded operators (gxINT64, __UWORD__)..." << endl;
  OperatorTest(a, (__UWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__UWORD__, gxINT64)..." << endl;
  OperatorTest((__UWORD__)al, b);

  PausePrg();

  cout << "Testing overloaded operators (gxINT64, __USWORD__)..." << endl;
  OperatorTest(a, (__USWORD__)bl);

  PausePrg();

  cout << "Testing overloaded operators (__USWORD__, gxINT64)..." << endl;
  OperatorTest((__USWORD__)al, b);

  PausePrg();
  
  cout << "Testing overloaded operators (gxINT64, __SBYTE__)..." << endl;
  OperatorTest(a, 'B');

  PausePrg();

  cout << "Testing overloaded operators (__SBYTE__, gxINT64)..." << endl;
  OperatorTest('A', b);

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


