// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: systime.cpp 
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 12/11/1996
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the SysTime class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "systime.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PausePrg()
{
  cout << endl;
  cout << "Press <Enter> to continue..." << endl;
  cin.get();
}

void ClearInputStream(istream &s)
{
  char c;
  s.clear();
  while(s.get(c) && c != '\n') { ; }
}

main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  SysTime *Time = new SysTime;

  cout << endl;
  cout << "The current system time is: " << Time->GetSystemDateTime() << endl;
  cout << "The current GMT time is: " << Time->GetGMTDateTime() << endl; 
  cout << endl;
  int days_old = Time->DaysOld(1, 1970);
  cout << days_old << " days have passed since January 1, 1970" << endl;
  
  PausePrg();
  cout << "Testing the date span function..." << endl;
  cout << endl;
  cout << "Enter the number of days to look ahead: ";
  int days; char datespanBuf[255];
  cin >> days;
  if(Time->DateSpan(datespanBuf, days)) 
    cout << "Date span = " << datespanBuf << endl;
  else
    cout << "DateSpan() error" << endl;

  ClearInputStream(cin); // Go to end of line
  PausePrg();

  cout << "Testing the leap year function..." << endl;
  cout << endl;
  cout << "Enter a year: ";
  int year; 
  cin >> year;
  if(Time->IsLeapYear(year)) 
    cout << year << " is a leap year" << endl;
  else
    cout << year << " is not a leap year" << endl;

  cout << endl;
  cout << "Displaying all the String time formats" << endl;

  ClearInputStream(cin); // Go to end of line
  PausePrg();

  cout << "AM or PM: " << Time->GetStrTime(SysTime::AMPM) << endl; 
  cout << "System date: " << Time->GetStrTime(SysTime::Date) << endl; 

  cout << "Day of the month (01..31): " 
       << Time->GetStrTime(SysTime::DayOfTheMonth) << endl; 

  cout << "Day of the week (0..6, Sunday=0): " 
       << Time->GetStrTime(SysTime::DayOfTheWeek) << endl; 

  cout << "Hour (24 hour clock - 00..23): " 
       << Time->GetStrTime(SysTime::Hour) << endl;
  
  cout << "Julian day: " << Time->GetStrTime(SysTime::JDay) << endl; 
  cout << "Minutes (00..59): " << Time->GetStrTime(SysTime::Minutes) << endl; 
  cout << "Month (01..12): " << Time->GetStrTime(SysTime::Month) << endl; 
  cout << "Full month name: " << Time->GetStrTime(SysTime::FullMonthName)
       << endl; 

  cout << "Abbreviated month name: " 
       << Time->GetStrTime(SysTime::MonthName) << endl; 

  cout << "Seconds (00..59): " << Time->GetStrTime(SysTime::Seconds) << endl; 
  cout << "System time: " << Time->GetStrTime(SysTime::SystemTime) << endl; 
       
  cout << "Timezone name: "
       << Time->GetStrTime(SysTime::TimeZoneName) << endl;
  
  cout << "Abbreviated weekday name: " 
       << Time->GetStrTime(SysTime::WeekDayName) << endl;
  
  cout << "Full weekday name: "
       << Time->GetStrTime(SysTime::FullWeekDayName) << endl;
  
  cout << "Week of the year (00..52, Sunday first): "
       << Time->GetStrTime(SysTime::WeekOfYearSF) << endl;
  
  cout << "Week of the year (00..52, Monday first): "
       << Time->GetStrTime(SysTime::WeekOfYearMF) << endl;
  
  cout << "Year (0000..9999): " << Time->GetStrTime(SysTime::Year) << endl; 
  cout << "Year (00..99): " << Time->GetStrTime(SysTime::YearXX) << endl; 
  
  cout << endl;
  cout << "Press enter to display all the Integer time formats" << endl;
  cin.get();

  cout << "Day of the month (01..31): " 
       << Time->GetIntTime(SysTime::DayOfTheMonth) << endl; 

  cout << "Display the day of the week (0..6, Sunday=0): " 
       << Time->GetIntTime(SysTime::DayOfTheWeek) << endl; 

  cout << "Hour (24 hour clock - 00..23): " 
       << Time->GetIntTime(SysTime::Hour) << endl;
  
  cout << "Julian day: " << Time->GetIntTime(SysTime::JDay) << endl; 
  cout << "Minutes (00..59): " << Time->GetIntTime(SysTime::Minutes) << endl; 
  cout << "Month (01..12): " << Time->GetIntTime(SysTime::Month) << endl; 
  cout << "Seconds (00..59): " << Time->GetIntTime(SysTime::Seconds) << endl; 

  cout << "Week of the year (00..52, Sunday first): "
       << Time->GetIntTime(SysTime::WeekOfYearSF) << endl;
  
  cout << "Week of the year (00..52, Monday first): "
       << Time->GetIntTime(SysTime::WeekOfYearMF) << endl;
  
  cout << "Year (0000..9999): " << Time->GetIntTime(SysTime::Year) << endl; 
  cout << "Year (00..99): " << Time->GetIntTime(SysTime::YearXX) << endl; 

  PausePrg();
  
  cout << "Testing invalid format codes. Press enter to continue..." << endl;
  cin.get();

  cout << Time->GetStrTime(9999) << endl;
  cout << hex << Time->GetIntTime(9999) << endl;

  cout << "Testing Date/Time formating functios. Press enter to continue..." << endl;
  cin.get();

  cout << "System time: " << Time->GetSystemTime() << endl;
  cout << "System date: " << Time->GetSystemDate() << endl;
  cout << "System time and date: " << Time->GetSystemDateTime() << endl;

  delete Time;
  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //

