// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 03/25/2000
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or 
modify it under the terms of the GNU Lesser General Public 
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version. 
  
This library is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
USA

Test program demonstrating the basic operation of the gxThread
pool class.
*/
// ----------------------------------------------------------- //   
#include <iostream.h>
#include "gxthread.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

void PausePrg()
// Pause the program until enter is pressed
{
  cout << endl;
  cout << "Press Enter to continue...\n";
  cin.get();
}

class SimpleThread : public gxThread
{
private: // Base class interface
  void *ThreadEntryRoutine(gxThread_t *thread);
};

void *SimpleThread::ThreadEntryRoutine(gxThread_t *thread)
// Thread's entry function
{
  cout << "Executing worker thread: " << (int)thread->GetThreadParm() << '\n'
       << flush;

  return 0;
}

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  const unsigned NUM_WORKERS = 10;

  SimpleThread *t = new SimpleThread;
  thrPool *pool = new thrPool;

  unsigned i;
  for(i = 0; i < NUM_WORKERS; i++) {
    t->CreateThread(pool, (void *)i);
    t->sSleep(1);
  }

  t->JoinThread(pool);

  cout << endl;
  cout << "Destroying the thread pool..." << endl;
  t->DestoryThreadPool(pool);

  cout << "Creating anther pool of " << NUM_WORKERS << " threads" << endl;
  PausePrg();
  pool = t->CreateThreadPool(NUM_WORKERS);

  t->sSleep(5);
  cout << endl;
  cout << "Rebuilding the pool" << endl;
  t->RebuildThreadPool(pool);

  // Wait for the treads to finish before destroying the pool
  t->JoinThread(pool);

  cout << endl;
  cout << "Destroying the thread pool..." << endl;
  if(!pool->IsEmpty()) {
    t->DestoryThreadPool(pool);
  }
  else {
    cout << "The pool is empty" << endl;
    // If DestoryThreadPool() is not called the pool will not be deleted
    delete pool; 
  }
  
  cout << "Exiting..." << endl;
  delete t;

  return 0; // Exit the process, terminating all threads
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //


  

