# Include file used for all project makefiles

# Pre-defined include and source code paths for this project
INCLUDE_PATH = $(PROJECT_INCLUDE_PATH)$(PATHSEP)
SRC_PATH = $(PROJECT_SRC_PATH)$(PATHSEP)

# Build dependency rules
# ===============================================================
GXSOCKET_DEP = $(INCLUDE_PATH)gxsocket.h $(INCLUDE_PATH)gxstypes.h

DEVCACHE_DEP =  $(INCLUDE_PATH)devcache.h $(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h $(INCLUDE_PATH)memblock.h

MEMBUF_DEP = $(INCLUDE_PATH)membuf.h

MEMBLOCK_DEP = $(INCLUDE_PATH)memblock.h

USTRING_DEP = $(INCLUDE_PATH)ustring.h

GXLISTB_DEP = $(INCLUDE_PATH)gxlistb.h

GXSHTTP_DEP = $(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)gxlist.h \
	$(INCLUDE_PATH)gxstring.h $(INCLUDE_PATH)gxshttp.h

GXSHTTPC_DEP =  $(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)gxlist.h \
	$(INCLUDE_PATH)gxstring.h  $(INCLUDE_PATH)gxsocket.h \
	$(INCLUDE_PATH)gxstypes.h $(INCLUDE_PATH)devcache.h \
	$(INCLUDE_PATH)memblock.h $(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h $(INCLUDE_PATH)gxs_b64.h \
	$(INCLUDE_PATH)gxshttp.h $(INCLUDE_PATH)gxshttpc.h \
	$(INCLUDE_PATH)gxsurl.h

HTTPGRAB_DEP =  $(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)gxlist.h \
	$(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)gxsocket.h \
	$(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)devcache.h \
	$(INCLUDE_PATH)memblock.h \
	$(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)gxs_b64.h \
	$(INCLUDE_PATH)gxshttp.h \
	$(INCLUDE_PATH)gxshttpc.h \
	$(INCLUDE_PATH)gxsurl.h\
	$(INCLUDE_PATH)gxshtml.h

GXSHTML_DEP = $(INCLUDE_PATH)gxshtml.h \
	$(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)gxlist.h \
	$(INCLUDE_PATH)gxlistb.h \
	$(INCLUDE_PATH)dfileb.h

GXSURL_DEP = $(INCLUDE_PATH)gxsurl.h $(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)gxstring.h

GXS_B64_DEP = $(INCLUDE_PATH)ustring.h $(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)gxs_b64.h

DFILEB_DEP = $(INCLUDE_PATH)dfileb.h

PROJECT_DEP =  $(INCLUDE_PATH)ustring.h \
	$(INCLUDE_PATH)gxlist.h \
	$(INCLUDE_PATH)gxstring.h \
	$(INCLUDE_PATH)gxsocket.h \
	$(INCLUDE_PATH)gxstypes.h \
	$(INCLUDE_PATH)devcache.h \
	$(INCLUDE_PATH)memblock.h \
	$(INCLUDE_PATH)devtypes.h \
	$(INCLUDE_PATH)membuf.h \
	$(INCLUDE_PATH)gxs_b64.h \
	$(INCLUDE_PATH)gxshttp.h \
	$(INCLUDE_PATH)gxshttpc.h \
	$(INCLUDE_PATH)gxsurl.h\
	$(INCLUDE_PATH)gxshtml.h
# ===============================================================

# Compile the files and build the executable
# ===============================================================
all:	$(PROJECT)$(EXE_EXT)

gxsocket$(OBJ_EXT):	$(SRC_PATH)gxsocket.cpp $(GXSOCKET_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsocket.cpp

devcache$(OBJ_EXT):	$(SRC_PATH)devcache.cpp $(DEVCACHE_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)devcache.cpp

membuf$(OBJ_EXT):	$(SRC_PATH)membuf.cpp $(MEMBUF_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)membuf.cpp

memblock$(OBJ_EXT):	$(SRC_PATH)memblock.cpp $(MEMBLOCK_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)memblock.cpp

ustring$(OBJ_EXT):	$(SRC_PATH)ustring.cpp $(USTRING_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)ustring.cpp

gxs_b64$(OBJ_EXT):	$(SRC_PATH)gxs_b64.cpp $(GXS_B64_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxs_b64.cpp

gxsurl$(OBJ_EXT):	$(SRC_PATH)gxsurl.cpp $(GXSURL_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxsurl.cpp

dfileb$(OBJ_EXT):	$(SRC_PATH)dfileb.cpp $(DFILEB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)dfileb.cpp

gxlistb$(OBJ_EXT):	$(SRC_PATH)gxlistb.cpp $(GXLISTB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxlistb.cpp

gxshttp$(OBJ_EXT):	$(SRC_PATH)gxshttp.cpp $(GXSHTTP_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxshttp.cpp

gxshttpc$(OBJ_EXT):	$(SRC_PATH)gxshttpc.cpp $(GXSHTTPC_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxshttpc.cpp

httpgrab$(OBJ_EXT):	$(SRC_PATH)httpgrab.cpp $(HTTPGRAB_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)httpgrab.cpp

gxshtml$(OBJ_EXT):	$(SRC_PATH)gxshtml.cpp $(GXSHTML_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(SRC_PATH)gxshtml.cpp

$(PROJECT)$(OBJ_EXT):	$(PROJECT).cpp $(PROJECT_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) $(PROJECT).cpp

leaktest$(OBJ_EXT):    $(SRC_PATH)leaktest.cpp $(LEAKTEST_DEP)
	$(CPP) $(COMPILE_ONLY) $(COMPILE_FLAGS) \
	$(SRC_PATH)leaktest.cpp

# Make the executable
OBJECTS = $(PROJECT)$(OBJ_EXT) leaktest$(OBJ_EXT) \
	gxsocket$(OBJ_EXT)  devcache$(OBJ_EXT) membuf$(OBJ_EXT) \
	memblock$(OBJ_EXT) ustring$(OBJ_EXT) gxlistb$(OBJ_EXT) \
	gxshttp$(OBJ_EXT) gxshttpc$(OBJ_EXT) gxs_b64$(OBJ_EXT) \
	gxsurl$(OBJ_EXT) dfileb$(OBJ_EXT) httpgrab$(OBJ_EXT) \
	gxshtml$(OBJ_EXT)
# ===============================================================
