// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: client.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Demo of the gxSocket WinSock functions. This test program is used
to initialize and release various winsock versions and display the
contents of the WSAData structure:

struct WSAData {  
    WORD            wVersion; 
    WORD            wHighVersion; 
    char            szDescription[WSADESCRIPTION_LEN+1]; 
    char            szSystemStatus[WSASYSSTATUS_LEN+1]; 
    unsigned short  iMaxSockets; 
    unsigned short  iMaxUdpDg; 
    char FAR *      lpVendorInfo; // Vendor-specific data structure
}; 

The gxSocket class can be use to automatically or manually
initialize the winsock DLL prior to the use of the Windows 
networking subsystem. Automatic winsock initialization will 
default to winsock version set in the gxSocket constructor.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "gxsocket.h"
#include "wserror.h"

void PausePrg()
{
  cout << endl;
  cout << "Press Enter to continue..." << endl;
  cin.get();
}

void PrintWSAInfo(gxSocket *socket)
{
  cout << "WinSock Version Requested: " 
       << (int)LOBYTE(socket->socket_data.wVersion) 
       << "." << (int)HIBYTE(socket->socket_data.wVersion) << endl;
  cout << "Current WinSock Version: " 
       << (int)LOBYTE(socket->socket_data.wHighVersion)
       << "." << (int)HIBYTE(socket->socket_data.wHighVersion) << endl;
  cout << "Description: " << socket->socket_data.szDescription << endl;
  cout << "System Status: " << socket->socket_data.szSystemStatus << endl;
  cout << "Max number of sockets: " << socket->socket_data.iMaxSockets 
       << endl;
  cout << "MAX UDP datagram size: " << socket->socket_data.iMaxUdpDg
       << endl;
}

void TestWSAVersion(gxSocket *socket, gxsSocketLibraryVersion ver)
{
  socket->socket_version = ver;
  if(socket->InitSocketLibrary() == 0) {
    PrintWSAInfo(socket);
    cout << endl;
    cout << "Simulating a WinSock error and printing the extended error info"
	 << endl;
    WinSockSetException(WSAEINTR);
    cout << WinSockExceptionMessage() << endl;
    if(socket->ReleaseSocketLibrary() != 0) {
      cout << socket->SocketExceptionMessage() << endl; 
    }   
  }
  else {
    cout << socket->SocketExceptionMessage() << endl; 
  } 
}

int main()
{
  gxsSocketLibraryVersion wsa_ver10 = gxSOCKET_WSAVER_ONEZERO;
  gxsSocketLibraryVersion wsa_ver11 = gxSOCKET_WSAVER_ONEONE;
  gxsSocketLibraryVersion wsa_ver20 = gxSOCKET_WSAVER_TWOZERO;
  gxsSocketLibraryVersion wsa_ver22 = gxSOCKET_WSAVER_TWOTWO;

  gxSocket socket;

  cout << "Testing winsock version 1.0" << endl;
  TestWSAVersion(&socket, wsa_ver10);
  PausePrg();

  cout << "Testing winsock version 1.1" << endl;
  TestWSAVersion(&socket, wsa_ver11);
  PausePrg();

  cout << "Testing winsock version 2.0" << endl;
  TestWSAVersion(&socket, wsa_ver20);
  PausePrg();

  cout << "Testing winsock version 2.2" << endl;
  TestWSAVersion(&socket, wsa_ver22);

  cout << endl;
  cout << "Exiting..." << endl;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
