// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: eds101.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 10/15/1999 
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Code used to generate platform dependent randomly encrypted 
data sets.
*/
// ----------------------------------------------------------- // 
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include "eds101.h"
#include "edst101.h"

edsString::edsString()
{
  LoadStaticTable(); // Load the static table values by default
}

edsString::~edsString()
{

}

edsString::edsString(const edsString &ob)
{
  edsCopy(ob);
}

edsString edsString::operator=(const edsString &ob)
{
  edsCopy(ob);
  return *this;
}

void edsString::edsCopy(const edsString &ob)
{
  for(unsigned i = 0; i < edsTableSize; i++) 
    eds_table[i] = ob.eds_table[i];
}

edsWORD edsString::EncryptString(unsigned char c)
// Return a encrypted value for the specified character.
{
  return eds_table[(unsigned)c];
}

int edsString::DecryptString(edsWORD val, unsigned char &c)
// Decrypt the specified value and pass back the character in "c."
// Returns false if the encrypted value is not found in the
// encryption table.
{
  for(unsigned i = 0; i < edsTableSize; i++) {
    if(eds_table[i] == val) { // Found a match
      c = (unsigned char)i;
      return 1;
    }
  }
  return 0; // No match was found
}

void edsString::LoadStaticTable()
{
  for(unsigned i = 0; i < edsTableSize; i++) 
    eds_table[i] = (edsWORD)edsStaticTable[i]; // Load the table values
}

edsWORD edsString::GenRandomNumber()
// Generate a random pad value. 
{
  // Seed the random number generator with the current time
  // so that the numbers will be different each time this
  // function is called.
  srand((unsigned)time(0));
  return (edsWORD)rand();
}

void edsString::InitDynamicTable(unsigned long r_seed)
// Initialize the dynamic table. The dynamic table allows the application
// to change the encryption codes as the program is running.
{
  srand(r_seed); // Seed the random number generator
  for(unsigned i = 0; i < edsTableSize; i++) {
    eds_table[i] = (edsWORD)(rand() + i);
  }
  TestDynamicTable();
}

void edsString::TestDynamicTable()
// Test the table for duplicate matches and automatically correct.
{
  edsWORD table[edsTableSize];
  unsigned i, j, matches, total_matches;

  while(1) {
    for(i = 0; i < edsTableSize; i++) 
      table[i] = eds_table[i]; // Load the table values
    total_matches = 0;
    for(i = 0; i < edsTableSize; i++) {
      matches = 0;
      for(j = 0; j < edsTableSize; j++) {
	// Looking for duplicate entries
	if(eds_table[i] == table[j]) matches++;
	if(matches > 1) { // Found duplicate entry
	  eds_table[i] = GenRandomNumber();
	  total_matches++;
	}
      }
    }
    if(total_matches == 0) break;
  }
}

#ifdef __USE_EDS_TEST_FUNCTIONS__
#include <iomanip.h>
int edsTestStaticEncryptionTable(ostream &stream)
// Test the static encryption table for duplicate entries.
{
  edsWORD table[edsTableSize];
  unsigned i, j, matches;

  for(i = 0; i < edsTableSize; i++) 
    table[i] = edsStaticTable[i]; // Load the table values

  for(i = 0; i < edsTableSize; i++) {
    matches = 0;
    for(j = 0; j < edsTableSize; j++) {
      // Looking for duplicate entries
      if(edsStaticTable[i] == table[j]) matches++;
      if(matches > 1) {
	stream << endl;
	stream << "Duplicate table entry:" << "  0x" << setfill('0')
	     << setw(4) << hex << edsStaticTable[i];
	stream << endl;
	return 0;
      }
    }
    if(i % 5)
      stream << ", 0x" << setfill('0') << setw(4) << hex << edsStaticTable[i];
    else
      stream << "," << endl << "  0x" << setfill('0') << setw(4) << hex
	   << edsStaticTable[i];
  }
  return 1;
}

int edsPrintStaticEncryptionTable(ostream &stream)
// Prints the static encryption table to the specified stream.
// Returns false if a duplicate table entry exists. NOTE: This
// function is used for test purposes only. 
{
  edsString eds1, eds2;
  eds1.InitDynamicTable();
  eds2.InitDynamicTable();

  unsigned matches, i, j;  
  for(i = 0; i < edsTableSize; i++) {
    matches = 0;
    for(j = 0; j < edsTableSize; j++) {
      // Looking for duplicate entries
      if(eds1.eds_table[i] == eds2.eds_table[j]) matches++;
      if(matches > 1) {
	stream << endl;
	stream << "Duplicate table entry:" << "  0x" << setfill('0')
	     << setw(4) << hex << eds1.eds_table[i];
	stream << endl;
	return 0;
      }
    }
    if(i % 5)
      stream << ", 0x" << setfill('0') << setw(4) << hex << eds1.eds_table[i];
    else
      stream << "," << endl << "  0x" << setfill('0') << setw(4) << hex
	   << eds1.eds_table[i];
  }
  return 1;
}
#endif // __USE_EDS_TEST_FUNCTIONS__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
