// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: as2htm.cpp 
// Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 03/09/1999 
// Date Last Modified: 06/12/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program description and details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA
  
This program is used to convert text file to HTML files.
*/
// ----------------------------------------------------------- // 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fstream.h>
#include <iostream.h>
#include "htmldrv.h"
#include "futils.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

// Version number and program name
const double AS2HTMVersionNumber = 4000.101;
const char *ProgramName = "as2htm";

// Program globals
const int MAX_LEN = 1024; // Maximum length of fixed strings
char out_file[MAX_LEN];   // HTML file created from text file
int write_to_file = 0;    // Write the output to a file instead of stdout
char *open_file = 0;      // Name of text file currently opened
unsigned num_files = 0;   // Total number of files processed
int use_html_ext = 0;     // Use HTML file extension instead of .htm
int use_header = 0;       // Write document header and trailer
int use_comments = 0;     // Write comments to the HTML file

void HelpMessage(const char *program_name, const double version_number)
{
  char gxuffer[255];
  sprintf(gxuffer, "%.3f", version_number);
  cout << endl;
  cout << program_name << " program version "
       << gxuffer  << endl;
  cout << "Usage: " << program_name << " [switches] infile.txt " << endl; 
  cout << "Switches: " << endl;
  cout << "          -c = Write comments in html file." << endl;
  cout << "          -f = Write output to file: infile.txt = infile.htm"
       << endl;
  cout << "          -h = Write a document header and trailer." << endl;
  cout << "          -l = Use .html file extension, defaults to .htm" << endl;
  cout << endl;
  exit(0);
}

int ProcessArgs(char *arg)
{
  switch(arg[1]) {
    case 'c':
      use_comments = 1;
      break;
      
    case 'f':
      write_to_file = 1;
      break;

    case 'h':
      use_header = 1;
      break;
      
    case 'l':
      use_html_ext = 1;
      break;


    default:
      cerr << endl;
      cerr << "Unknown switch " << arg << endl;
      cerr << "Exiting..." << endl;
      cerr << endl;
      return 0;
  }
  arg[0] = '\0';
  return 1; // All command line arguments were valid
}

void ProcessTextFile(fstream &infile, ostream &stream)
{
  unsigned char c;
  HyperText htm(stream);

  
  if(use_comments) {
    char date[255]; htm.GetSystemTime(date);
    htm << comment << "HTML file generated by: " << ProgramName << " version ";
    htm.precision(3);
    htm << AS2HTMVersionNumber << ecomment << endl;
    htm << comment << "File Creation date: " << date << ecomment << endl;
  }
  
  htm.Prologue(open_file);
  htm.StartBody("BGCOLOR=\"#FFFFFF\"");

  if(use_header) htm.DocHeader(open_file);
  
  htm.FONT("FACE=\"Courier New\" SIZE=3");
  htm << pre << endl;

  while(!infile.eof()) { // Read in the file line by line
    infile.get(c);
    if(!infile.eof()) // Get rid of EOF marker
      htm << c;
  }

  htm << endl << epre << efont << endl;

  if(use_header) htm.DocTrailer();
  
  htm.Epilogue();
}

int GenOutputFileName(char *extension)
// Generate a name for the output file using the open_file
// name with the specified dot extension.
{
  unsigned i = 0;
  for(i = 0; i < MAX_LEN; i++) out_file[i] = '\0';
  char *p = open_file;
  unsigned len = strlen(p);
  for(i = 0; i < len && i != MAX_LEN; i++, p++) {
    if(*p == '.') break;
    out_file[i] = *p;
  }
  if((strlen(out_file) + strlen(extension)) > (MAX_LEN - 1)) return 0;
  strcat(out_file, extension); // Add the file extension (.xxx)
  return 1;
}

// Program's main thread of execution.
// ----------------------------------------------------------- 
int main(int argc,     // Number of strings in array argv.
	 char *argv[]) // Array of command-line argument 
// NOTE: None of the MSVC compilers will expand wildcard characters
// used in command-line arguments unless linked with the setargv.obj
// library. All the UNIX compliers will expand wildcard characters
// by default.
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  // If no arguments are given print usage message to the screen 
  if(argc < 2) {
    HelpMessage(ProgramName, AS2HTMVersionNumber);
    return 0;
  }

  // Process command ling arguments and files 
  int narg;
  char *arg = argv[narg = 1];
  while (narg < argc) {
    if (arg[0] != '\0') {
      if (arg[0] == '-') { // Look for command line arguments
	if(!ProcessArgs(arg)) return 0; // Exit if argument is not valid
      }
      else { 
	if(futils_isdirectory((const char *)arg)) {
	  // Do not process directories
	  arg = argv[++narg];
	  continue;
	}
	open_file = arg; // Update the open file name pointer
#ifdef __BCC32__
	// The BCC 32 ios class does not have an enumeration for "nocreate"
	fstream infile(open_file, ios::in);
#else
	fstream infile(open_file, ios::in|ios::nocreate);
#endif
	if(!infile) {
	  cerr << endl;
	  cerr << "Cannot open file: " << open_file << endl;
	  cerr << "Exiting..." << endl;
	  cerr << endl;
	  return 0;
	}
	num_files++;

	// Process the test file
	if(write_to_file) {
	  if(use_html_ext)
	    GenOutputFileName(".html");
	  else
	    GenOutputFileName(".htm");
	  fstream outfile(out_file, ios::out|ios::trunc);
	  if(!outfile) {
	    cerr << endl;
	    cerr << "Cannot write to: " << out_file << endl;
	    cerr << "Exiting..." << endl;
	    cerr << endl;
	    return 0;
	  }
	  ProcessTextFile(infile, outfile); // Write to file
	}
	else 
	  ProcessTextFile(infile, cout); // Write to stdout
      }
      arg = argv[++narg];
    }
  }
  
  if(num_files == 0) {
    cerr << endl;
    cerr << "You must enter a file name." << endl;
    cerr << "Exiting..." << endl;
    cerr << endl;
    return 0;
  }
  
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
