#!/usr/bin/perl
# AccessViewer 1.0
# -requires Win32-ODBC & Tk
# -written for Perl 5.005_02 (ActiveState build 509) & higher
# Author: Albert C. Pang  -  Artistic Licence July 2000
# (place Revisions/updates/credits here)

use Win32::ODBC;
use Tk;



$db = new Win32::ODBC("AccessViewerDSN");
die "cannot create a new ODBC object\n" if ! $db;

### retrieve list of tables from the database defined by AccessViewerDSN
@tables = $db->TableList;
$db -> Close();


### create GUI
$mw = MainWindow->new;


$listbox = $mw->Scrolled("Listbox", -scrollbars => "e", 
         -selectmode => "single") -> pack();
$listbox->insert(0, @tables);

$mw->Button(-text => "select a database table\n & then click here",
         -command => \&main) -> pack(-side => "right");
$mw->Button(-text => "E X I T\n", -command => sub{exit}) 
         -> pack(-side => "bottom");

MainLoop;




sub main {

   $db = new Win32::ODBC("AccessViewerDSN");
   die "cannot create a new ODBC object\n" if ! $db;

   ### create filehandle for temporary output file
   open(FILE, ">odbc.out") ||
   die "cannot create filehandle OR filehandle is already in use\n";
   
   
   ### retrieve selected table name from GUI
   $selected_table = $listbox->get($listbox->index("active"));


   ### retrieve fieldnames
   $SQLquery = "SELECT * FROM [$selected_table] WHERE 1=0";
   $db->Sql($SQLquery);

   @row = $db->FieldNames();
   ### linefeed on row 1 to avoid SYLK file error in Excel, see [Q29739]
   print FILE "\n";
   print STDOUT "\nWorking";
   foreach (@row)  {
      print FILE $_, "\t";
   }
   print FILE "\n\n";


   ### retrieve the data, row by row
   $SQLquery = "SELECT * FROM [$selected_table]";
   $db->Sql($SQLquery);

   while ($db->FetchRow())  {
      @row = $db->Data;
      foreach (@row)  {
         print FILE $_, "\t";
      }
      print FILE "\n";
      print STDOUT ".";
   }

   print STDOUT "Done\n";
   
   
   $db -> Close();
   close(FILE);


   ### open temporary output file using Excel
   system("runexcel.bat");
   
}
