{$INCLUDE ..\cDefines.inc}
unit cLinkedLists;

{                                                                              }
{                     Data structures: Linked lists v3.02                      }
{                                                                              }
{      This unit is copyright  2000-2002 by David Butler (david@e.co.za)      }
{                                                                              }
{                  This unit is part of Delphi Fundamentals.                   }
{                  Its original file name is cLinkedLists.pas                  }
{                     It was generated 29 Oct 2002 02:22.                      }
{       The latest version is available from the Fundamentals home page        }
{                     http://fundementals.sourceforge.net/                     }
{                                                                              }
{                I invite you to use this unit, free of charge.                }
{        I invite you to distibute this unit, but it must be for free.         }
{             I also invite you to contribute to its development,              }
{             but do not distribute a modified copy of this file.              }
{                                                                              }
{          A forum is available on SourceForge for general discussion          }
{             http://sourceforge.net/forum/forum.php?forum_id=2117             }
{                                                                              }
{                                                                              }
{ Revision history:                                                            }
{   [ cUtils ]                                                                 }
{   2000/06/10  1.01  Added linked lists.                                      }
{   [ cLinkedLists ]                                                           }
{   2002/05/31  3.02  Created cLinkedLists from cUtils.                        }
{                                                                              }
interface

const
  UnitName      = 'cLinkedLists';
  UnitVersion   = '3.02';
  UnitDesc      = 'Miscelleanous utility functions';
  UnitCopyright = '(c) 2000-2002 David J Butler';



{                                                                              }
{ Linked lists                                                                 }
{                                                                              }
type
  TLinkedItem = class
    Next : TLinkedItem;

    Function  HasNext : Boolean;
    Function  Last : TLinkedItem;
    Function  Count : Integer;
    Function  RemoveNext : TLinkedItem;
    Procedure DeleteNext;
    Procedure InsertAfter (const Item : TLinkedItem);

    Destructor DestroyList;
  end;

  TDoublyLinkedItem = class
    Next : TDoublyLinkedItem;
    Prev : TDoublyLinkedItem;

    Function  HasNext : Boolean;
    Function  HasPrev : Boolean;
    Function  Last : TDoublyLinkedItem;
    Function  First : TDoublyLinkedItem;
    Function  Count : Integer;
    Procedure Remove;
    Function  RemoveNext : TDoublyLinkedItem;
    Procedure DeleteNext;
    Function  RemovePrev : TDoublyLinkedItem;
    Procedure DeletePrev;
    Procedure InsertAfter (const Item : TDoublyLinkedItem);
    Procedure InsertBefore (const Item : TDoublyLinkedItem);
    Procedure Delete;

    Destructor DestroyList;
  end;

  TLinkedInteger = class (TLinkedItem)
    Value : Integer;

    Constructor Create (const V : Integer);

    Procedure InsertAfter (const V : Integer); reintroduce; overload;
    Procedure Append (const V : Integer);
    Function  FindNext (const Find : Integer) : TLinkedInteger;
  end;
  TDoublyLinkedInteger = class (TDoublyLinkedItem)
    Value : Integer;

    Constructor Create (const V : Integer);

    Procedure InsertAfter (const V : Integer); reintroduce; overload;
    Procedure InsertBefore (const V : Integer); reintroduce; overload;
    Procedure InsertFirst (const V : Integer);
    Procedure Append (const V : Integer);
    Function  FindNext (const Find : Integer) : TDoublyLinkedInteger;
    Function  FindPrev (const Find : Integer) : TDoublyLinkedInteger;
  end;

  TLinkedInt64 = class (TLinkedItem)
    Value : Int64;

    Constructor Create (const V : Int64);

    Procedure InsertAfter (const V : Int64); reintroduce; overload;
    Procedure Append (const V : Int64);
    Function  FindNext (const Find : Int64) : TLinkedInt64;
  end;
  TDoublyLinkedInt64 = class (TDoublyLinkedItem)
    Value : Int64;

    Constructor Create (const V : Int64);

    Procedure InsertAfter (const V : Int64); reintroduce; overload;
    Procedure InsertBefore (const V : Int64); reintroduce; overload;
    Procedure InsertFirst (const V : Int64);
    Procedure Append (const V : Int64);
    Function  FindNext (const Find : Int64) : TDoublyLinkedInt64;
    Function  FindPrev (const Find : Int64) : TDoublyLinkedInt64;
  end;

  TLinkedSingle = class (TLinkedItem)
    Value : Single;

    Constructor Create (const V : Single);

    Procedure InsertAfter (const V : Single); reintroduce; overload;
    Procedure Append (const V : Single);
    Function  FindNext (const Find : Single) : TLinkedSingle;
  end;
  TDoublyLinkedSingle = class (TDoublyLinkedItem)
    Value : Single;

    Constructor Create (const V : Single);

    Procedure InsertAfter (const V : Single); reintroduce; overload;
    Procedure InsertBefore (const V : Single); reintroduce; overload;
    Procedure InsertFirst (const V : Single);
    Procedure Append (const V : Single);
    Function  FindNext (const Find : Single) : TDoublyLinkedSingle;
    Function  FindPrev (const Find : Single) : TDoublyLinkedSingle;
  end;

  TLinkedDouble = class (TLinkedItem)
    Value : Double;

    Constructor Create (const V : Double);

    Procedure InsertAfter (const V : Double); reintroduce; overload;
    Procedure Append (const V : Double);
    Function  FindNext (const Find : Double) : TLinkedDouble;
  end;
  TDoublyLinkedDouble = class (TDoublyLinkedItem)
    Value : Double;

    Constructor Create (const V : Double);

    Procedure InsertAfter (const V : Double); reintroduce; overload;
    Procedure InsertBefore (const V : Double); reintroduce; overload;
    Procedure InsertFirst (const V : Double);
    Procedure Append (const V : Double);
    Function  FindNext (const Find : Double) : TDoublyLinkedDouble;
    Function  FindPrev (const Find : Double) : TDoublyLinkedDouble;
  end;

  TLinkedExtended = class (TLinkedItem)
    Value : Extended;

    Constructor Create (const V : Extended);

    Procedure InsertAfter (const V : Extended); reintroduce; overload;
    Procedure Append (const V : Extended);
    Function  FindNext (const Find : Extended) : TLinkedExtended;
  end;
  TDoublyLinkedExtended = class (TDoublyLinkedItem)
    Value : Extended;

    Constructor Create (const V : Extended);

    Procedure InsertAfter (const V : Extended); reintroduce; overload;
    Procedure InsertBefore (const V : Extended); reintroduce; overload;
    Procedure InsertFirst (const V : Extended);
    Procedure Append (const V : Extended);
    Function  FindNext (const Find : Extended) : TDoublyLinkedExtended;
    Function  FindPrev (const Find : Extended) : TDoublyLinkedExtended;
  end;

  TLinkedString = class (TLinkedItem)
    Value : String;

    Constructor Create (const V : String);

    Procedure InsertAfter (const V : String); reintroduce; overload;
    Procedure Append (const V : String);
    Function  FindNext (const Find : String) : TLinkedString;
  end;
  TDoublyLinkedString = class (TDoublyLinkedItem)
    Value : String;

    Constructor Create (const V : String);

    Procedure InsertAfter (const V : String); reintroduce; overload;
    Procedure InsertBefore (const V : String); reintroduce; overload;
    Procedure InsertFirst (const V : String);
    Procedure Append (const V : String);
    Function  FindNext (const Find : String) : TDoublyLinkedString;
    Function  FindPrev (const Find : String) : TDoublyLinkedString;
  end;

  TLinkedObject = class (TLinkedItem)
    Value : TObject;

    Constructor Create (const V : TObject);

    Procedure InsertAfter (const V : TObject); reintroduce; overload;
    Procedure Append (const V : TObject);
    Function  FindNext (const Find : TObject) : TLinkedObject;
  end;
  TDoublyLinkedObject = class (TDoublyLinkedItem)
    Value : TObject;

    Constructor Create (const V : TObject);

    Procedure InsertAfter (const V : TObject); reintroduce; overload;
    Procedure InsertBefore (const V : TObject); reintroduce; overload;
    Procedure InsertFirst (const V : TObject);
    Procedure Append (const V : TObject);
    Function  FindNext (const Find : TObject) : TDoublyLinkedObject;
    Function  FindPrev (const Find : TObject) : TDoublyLinkedObject;
  end;


Function  AsLinkedIntegerList (const V : Array of Integer) : TLinkedInteger;
Function  AsLinkedInt64List (const V : Array of Int64) : TLinkedInt64;
Function  AsLinkedSingleList (const V : Array of Single) : TLinkedSingle;
Function  AsLinkedDoubleList (const V : Array of Double) : TLinkedDouble;
Function  AsLinkedExtendedList (const V : Array of Extended) : TLinkedExtended;
Function  AsLinkedStringList (const V : Array of String) : TLinkedString;
Function  AsDoublyLinkedIntegerList (const V : Array of Integer) : TDoublyLinkedInteger;
Function  AsDoublyLinkedInt64List (const V : Array of Int64) : TDoublyLinkedInt64;
Function  AsDoublyLinkedSingleList (const V : Array of Single) : TDoublyLinkedSingle;
Function  AsDoublyLinkedDoubleList (const V : Array of Double) : TDoublyLinkedDouble;
Function  AsDoublyLinkedExtendedList (const V : Array of Extended) : TDoublyLinkedExtended;
Function  AsDoublyLinkedStringList (const V : Array of String) : TDoublyLinkedString;



{                                                                              }
{ TDoublyLinkedList                                                            }
{                                                                              }
type
  TDoublyLinkedList = class
    protected
    FFirst, FLast : TDoublyLinkedItem;
    FCount        : Integer;

    public
    Destructor Destroy; override;

    Property  First : TDoublyLinkedItem read FFirst;
    Property  Last : TDoublyLinkedItem read FLast;
    Function  IsEmpty : Boolean;
    Function  Count : Integer;

    Procedure Remove (const Item : TDoublyLinkedItem);
    Function  RemoveFirst : TDoublyLinkedItem;
    Function  RemoveLast : TDoublyLinkedItem;

    Procedure Delete (const Item : TDoublyLinkedItem);
    Procedure DeleteFirst;
    Procedure DeleteLast;

    Procedure Append (const Item : TDoublyLinkedItem);
    Procedure InsertFront (const Item : TDoublyLinkedItem);
  end;



implementation



{                                                                              }
{ TLinkedItem                                                                  }
{                                                                              }
Function TLinkedItem.HasNext : Boolean;
  Begin
    Result := Assigned (Next);
  End;

Function TLinkedItem.Last : TLinkedItem;
var P : TLinkedItem;
  Begin
    P := self;
    Repeat
      Result := P;
      P := P.Next;
    Until not Assigned (P);
  End;

Function TLinkedItem.Count : Integer;
var N : TLinkedItem;
  Begin
    Result := 1;
    N := self.Next;
    While Assigned (N) do
      begin
        Inc (Result);
        N := N.Next;
      end;
  End;

Function TLinkedItem.RemoveNext : TLinkedItem;
  Begin
    Result := Next;
    if Assigned (Result) then
      Next := Result.Next;
  End;

Procedure TLinkedItem.DeleteNext;
  Begin
    RemoveNext.Free;
  End;

Procedure TLinkedItem.InsertAfter (const Item : TLinkedItem);
  Begin
    Item.Next := Next;
    Next := Item;
  End;

Destructor TLinkedItem.DestroyList;
var N : TLinkedItem;
  Begin
    While Assigned (Next) do
      begin
        N := Next;
        Next := N.Next;
        N.Free;
      end;
    inherited Destroy;
  End;



{                                                                              }
{ TDoublyLinkedItem                                                            }
{                                                                              }
Function TDoublyLinkedItem.HasNext : Boolean;
  Begin
    Result := Assigned (Next);
  End;

Function TDoublyLinkedItem.Last : TDoublyLinkedItem;
var P : TDoublyLinkedItem;
  Begin
    P := self;
    Repeat
      Result := P;
      P := P.Next;
    Until not Assigned (P);
  End;

Function TDoublyLinkedItem.Count : Integer;
var N : TDoublyLinkedItem;
  Begin
    Result := 1;
    N := self.Next;
    While Assigned (N) do
      begin
        Inc (Result);
        N := N.Next;
      end;
  End;

Function TDoublyLinkedItem.HasPrev : Boolean;
  Begin
    Result := Assigned (Prev);
  End;

Function TDoublyLinkedItem.First : TDoublyLinkedItem;
var P : TDoublyLinkedItem;
  Begin
    P := self;
    Repeat
      Result := P;
      P := P.Prev;
    Until not Assigned (P);
  End;

Procedure TDoublyLinkedItem.Delete;
  Begin
    Remove;
    Free;
  End;

Procedure TDoublyLinkedItem.Remove;
  Begin
    if Assigned (Next) then
      Next.Prev := Prev;
    if Assigned (Prev) then
      Prev.Next := Next;
  End;

Function TDoublyLinkedItem.RemoveNext : TDoublyLinkedItem;
  Begin
    Result := Next;
    if Assigned (Result) then
      begin
        Next := Result.Next;
        if Assigned (Next) then
          Next.Prev := self;
      end;
  End;

Procedure TDoublyLinkedItem.DeleteNext;
  Begin
    RemoveNext.Free;
  End;

Function TDoublyLinkedItem.RemovePrev : TDoublyLinkedItem;
  Begin
    Result := Prev;
    if Assigned (Result) then
      begin
        Prev := Result.Prev;
        if Assigned (Prev) then
          Prev.Next := self;
      end;
  End;

Procedure TDoublyLinkedItem.DeletePrev;
  Begin
    RemovePrev.Free;
  End;

Procedure TDoublyLinkedItem.InsertAfter (const Item : TDoublyLinkedItem);
  Begin
    Item.Next := Next;
    Item.Prev := self;
    Next := Item;
  End;

Procedure TDoublyLinkedItem.InsertBefore (const Item : TDoublyLinkedItem);
  Begin
    Item.Next := self;
    Item.Prev := Prev;
    Prev := Item;
  End;

Destructor TDoublyLinkedItem.DestroyList;
var N : TDoublyLinkedItem;
  Begin
    While Assigned (Next) do
      begin
        N := Next;
        Next := N.Next;
        N.Free;
      end;
    inherited Destroy;
  End;


{                                                                              }
{ TLinkedInteger                                                               }
{                                                                              }
Constructor TLinkedInteger.Create (const V : Integer);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedInteger.InsertAfter (const V : Integer);
  Begin
    inherited InsertAfter (TLinkedInteger.Create (V));
  End;

Procedure TLinkedInteger.Append (const V : Integer);
  Begin
    TLinkedInteger (Last).InsertAfter (V);
  End;

Function TLinkedInteger.FindNext (const Find : Integer) : TLinkedInteger;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedInteger (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedInteger                                                         }
{                                                                              }
Constructor TDoublyLinkedInteger.Create (const V : Integer);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedInteger.InsertAfter (const V : Integer);
  Begin
    inherited InsertAfter (TDoublyLinkedInteger.Create (V));
  End;

Procedure TDoublyLinkedInteger.InsertBefore (const V : Integer);
  Begin
    inherited InsertBefore (TDoublyLinkedInteger.Create (V));
  End;

Procedure TDoublyLinkedInteger.InsertFirst (const V : Integer);
  Begin
    TDoublyLinkedInteger (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedInteger.Append (const V : Integer);
  Begin
    TDoublyLinkedInteger (Last).InsertAfter (V);
  End;

Function TDoublyLinkedInteger.FindNext (const Find : Integer) : TDoublyLinkedInteger;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedInteger (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedInteger.FindPrev (const Find : Integer) : TDoublyLinkedInteger;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedInteger (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedInt64                                                                 }
{                                                                              }
Constructor TLinkedInt64.Create (const V : Int64);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedInt64.InsertAfter (const V : Int64);
  Begin
    inherited InsertAfter (TLinkedInt64.Create (V));
  End;

Procedure TLinkedInt64.Append (const V : Int64);
  Begin
    TLinkedInt64 (Last).InsertAfter (V);
  End;

Function TLinkedInt64.FindNext (const Find : Int64) : TLinkedInt64;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedInt64 (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedInt64                                                           }
{                                                                              }
Constructor TDoublyLinkedInt64.Create (const V : Int64);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedInt64.InsertAfter (const V : Int64);
  Begin
    inherited InsertAfter (TDoublyLinkedInt64.Create (V));
  End;

Procedure TDoublyLinkedInt64.InsertBefore (const V : Int64);
  Begin
    inherited InsertBefore (TDoublyLinkedInt64.Create (V));
  End;

Procedure TDoublyLinkedInt64.InsertFirst (const V : Int64);
  Begin
    TDoublyLinkedInt64 (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedInt64.Append (const V : Int64);
  Begin
    TDoublyLinkedInt64 (Last).InsertAfter (V);
  End;

Function TDoublyLinkedInt64.FindNext (const Find : Int64) : TDoublyLinkedInt64;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedInt64 (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedInt64.FindPrev (const Find : Int64) : TDoublyLinkedInt64;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedInt64 (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedSingle                                                                }
{                                                                              }
Constructor TLinkedSingle.Create (const V : Single);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedSingle.InsertAfter (const V : Single);
  Begin
    inherited InsertAfter (TLinkedSingle.Create (V));
  End;

Procedure TLinkedSingle.Append (const V : Single);
  Begin
    TLinkedSingle (Last).InsertAfter (V);
  End;

Function TLinkedSingle.FindNext (const Find : Single) : TLinkedSingle;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedSingle (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedSingle                                                          }
{                                                                              }
Constructor TDoublyLinkedSingle.Create (const V : Single);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedSingle.InsertAfter (const V : Single);
  Begin
    inherited InsertAfter (TDoublyLinkedSingle.Create (V));
  End;

Procedure TDoublyLinkedSingle.InsertBefore (const V : Single);
  Begin
    inherited InsertBefore (TDoublyLinkedSingle.Create (V));
  End;

Procedure TDoublyLinkedSingle.InsertFirst (const V : Single);
  Begin
    TDoublyLinkedSingle (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedSingle.Append (const V : Single);
  Begin
    TDoublyLinkedSingle (Last).InsertAfter (V);
  End;

Function TDoublyLinkedSingle.FindNext (const Find : Single) : TDoublyLinkedSingle;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedSingle (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedSingle.FindPrev (const Find : Single) : TDoublyLinkedSingle;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedSingle (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedDouble                                                                }
{                                                                              }
Constructor TLinkedDouble.Create (const V : Double);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedDouble.InsertAfter (const V : Double);
  Begin
    inherited InsertAfter (TLinkedDouble.Create (V));
  End;

Procedure TLinkedDouble.Append (const V : Double);
  Begin
    TLinkedDouble (Last).InsertAfter (V);
  End;

Function TLinkedDouble.FindNext (const Find : Double) : TLinkedDouble;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedDouble (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedDouble                                                          }
{                                                                              }
Constructor TDoublyLinkedDouble.Create (const V : Double);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedDouble.InsertAfter (const V : Double);
  Begin
    inherited InsertAfter (TDoublyLinkedDouble.Create (V));
  End;

Procedure TDoublyLinkedDouble.InsertBefore (const V : Double);
  Begin
    inherited InsertBefore (TDoublyLinkedDouble.Create (V));
  End;

Procedure TDoublyLinkedDouble.InsertFirst (const V : Double);
  Begin
    TDoublyLinkedDouble (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedDouble.Append (const V : Double);
  Begin
    TDoublyLinkedDouble (Last).InsertAfter (V);
  End;

Function TDoublyLinkedDouble.FindNext (const Find : Double) : TDoublyLinkedDouble;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedDouble (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedDouble.FindPrev (const Find : Double) : TDoublyLinkedDouble;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedDouble (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedExtended                                                              }
{                                                                              }
Constructor TLinkedExtended.Create (const V : Extended);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedExtended.InsertAfter (const V : Extended);
  Begin
    inherited InsertAfter (TLinkedExtended.Create (V));
  End;

Procedure TLinkedExtended.Append (const V : Extended);
  Begin
    TLinkedExtended (Last).InsertAfter (V);
  End;

Function TLinkedExtended.FindNext (const Find : Extended) : TLinkedExtended;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedExtended (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedExtended                                                        }
{                                                                              }
Constructor TDoublyLinkedExtended.Create (const V : Extended);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedExtended.InsertAfter (const V : Extended);
  Begin
    inherited InsertAfter (TDoublyLinkedExtended.Create (V));
  End;

Procedure TDoublyLinkedExtended.InsertBefore (const V : Extended);
  Begin
    inherited InsertBefore (TDoublyLinkedExtended.Create (V));
  End;

Procedure TDoublyLinkedExtended.InsertFirst (const V : Extended);
  Begin
    TDoublyLinkedExtended (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedExtended.Append (const V : Extended);
  Begin
    TDoublyLinkedExtended (Last).InsertAfter (V);
  End;

Function TDoublyLinkedExtended.FindNext (const Find : Extended) : TDoublyLinkedExtended;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedExtended (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedExtended.FindPrev (const Find : Extended) : TDoublyLinkedExtended;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedExtended (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedString                                                                }
{                                                                              }
Constructor TLinkedString.Create (const V : String);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedString.InsertAfter (const V : String);
  Begin
    inherited InsertAfter (TLinkedString.Create (V));
  End;

Procedure TLinkedString.Append (const V : String);
  Begin
    TLinkedString (Last).InsertAfter (V);
  End;

Function TLinkedString.FindNext (const Find : String) : TLinkedString;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedString (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedString                                                          }
{                                                                              }
Constructor TDoublyLinkedString.Create (const V : String);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedString.InsertAfter (const V : String);
  Begin
    inherited InsertAfter (TDoublyLinkedString.Create (V));
  End;

Procedure TDoublyLinkedString.InsertBefore (const V : String);
  Begin
    inherited InsertBefore (TDoublyLinkedString.Create (V));
  End;

Procedure TDoublyLinkedString.InsertFirst (const V : String);
  Begin
    TDoublyLinkedString (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedString.Append (const V : String);
  Begin
    TDoublyLinkedString (Last).InsertAfter (V);
  End;

Function TDoublyLinkedString.FindNext (const Find : String) : TDoublyLinkedString;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedString (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedString.FindPrev (const Find : String) : TDoublyLinkedString;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedString (Result.Prev);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TLinkedObject                                                                }
{                                                                              }
Constructor TLinkedObject.Create (const V : TObject);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TLinkedObject.InsertAfter (const V : TObject);
  Begin
    inherited InsertAfter (TLinkedObject.Create (V));
  End;

Procedure TLinkedObject.Append (const V : TObject);
  Begin
    TLinkedObject (Last).InsertAfter (V);
  End;

Function TLinkedObject.FindNext (const Find : TObject) : TLinkedObject;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TLinkedObject (Result.Next);
    Until not Assigned (Result);
  End;



{                                                                              }
{ TDoublyLinkedObject                                                          }
{                                                                              }
Constructor TDoublyLinkedObject.Create (const V : TObject);
  Begin
    inherited Create;
    Value := V;
  End;

Procedure TDoublyLinkedObject.InsertAfter (const V : TObject);
  Begin
    inherited InsertAfter (TDoublyLinkedObject.Create (V));
  End;

Procedure TDoublyLinkedObject.InsertBefore (const V : TObject);
  Begin
    inherited InsertBefore (TDoublyLinkedObject.Create (V));
  End;

Procedure TDoublyLinkedObject.InsertFirst (const V : TObject);
  Begin
    TDoublyLinkedObject (First).InsertBefore (V);
  End;

Procedure TDoublyLinkedObject.Append (const V : TObject);
  Begin
    TDoublyLinkedObject (Last).InsertAfter (V);
  End;

Function TDoublyLinkedObject.FindNext (const Find : TObject) : TDoublyLinkedObject;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedObject (Result.Next);
    Until not Assigned (Result);
  End;

Function TDoublyLinkedObject.FindPrev (const Find : TObject) : TDoublyLinkedObject;
  Begin
    Result := self;
    Repeat
      if Result.Value = Find then
        exit;
      Result := TDoublyLinkedObject (Result.Prev);
    Until not Assigned (Result);
  End;






{                                                                              }
{ Open array to Linked list                                                    }
{                                                                              }
Function AsLinkedIntegerList (const V : Array of Integer) : TLinkedInteger;
var I, L : TLinkedInteger;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedInteger.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsLinkedInt64List (const V : Array of Int64) : TLinkedInt64;
var I, L : TLinkedInt64;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedInt64.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsLinkedSingleList (const V : Array of Single) : TLinkedSingle;
var I, L : TLinkedSingle;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedSingle.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsLinkedDoubleList (const V : Array of Double) : TLinkedDouble;
var I, L : TLinkedDouble;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedDouble.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsLinkedExtendedList (const V : Array of Extended) : TLinkedExtended;
var I, L : TLinkedExtended;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedExtended.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsLinkedStringList (const V : Array of String) : TLinkedString;
var I, L : TLinkedString;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TLinkedString.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedIntegerList (const V : Array of Integer) : TDoublyLinkedInteger;
var I, L : TDoublyLinkedInteger;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedInteger.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedInt64List (const V : Array of Int64) : TDoublyLinkedInt64;
var I, L : TDoublyLinkedInt64;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedInt64.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedSingleList (const V : Array of Single) : TDoublyLinkedSingle;
var I, L : TDoublyLinkedSingle;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedSingle.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedDoubleList (const V : Array of Double) : TDoublyLinkedDouble;
var I, L : TDoublyLinkedDouble;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedDouble.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedExtendedList (const V : Array of Extended) : TDoublyLinkedExtended;
var I, L : TDoublyLinkedExtended;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedExtended.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;

Function AsDoublyLinkedStringList (const V : Array of String) : TDoublyLinkedString;
var I, L : TDoublyLinkedString;
    F    : Integer;
  Begin
    Result := nil;
    L := nil;
    For F := 0 to High (V) do
      begin
        I := TDoublyLinkedString.Create (V [F]);
        if not Assigned (L) then
          begin
            L := I;
            Result := I;
          end else
          begin
            L.InsertAfter (I);
            L := I;
          end;
      end;
  End;




{                                                                              }
{ TDoublyLinkedList                                                            }
{                                                                              }
Destructor TDoublyLinkedList.Destroy;
  Begin
    if Assigned (FFirst) then
      FFirst.DestroyList;
    FFirst := nil;
    FLast := nil;
    inherited Destroy;
  End;

Function TDoublyLinkedList.Count : Integer;
  Begin
    Result := FCount;
  End;

Function TDoublyLinkedList.IsEmpty : Boolean;
  Begin
    Result := not Assigned (FFirst);
  End;

Procedure TDoublyLinkedList.Append (const Item : TDoublyLinkedItem);
  Begin
    if not Assigned (FFirst) then
      begin
        FFirst := Item;
        FLast := Item;
      end else
      begin
        FLast.InsertAfter (Item);
        FLast := Item;
      end;
    Inc (FCount);
  End;

Procedure TDoublyLinkedList.InsertFront (const Item : TDoublyLinkedItem);
  Begin
    if not Assigned (FFirst) then
      begin
        FFirst := Item;
        FLast := Item;
      end else
      begin
        FFirst.InsertBefore (Item);
        FFirst := Item;
      end;
    Inc (FCount);
  End;

Procedure TDoublyLinkedList.Remove (const Item : TDoublyLinkedItem);
  Begin
    if not Assigned (Item) then
      exit;
    if FFirst = Item then
      FFirst := Item.Next;
    if FLast = Item then
      FLast := Item.Prev;
    Item.Remove;
    Dec (FCount);
  End;

Function TDoublyLinkedList.RemoveFirst : TDoublyLinkedItem;
  Begin
    Result := FFirst;
    if not Assigned (Result) then
      exit;
    if Result = FLast then
      begin
        FFirst := nil;
        FLast := nil;
      end else
      begin
        Result.Remove;
        FFirst := Result.Next;
      end;
    Dec (FCount);
  End;

Function TDoublyLinkedList.RemoveLast : TDoublyLinkedItem;
  Begin
    Result := FLast;
    if not Assigned (Result) then
      exit;
    if Result = FFirst then
      begin
        FFirst := nil;
        FLast := nil;
      end else
      begin
        Result.Remove;
        FLast := Result.Prev;
      end;
    Dec (FCount);
  End;

Procedure TDoublyLinkedList.Delete (const Item : TDoublyLinkedItem);
  Begin
    Remove (Item);
    Item.Free;
  End;

Procedure TDoublyLinkedList.DeleteFirst;
  Begin
    RemoveFirst.Free;
  End;

Procedure TDoublyLinkedList.DeleteLast;
  Begin
    RemoveLast.Free;
  End;



end.

