unit PSQLSamp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, DBGrids,
  PSQLVar, N8Script, PSQLDb, N8Query, Db, N8Table, DBTables, ExtCtrls,
  DBCtrls, N8DtSet, ComCtrls;

type
  TFormN8PSQLSample = class(TForm)
    XQLDatabase1: TN8PSQLDatabase;
    XQLScript1: TN8PSQLScript;
    GBDatabase: TGroupBox;
    BLogin: TButton;
    BLogout: TButton;
    EUser: TEdit;
    EPass: TEdit;
    Label9: TLabel;
    Label10: TLabel;
    MQuery: TMemo;
    BClose: TButton;
    BOpen: TButton;
    BExec: TButton;
    EVarName: TEdit;
    Label1: TLabel;
    BSet: TButton;
    BGet: TButton;
    EString: TEdit;
    EBoolean: TEdit;
    Bboolget: TButton;
    BboolSet: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Bintset: TButton;
    Bintget: TButton;
    EInteger: TEdit;
    EFloat: TEdit;
    Bfloatget: TButton;
    Bfloatset: TButton;
    Label4: TLabel;
    Label5: TLabel;
    Bdtset: TButton;
    Bdtget: TButton;
    EDateTime: TEdit;
    EDate: TEdit;
    Bdateget: TButton;
    Bdateset: TButton;
    Label7: TLabel;
    Label8: TLabel;
    Btimeset: TButton;
    Btimeget: TButton;
    ETime: TEdit;
    ECurrency: TEdit;
    Bcurget: TButton;
    Bcurset: TButton;
    Label6: TLabel;
    XQLVar1: TN8PSQLVar;
    Label11: TLabel;
    Label12: TLabel;
    BBookmark: TButton;
    BGoto: TButton;
    GBTransaction: TGroupBox;
    BStartTr: TButton;
    BCommit: TButton;
    BRollback: TButton;
    Button1: TButton;
    Button2: TButton;
    EDatabaseName: TComboBox;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    DataSource1: TDataSource;
    XQLQuery1: TN8PSQLQuery;
    PageControl1: TPageControl;
    TSBase: TTabSheet;
    TSTable: TTabSheet;
    TSQuery: TTabSheet;
    TSScript: TTabSheet;
    TSVar: TTabSheet;
    DataSource2: TDataSource;
    DBGrid2: TDBGrid;
    CBTableName: TComboBox;
    Label13: TLabel;
    BTableOpen: TButton;
    BTableClose: TButton;
    BTableSetBM: TButton;
    BTableGotoBM: TButton;
    DBNavigator2: TDBNavigator;
    N8PSQLTable1: TN8PSQLTable;
    MSQL: TMemo;
    procedure BLoginClick(Sender: TObject);
    procedure BLogoutClick(Sender: TObject);
    procedure BOpenClick(Sender: TObject);
    procedure BCloseClick(Sender: TObject);
    procedure BExecClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BSetClick(Sender: TObject);
    procedure BGetClick(Sender: TObject);
    procedure BboolSetClick(Sender: TObject);
    procedure BboolgetClick(Sender: TObject);
    procedure BintsetClick(Sender: TObject);
    procedure BintgetClick(Sender: TObject);
    procedure BfloatsetClick(Sender: TObject);
    procedure BfloatgetClick(Sender: TObject);
    procedure BcursetClick(Sender: TObject);
    procedure BcurgetClick(Sender: TObject);
    procedure BdtsetClick(Sender: TObject);
    procedure BdtgetClick(Sender: TObject);
    procedure BdatesetClick(Sender: TObject);
    procedure BdategetClick(Sender: TObject);
    procedure BtimesetClick(Sender: TObject);
    procedure BtimegetClick(Sender: TObject);
    procedure XQLDatabase1Login(Database: TN8PSQLDatabase; var UserID,
      Password: String);
    procedure Button15Click(Sender: TObject);
    procedure BBookmarkClick(Sender: TObject);
    procedure BGotoClick(Sender: TObject);
    procedure BStartTrClick(Sender: TObject);
    procedure BCommitClick(Sender: TObject);
    procedure BRollbackClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BTableSetBMClick(Sender: TObject);
    procedure BTableOpenClick(Sender: TObject);
    procedure BTableCloseClick(Sender: TObject);
    procedure BTableGotoBMClick(Sender: TObject);
  private
    b,bt:TBookmarkStr;
  public
    { Public declarations }
  end;

var
  FormN8PSQLSample: TFormN8PSQLSample;

implementation

uses n8sqlapi,dbNameL;

{$R *.DFM}

procedure TFormN8PSQLSample.BLoginClick(Sender: TObject);
begin
  XQLDatabase1.DatabaseName:=EDatabaseName.Text;
  XQLDatabase1.UserID:=EUser.Text;
  XQLDatabase1.Connected:=True;
  if XQLDatabase1.Connected then
  begin
    BLogin.Enabled:=False;
    BLogout.Enabled:=True;
    XQLDatabase1.LoadTableList(CBTableName.Items);
    CBTableName.ItemIndex:=0;
  end;
end;

procedure TFormN8PSQLSample.BLogoutClick(Sender: TObject);
begin
  XQLDatabase1.Connected:=False;
  BLogin.Enabled:=True;
  BLogout.Enabled:=False;
end;

procedure TFormN8PSQLSample.BOpenClick(Sender: TObject);
begin
  XQLQuery1.SQL.Assign(MQuery.Lines);
  XQLQuery1.Active:=True;
end;

procedure TFormN8PSQLSample.BCloseClick(Sender: TObject);
begin
  XQLQuery1.Active:=False;
end;

procedure TFormN8PSQLSample.BExecClick(Sender: TObject);
begin
  XQLScript1.SQL.Assign(MSQL.Lines);
  XQLScript1.Execute;
end;

procedure TFormN8PSQLSample.FormDestroy(Sender: TObject);
begin
  XQLDatabase1.Connected:=False;
end;

procedure TFormN8PSQLSample.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePage:=TSBase;
  LoadDBNames(EDatabaseName.Items);
  MSQL.Lines.Assign(XQLScript1.SQL);
  MQuery.Lines.Assign(XQLQuery1.SQL);
end;

procedure TFormN8PSQLSample.BSetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsXQLString:=EString.Text;
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BGetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EString.Text:=XQLVar1.AsXQLString;
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BboolSetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsBoolean:=StrToint(EBoolean.Text)<>0;
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BboolgetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EBoolean.Text:=IntToStr(Integer(XQLVar1.AsBoolean));
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BintsetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsInteger:=StrToInt(EInteger.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BintgetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EInteger.Text:=IntToStr(XQLVar1.AsInteger);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BfloatsetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsFloat:=StrToFloat(EFloat.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BfloatgetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EFloat.Text:=FloatToStr(XQLVar1.AsFloat);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BcursetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsCurrency:=StrToCurr(ECurrency.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BcurgetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  ECurrency.Text:=CurrToStr(XQLVar1.AsCurrency);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BdtsetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsDateTime:=StrToDateTime(EDateTime.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BdtgetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EDateTime.Text:=DateTimeToStr(XQLVar1.AsDateTime);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BdatesetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsDate:=StrToDate(EDate.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BdategetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  EDate.Text:=DateToStr(XQLVar1.AsDate);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BtimesetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  XQLVar1.AsTime:=StrToTime(ETime.Text);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.BtimegetClick(Sender: TObject);
begin
  XQLVar1.VarName:=EVarName.Text;
  XQLVar1.Enabled:=True;
  ETime.Text:=TimeToStr(XQLVar1.AsTime);
  XQLVar1.Enabled:=False;
end;

procedure TFormN8PSQLSample.XQLDatabase1Login(Database: TN8PSQLDatabase; var UserID,
  Password: String);
begin
  Password:=EPass.Text;
end;

procedure TFormN8PSQLSample.Button15Click(Sender: TObject);
type
  tCountSavePool = packed record
    a:array[0..128] of Char;
    tCount:SMALLINT;
    b:array[0..128] of Char;
  end;
var
  tCount:tCountSavePool;
  Remote:Integer;
  i,n:Integer;
  tBufLen:LONGINT;
  tBuf:array[0..60] of Char;
  bName:array[0..20] of Char;
begin
  try
    for Remote:=0 to 1 do
    begin
        if Remote>0 then RaiseXQLErrors(SQLGetCountRemoteDatabaseNames(tCount.tCount),[])
        else RaiseXQLErrors(SQLGetCountDatabaseNames(tCount.tCount),[]);
        if tCount.tCount>0 then
        begin
          try
            FillChar(tBuf,SizeOf(tBuf),0);
            repeat
              tBufLen:=SizeOf(tBuf);
              if Remote>0 then RaiseXQLErrors(SQLGetRemoteDatabaseNames(tBufLen,@tBuf),[2300,210])
              else RaiseXQLErrors(SQLGetDatabaseNames(tBufLen,@tBuf),[2300,210]);
              n:=tBufLen div 20;
              if n>0 then
              begin
                for i:=0 to n-1 do
                begin
                  Move(tBuf[i*20],bName,20);
                  bName[20]:=#0;
                end;
                Move(bName,tBuf,20);
              end;
            until n<(SizeOf(tBuf) div 20);
          except
          end;
        end;
    end;
  finally
    SQLUnloadDBNames(0);
  end;
end;

procedure TFormN8PSQLSample.BBookmarkClick(Sender: TObject);
begin
  b:=XQLQuery1.Bookmark;
end;

procedure TFormN8PSQLSample.BGotoClick(Sender: TObject);
begin
  XQLQuery1.Bookmark:=b;
end;

procedure TFormN8PSQLSample.BStartTrClick(Sender: TObject);
begin
  XQLDatabase1.StartTransaction;
end;

procedure TFormN8PSQLSample.BCommitClick(Sender: TObject);
begin
  XQLDatabase1.Commit;
end;

procedure TFormN8PSQLSample.BRollbackClick(Sender: TObject);
begin
  XQLDatabase1.Rollback;
end;

procedure TFormN8PSQLSample.Button1Click(Sender: TObject);
begin
  XQLDatabase1.CommitWork;
end;

procedure TFormN8PSQLSample.Button2Click(Sender: TObject);
begin
  XQLDatabase1.RollbackWork;
end;

procedure TFormN8PSQLSample.Button3Click(Sender: TObject);
begin
  XQLQuery1.Refresh;
end;

procedure TFormN8PSQLSample.BTableSetBMClick(Sender: TObject);
begin
  bt:=N8PSQLTable1.Bookmark;
end;

procedure TFormN8PSQLSample.BTableOpenClick(Sender: TObject);
begin
  N8PSQLTable1.TableName:=CBTableName.Text;
  N8PSQLTable1.Open;
end;

procedure TFormN8PSQLSample.BTableCloseClick(Sender: TObject);
begin
  N8PSQLTable1.Close;
end;

procedure TFormN8PSQLSample.BTableGotoBMClick(Sender: TObject);
begin
  N8PSQLTable1.Bookmark:=bt;
end;

end.
