unit AppEnv;

{  ******
   *
   * Module:    AppEnv
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    Core application behavior.
   *
   * Details:
   *
   *    This module encapsulates I/O to INI files.  It was first written for
   *    Delphi 1.0, so its design is very outdated now.  However, it does the
   *    job for our purposes here.
   *
   ******}

interface

uses SysUtils, WinProcs;

const INI_MAX_FILE_NAME_LENGTH = 128;
const INI_MAX_SECTION_NAME_LENGTH = 128;
const INI_MAX_KEY_NAME_LENGTH = 128;
const INI_MAX_DEFAULT_LENGTH = 128;
const INI_MAX_RESULT_LENGTH = 128;

type TAppEnvironment = class(TObject)
   private
      { Name of the application's .INI file. }
      m_szINIFilename: String;

   public

      { Public constructor }
      constructor Create(szINIFilename: String); Virtual;

      { Methods for getting and setting INI values. }
      function szGetINIFilename: String;
      function szGetINIString(szSection, szKey, szDefault: String): String;
      function iGetINIInteger(szSection, szKey: String; iDefault: Integer): Integer;
      procedure SetINIString(szSection, szKey, szNewValue: String);
end;

implementation

constructor TAppEnvironment.Create(szINIFilename: String);
begin
   { Stash away the INI file name for later use. }
   m_szINIFilename := szINIFilename;
end;

function TAppEnvironment.szGetINIString(szSection, szKey, szDefault: String): String;
var
   acININame: Array [0..INI_MAX_FILE_NAME_LENGTH + 1] of Char;
   acSection: Array [0..INI_MAX_SECTION_NAME_LENGTH + 1] of Char;
   acKey: Array [0..INI_MAX_KEY_NAME_LENGTH + 1] of Char;
   acDefault: Array [0..INI_MAX_DEFAULT_LENGTH + 1] of Char;
   acResult: Array [0..INI_MAX_RESULT_LENGTH + 1] of Char;

   iResult: Integer;
begin
   { Copy the parameters into API-compatible, NULL terminated strings. }
   strPCopy(acININame, m_szINIFilename);
   strPCopy(acSection, szSection);
   strPCopy(acKey, szKey);
   strPCopy(acDefault, szDefault);

   { The default return string will be empty. }
   acResult[0] := Char(0);

   { Call the Windows API to read the INI file. }
   iResult := GetPrivateProfileString(acSection,
                                      acKey,
                                      acDefault,
                                      acResult,
                                      INI_MAX_RESULT_LENGTH,
                                      acININame);

   { Return the result or default. }
   Result := StrPas(acResult);
end;

function TAppEnvironment.iGetINIInteger(szSection, szKey: String; iDefault: Integer): Integer;
var
   acININame: Array [0..INI_MAX_FILE_NAME_LENGTH + 1] of Char;
   acSection: Array [0..INI_MAX_SECTION_NAME_LENGTH + 1] of Char;
   acKey: Array [0..INI_MAX_KEY_NAME_LENGTH + 1] of Char;
begin
   { Copy the parameters into API-compatible, NULL terminated strings. }
   strPCopy(acININame, m_szINIFilename);
   strPCopy(acSection, szSection);
   strPCopy(acKey, szKey);

   { Call the Windows API to read the INI file. }
   Result := GetPrivateProfileInt(acSection,
                                  acKey,
                                  iDefault,
                                  acININame);
end;

procedure TAppEnvironment.SetINIString(szSection, szKey, szNewValue: String);
var
   acININame: Array [0..INI_MAX_FILE_NAME_LENGTH + 1] of Char;
   acSection: Array [0..INI_MAX_SECTION_NAME_LENGTH + 1] of Char;
   acKey: Array [0..INI_MAX_KEY_NAME_LENGTH + 1] of Char;
   acNewValue: Array [0..INI_MAX_RESULT_LENGTH + 1] of Char;

   bResult: Boolean;
begin
   { Copy the parameters into API-compatible, NULL terminated strings. }
   strPCopy(acININame, m_szINIFilename);
   strPCopy(acSection, szSection);
   strPCopy(acKey, szKey);
   strPCopy(acNewValue, szNewValue);

   { Call the Windows API to read the INI file. }
   bResult := WritePrivateProfileString(acSection,
                                        acKey,
                                        acNewValue,
                                        acININame);
end;

function TAppEnvironment.szGetINIFilename: String;
begin
   Result := m_szINIFilename;
end;

end.
