unit RocksEnv;

interface

uses GameEnv, WaveDev, RocksKbd, CanvsVid;

type TRocksEnvironment = class(TGameEnvironment)
   public
      { Public constructor and destructor. }
      constructor Create(szINIFilename: String);
      destructor Destroy;

   private

      { Input and output devices used throughout the game. }
end;

implementation

constructor TRocksEnvironment.Create(szINIFilename: String);
begin
   { Initialize our base class. }
   inherited Create(szINIFilename,
                    TWaveOutput.Create,
                    TCanvasVideo.Create,
                    TRocksKeyboard.Create);
end;

destructor TRocksEnvironment.Destroy;
begin
   { Destroy the I/O objects that we reated unpo construction. }
   devGetSoundDevice.Free;
   devGetVideoDevice.Free;
   devGetInputDevice.Free;

   { Perform default cleanup processing. }
   inherited Destroy;
end;

end.
 