unit SoundDev;

{  ******
   *
   * Module:    SoundDev
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    The TSoundDevice class is the base class for all sound output objects.
   *
   ****** }

interface

type TSoundDevice = class(TObject)
    private

        m_bSoundEnabled: Boolean;   { TRUE when sounds are enabled. }

    public
        { Public constructor. }
        constructor Create;

        { Method to play a sound on the given channel. }
        procedure PlaySound(szSound: String; iChannel: Integer); Virtual; Abstract;
        function iChannelsSupported: Integer; Virtual; Abstract;

        { Exposed properties. }
        property bSoundEnabled: Boolean   Read m_bSoundEnabled    Write m_bSoundEnabled;
end;

implementation

constructor TSoundDevice.Create;
begin
   inherited Create;

   m_bSoundEnabled := True;
end;

end.
