unit WaveMix;

interface

uses Forms, SysUtils, WinTypes, WinProcs, Classes;

const
     WMIX_QUEUEWAVE = $00;
     WMIX_CLEARQUEUE = $01;
     WMIX_USELRUCHANNEL = $02;
     WMIX_HIPRIORITY = $04;
     WMIX_WAIT = $08;
     WMIX_FILE = $0001;
     WMIX_CONFIG_CHANNELS = $1;
     WMIX_CONFIG_SAMPLINGRATE = $2;
     WMIX_OPENSINGLE = 0;	{ open the single channel specified by iChannel }
     WMIX_OPENALL = 1; { opens all the channels, iChannel ignored }
     WMIX_OPENCOUNT = 2; { open iChannel Channels (eg. if iChannel = 4 will create channels 0-3) }
     WMIX_ALL = $0001;
     MONO = 1;
     STEREO = 2;

type
   TMixConfig = record
       wSize: Word;
       dwFlags: LongInt;
       wChannels: Word;
       wSamplingRate: Word;
   end;
   PMixConfig = ^TMixConfig;

   TMixPlayParams = record
       wSize: Word;
       hMixSession: THandle;
       iChannel: Integer;
       lpMixWave: PLongInt;
       hWndNotify: THandle;
       dwFlags: LongInt;
       wLoops: Word;
   end;
   PMixPlayParams = ^TMixPlayParams;

   TCloseWaveInfo = record
       hSession: THandle;
       iChannel: Integer;
       lpMixWave: PLongInt;
   end;
   PCloseWaveInfo = ^TCloseWaveInfo;

var

   lpConfig: PMixConfig;
   lpMixPlayParams: PMixPlayParams;
   hInstance: Word;
   wResult: Word;
   lpPlayWaveInfo: PCloseWaveInfo;

function PlaySound(hWaveSession:THandle; lpMixWave:PLongInt; iOpenChannel,Replay: Integer): Word;
function OpenWaveSession: THandle;
function CloseChannel(hWaveSession:THandle;iOpenChannel:Integer):Word;
function FreeWave(hWaveSession:THandle;lpMixWave:PLongInt):Word;
function OpenWave(hWaveSession:THandle;pszFileName:PChar):PLongInt;
function CloseSession(hWaveSession:THandle):Word;
function WaveActivate (hWaveSession:THandle;Active:boolean):Word;

implementation


function WaveMixInit: THandle; far; external 'WAVEMIX';
function WaveMixConfigureInit(lpConfig: PMixConfig): THandle; far; external 'WAVEMIX';
function WaveMixActivate(hMixSession:THandle; Activate:Boolean): THandle; far; external 'WAVEMIX';
function WaveMixOpenWave(hMixSession:THandle; szWaveFileName:PChar; hInst:Word;
	 dwFlags:LongInt): PLongInt; far; external 'WAVEMIX';
function WaveMixOpenChannel(hMixSession:THandle; iChannel:Integer; dwFlags:LongInt):Word
    ; far; external 'WAVEMIX';
function WaveMixPlay(lpMixPlayParms:PMixPlayParams):Word ; far; external 'WAVEMIX';
function WaveMixFlushChannel(hMixSession:THandle; iChannel:Integer; dwFlags:LongInt):Word ; far; external 'WAVEMIX';
function WaveMixCloseChannel(hMixSession:THandle; iChannel:Integer; dwFlags:LongInt):Word ; far; external 'WAVEMIX';
function WaveMixFreeWave(hMixSession:THandle;lpMixWave:PLongInt):Word ; far; external 'WAVEMIX';
function WaveMixCloseSession(hMixSession:THandle):Word ; far; external 'WAVEMIX';
function WaveMixGetInfo(lpWaveMixInfo:PLongInt):Word ; far; external 'WAVEMIX';
procedure WaveMixPump; far; external 'WAVEMIX';

{OPEN WAVE FUNCTION}
function OpenWaveSession: THandle;
var
   lpCloseInfo: PCloseWaveInfo;
   lpMixWave: PLongInt;
   hInstance:THandle;
begin
   {create struct for Config Parameters and init }
{   lpConfig := New(PMixConfig);
   lpConfig^.wSize := SizeOf(TMixConfig);
   lpConfig^.dwFlags := 0;
   lpConfig^.wChannels := STEREO or WMIX_CONFIG_CHANNELS;
   lpConfig^.wSamplingRate := 44 or WMIX_CONFIG_SAMPLINGRATE;
   OpenWaveSession := WaveMixConfigureInit(lpConfig);}
   hInstance:=WaveMixInit;
   wResult := WaveMixOpenChannel(hInstance, 0, WMIX_OPENSINGLE);
   wResult := WaveMixOpenChannel(hInstance, 1, WMIX_OPENSINGLE);
   wResult := WaveMixOpenChannel(hInstance, 2, WMIX_OPENSINGLE);

   OpenWaveSession:=hInstance;

end;
function WaveActivate (hWaveSession:THandle;Active:boolean):Word ;
begin
   WaveActivate := WaveMixActivate(hWaveSession,Active); {eventually change to FALSE}
end;

function OpenWave(hWaveSession:THandle;pszFileName:PChar):PLongInt;
begin
     OpenWave:= WaveMixOpenWave(hWaveSession, pszFileName, 0, WMIX_FILE) ;
 end;

function PlaySound(hWaveSession:THandle; lpMixWave:PLongInt; iOpenChannel,Replay: Integer): Word;
var
   lpCloseInfo: PCloseWaveInfo;
   {lpMixWave: PLongInt;}
   iResult:Integer;
begin
{   lpCloseInfo := New(PCloseWaveInfo); }
{   lpMixWave := WaveMixOpenWave(hWaveSession, pszFileName, 0, WMIX_FILE);
   wResult := WaveMixOpenChannel(hWaveSession, iOpenChannel, WMIX_OPENSINGLE);
   wResult := WaveMixActivate(hWaveSession,TRUE);} {eventually change to FALSE}
   {create struct for Play Parameters and init }

   lpMixPlayParams := New(PMixPlayParams);
   lpMixPlayParams^.wSize := SizeOf(TMixPlayParams);
   lpMixPlayParams^.hMixSession := hWaveSession;
   lpMixPlayParams^.iChannel := iOpenChannel;
   lpMixPlayParams^.lpMixWave := lpMixWave;
   lpMixPlayParams^.dwFlags := WMIX_CLEARQUEUE or WMIX_HIPRIORITY;
   lpMixPlayParams^.wLoops := Replay;
   {for iResult := 1 to 5 do}
   wResult := WaveMixPlay(lpMixPlayParams);
   dispose (lpMixPlayParams);
   

   {lpCloseInfo^.hSession := hConfigurationHandle;
   lpCloseInfo^.iChannel:= iOpenChannel;
   lpCloseInfo^.lpMixWave:= lpMixWave;}

end;


function CloseChannel(hWaveSession:THandle;iOpenChannel:Integer):Word;
begin
   CloseChannel := WaveMixCloseChannel(hWaveSession, iOpenChannel, WMIX_ALL);
end;

function FreeWave(hWaveSession:THandle;lpMixWave:PLongInt):Word;
begin
     FreeWave := WaveMixFreeWave(hWaveSession, lpMixWave);
end;

function CloseSession(hWaveSession:THandle):Word;
begin
  CloseSession := WaveMixCloseSession(hWaveSession);
end;



end.

