//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RVEdit"
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1DragOver(TObject *Sender, TObject *Source,
	int X, int Y, TDragState State, bool &Accept)
{
  Accept = Source->InheritsFrom(__classid(TImage));
  // We cannot create/destroy inplace editors for cells just
  // in OnDragOver, so we position caret in OnWMSetCaretPos
  // We same technique should be used for OnMouseMove
  if (Accept)
    PostMessage(Handle, WM_SETCARETPOS, X,Y);
}
//---------------------------------------------------------------------------
void TForm1::MoveCaretTo(int X, int Y)
{
  TCustomRVFormattedData* RVData;
  int ItemNo, Offs;
  X += RichViewEdit1->HScrollPos;
  Y += RichViewEdit1->VScrollPos*RichViewEdit1->VSmallStep;
  RichViewEdit1->GetItemAt(X,Y,RVData,ItemNo,Offs,false);
  RVData = (TCustomRVFormattedData*)(RVData->Edit());
  if (ItemNo<0)
    return;
  RVData->SetSelectionBounds(ItemNo, Offs, ItemNo, Offs);
  RVData->Invalidate();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichViewEdit1DragDrop(TObject *Sender, TObject *Source,
	int X, int Y)
{
  // Dragging is finished. Inserting picture.
  MoveCaretTo(X, Y);
  Graphics::TBitmap* bmp = new Graphics::TBitmap;
  bmp->Assign(((TImage*)Source)->Picture->Bitmap);
  RichViewEdit1->InsertPicture("", bmp, rvvaBaseline);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::WMSetCaretPos(TMessage &Message)
{
  MoveCaretTo(Message.WParam, Message.LParam);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichViewEdit1->Clear();
  int i;
  for (i=0; i<=5; i++)
    RichViewEdit1->AddNL("Drag images from the right and drop them here",0,0);

  TRVTableItemInfo* table = new TRVTableItemInfo(1,2, RichViewEdit1->RVData);
  table->CellBorderWidth = 1;
  table->BorderWidth     = 1;
  table->Cells[0][0]->Clear();
  table->Cells[0][0]->AddNL("Drag images from the right and drop them here",0,0);
  table->Cells[0][1]->Clear();
  table->Cells[0][1]->AddNL("Drag images from the right and drop them here",0,0);
  RichViewEdit1->AddItem("", table);

  for (i=0; i<50; i++)
    RichViewEdit1->AddNL("Drag images from the right and drop them here",0,0);
  RichViewEdit1->Format();
}
//---------------------------------------------------------------------------
