// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RVTable.pas' rev: 3.00

#ifndef RVTableHPP
#define RVTableHPP
#include <RVStr.hpp>
#include <RVUndo.hpp>
#include <RVUni.hpp>
#include <TypInfo.hpp>
#include <PtRVData.hpp>
#include <PtblRV.hpp>
#include <RVFMisc.hpp>
#include <RVEdit.hpp>
#include <RichView.hpp>
#include <RVScroll.hpp>
#include <RVMarker.hpp>
#include <DLines.hpp>
#include <RVERVData.hpp>
#include <RVRVData.hpp>
#include <RVFuncs.hpp>
#include <RVStyle.hpp>
#include <CRVFData.hpp>
#include <CRVData.hpp>
#include <RVDataList.hpp>
#include <RVItem.hpp>
#include <RVClasses.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Rvtable
{
//-- type declarations -------------------------------------------------------
enum TRVCellHAlign { rvcLeft, rvcCenter, rvcRight };

enum TRVCellVAlign { rvcTop, rvcMiddle, rvcBottom, rvcVDefault };

enum TRVTableOption { rvtoEditing, rvtoRowSizing, rvtoColSizing, rvtoRowSelect, rvtoColSelect, rvtoRTFSaveCellPixelBestWidth, 
	rvtoRTFAllowAutofit, rvtoHideGridLines, rvtoOverlappingCorners, rvtoCellBelowBorders };

typedef Set<TRVTableOption, rvtoEditing, rvtoCellBelowBorders>  TRVTableOptions;

enum TRVTablePrintOption { rvtoHalftoneBorders, rvtoRowsSplit, rvtoWhiteBackground };

typedef Set<TRVTablePrintOption, rvtoHalftoneBorders, rvtoWhiteBackground>  TRVTablePrintOptions;

enum TRVTableBorderStyle { rvtbRaised, rvtbLowered, rvtbColor, rvtbRaisedColor, rvtbLoweredColor };

typedef int TRVHTMLLength;

class DELPHICLASS TRVTableItemInfo;
typedef void __fastcall (__closure *TRVCellEditingEvent)(TRVTableItemInfo* Sender, int Row, int Col, 
	bool Automatic, bool &AllowEdit);

class DELPHICLASS TRVTableCellData;
class DELPHICLASS TRVTableRow;
class PASCALIMPLEMENTATION TRVTableCellData : public Rvdatalist::TRVItemFormattedData 
{
	typedef Rvdatalist::TRVItemFormattedData inherited;
	
private:
	Graphics::TColor FColor;
	TRVCellVAlign FVAlign;
	TRVHTMLLength FBestWidth;
	int FBestHeight;
	int FRowSpan;
	int FColSpan;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	Rvstyle::TRVBooleanRect* FVisibleBorders;
	Crvfdata::TCustomRVFormattedData* FChosenRVData;
	Rvitem::TCustomRVItemInfo* FChosenItem;
	Rvundo::TRVUndoInfo* ContainerUndoItem;
	Graphics::TColor FBorderColor;
	Graphics::TColor FBorderLightColor;
	void __fastcall SetBestHeight(const int Value);
	void __fastcall SetBestWidth(const TRVHTMLLength Value);
	void __fastcall SetVisibleBorders(const Rvstyle::TRVBooleanRect* Value);
	bool __fastcall CanClear(void);
	void __fastcall SetColor(const Graphics::TColor Value);
	
protected:
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall AssignSizeFrom(TRVTableCellData* Cell);
	TRVCellVAlign __fastcall GetRealVAlign(void);
	int __fastcall GetExtraVOffs(void);
	DYNAMIC bool __fastcall SupportsPageBreaks(void);
	virtual Rvscroll::TRVOptions __fastcall GetOptions(void);
	DYNAMIC void __fastcall ResetSubCoords(void);
	
public:
	DYNAMIC void __fastcall GetParentInfo(int &ParentItemNo, Rvitem::TRVStoreSubRVData* &Location);
	TRVTableItemInfo* __fastcall GetTable(void);
	void __fastcall AssignAttributesFrom(TRVTableCellData* Cell, bool IncludeSize, int DivColSpan, int 
		DivRowSpan);
	DYNAMIC void __fastcall Deselect(Rvitem::TCustomRVItemInfo* NewPartiallySelected, bool MakeEvent);
	DYNAMIC Controls::TWinControl* __fastcall GetEditor(void);
	virtual void __fastcall GetOrigin(int &ALeft, int &ATop);
	DYNAMIC void __fastcall GetOriginEx(int &ALeft, int &ATop);
	virtual int __fastcall GetWidth(void);
	virtual int __fastcall GetHeight(void);
	virtual Graphics::TColor __fastcall GetColor(void);
	virtual int __fastcall GetHOffs(void);
	virtual int __fastcall GetVOffs(void);
	virtual int __fastcall GetAreaWidth(void);
	DYNAMIC void __fastcall AssignChosenRVData(Crvfdata::TCustomRVFormattedData* RVData, Rvitem::TCustomRVItemInfo* 
		Item);
	DYNAMIC void __fastcall UnassignChosenRVData(Crvdata::TCustomRVData* RVData);
	DYNAMIC Crvdata::TCustomRVData* __fastcall GetChosenRVData(void);
	DYNAMIC Rvitem::TCustomRVItemInfo* __fastcall GetChosenItem(void);
	void __fastcall MovingToUndoList(Rvundo::TRVUndoInfo* AContainerUndoItem);
	void __fastcall MovingFromUndoList(void);
	int __fastcall GetCellHeight(void);
	int __fastcall GetMinWidth(Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas);
	bool __fastcall HasData(bool CheckStyles);
	virtual Crvdata::TCustomRVData* __fastcall GetRVData(void);
	DYNAMIC void __fastcall DoSelect(void);
	DYNAMIC void __fastcall ControlAction2(Rvstyle::TRVControlAction ControlAction, int ItemNo, Controls::TControl* 
		&Control);
	virtual void __fastcall ItemAction(Rvstyle::TRVItemAction ItemAction, Rvitem::TCustomRVItemInfo* Item
		, System::AnsiString &Text, Crvdata::TCustomRVData* RVData);
	DYNAMIC void __fastcall AdjustFocus(int NewFocusedItemNo, Classes::TPersistent* TopLevelRVData, int 
		TopLevelItemNo);
	__fastcall TRVTableCellData(TRVTableRow* ARow);
	__fastcall virtual ~TRVTableCellData(void);
	DYNAMIC Rvmarker::TRVMarkerList* __fastcall GetMarkers(bool AllowCreate);
	DYNAMIC Crvdata::TCustomRVData* __fastcall Edit(void);
	__property int Left = {read=FLeft, nodefault};
	__property int Top = {read=FTop, nodefault};
	__property int Height = {read=FHeight, nodefault};
	__property int Width = {read=FWidth, nodefault};
	__property int ColSpan = {read=FColSpan, nodefault};
	__property int RowSpan = {read=FRowSpan, nodefault};
	
__published:
	__property Graphics::TColor Color = {read=FColor, write=SetColor, default=536870911};
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=FBorderColor, default=536870911
		};
	__property Graphics::TColor BorderLightColor = {read=FBorderLightColor, write=FBorderLightColor, default=536870911
		};
	__property TRVHTMLLength BestWidth = {read=FBestWidth, write=SetBestWidth, default=0};
	__property int BestHeight = {read=FBestHeight, write=SetBestHeight, default=0};
	__property Rvstyle::TRVBooleanRect* VisibleBorders = {read=FVisibleBorders, write=SetVisibleBorders
		};
	__property TRVCellVAlign VAlign = {read=FVAlign, write=FVAlign, default=3};
};

class DELPHICLASS TRVTableRows;
class PASCALIMPLEMENTATION TRVTableRows : public Rvclasses::TRVList 
{
	typedef Rvclasses::TRVList inherited;
	
private:
	HIDESBASE TRVTableRow* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVTableRow* Value);
	int __fastcall GetMinColWidth(int Col, Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas);
		
	int __fastcall GetPercentColWidth(int Col, int TableWidth);
	bool __fastcall IsPercentWidthColumn(int Col);
	int __fastcall GetPixelColWidth(int Col);
	bool __fastcall StartMergeCells(int TopRow, int LeftCol, int &ColSpan, int &RowSpan);
	
protected:
	Crvdata::TCustomRVData* FMainRVData;
	TRVTableItemInfo* FTable;
	int __fastcall GetColCount(void);
	bool __fastcall IsEmptyRows(int TopRow, int LeftCol, int ColSpan, int RowSpan, int TopRow2, int RowSpan2
		);
	bool __fastcall IsEmptyCols(int TopRow, int LeftCol, int ColSpan, int RowSpan, int LeftCol2, int ColSpan2
		);
	int __fastcall GetBestWidth(int TopRow, int LeftCol, int ColSpan, int RowSpan);
	void __fastcall UnmergeCell(int Row, int Col, bool UnmergeRows, bool UnmergeCols);
	void __fastcall UnmergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool UnmergeRows, bool 
		UnmergeCols);
	void __fastcall InsertRows(int Index, int Count, int CopyIndex, bool DivideHeights);
	void __fastcall InsertCols(int Index, int Count, int CopyIndex, bool DivideWidths);
	void __fastcall DeleteRows(int Index, int Count, bool DecreaseHeight);
	void __fastcall DeleteCols(int Index, int Count, bool DecreaseWidth);
	int __fastcall SplitCellVertically(int Row, int Col, int ColCount);
	int __fastcall SplitCellsVertically(int TopRow, int LeftCol, int ColSpan, int RowSpan, int ColCount
		);
	int __fastcall SplitCellHorizontally(int Row, int Col, int RowCount);
	int __fastcall SplitCellsHorizontally(int TopRow, int LeftCol, int ColSpan, int RowSpan, int RowCount
		);
	void __fastcall MovingToUndoList(int Row, int Col, int ColSpan, int RowSpan, Rvundo::TRVUndoInfo* AContainerUndoItem
		);
	void __fastcall MovingFromUndoList(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_BeforeInsertRows(int ItemNo, int Row, int Count);
	void __fastcall Do_InsertRows(int Row, int Count);
	void __fastcall Do_UnInsertRows(int Row, int Count);
	void __fastcall Do_BeforeInsertCell(int ItemNo, int Row, int Col);
	void __fastcall Do_BeforeSpreadOverEmptyCells(int ItemNo, int Row, int Col, int ColSpan);
	void __fastcall Do_SpreadOverEmptyCells(int Row, int Col, int ColSpan);
	void __fastcall Do_UnSpreadOverEmptyCells(int Row, int Col, int ColSpan);
	void __fastcall Do_SetSpan(int ItemNo, int Row, int Col, int Span, bool IsColSpan);
	void __fastcall Do_BeforeFreeEmptyCells(int ItemNo, int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_FreeEmptyCells(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_UnFreeEmptyCells(int Row, int Col, int ColSpan, int RowSpan);
	void __fastcall Do_BeforeInsertEmptyCells(int ItemNo, int Row, int Col, int ColCount, int RowCount)
		;
	void __fastcall Do_InsertEmptyCells(int Row, int Col, int ColCount, int RowCount);
	void __fastcall Do_UnInsertEmptyCells(int Row, int Col, int ColCount, int RowCount);
	void __fastcall Do_BeforeSplitCellHorz(int ItemNo, int Row, int Col, int Row2, bool DecreaseHeight)
		;
	void __fastcall Do_SplitCellHorz(int Row, int Col, int Row2, bool DecreaseHeight);
	void __fastcall Do_UnSplitCellHorz(int Row, int Col, int Row2, int OldBestHeight);
	void __fastcall Do_BeforeSplitCellVert(int ItemNo, int Row, int Col, int Col2, bool DecreaseWidth);
		
	void __fastcall Do_SplitCellVert(int Row, int Col, int Col2, bool DecreaseWidth);
	void __fastcall Do_UnSplitCellVert(int Row, int Col, int Col2, int OldBestWidth);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeDeleteRows(int ItemNo, int Row, int Count);
	void __fastcall Do_DeleteRows(int ItemNo, int Row, int Count, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnDeleteRows(int Row, Classes::TList* RowList);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeDeleteCols(int ItemNo, int Col, int Count);
	void __fastcall Do_DeleteCols(int ItemNo, int Col, int Count, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnDeleteCols(int Col, Classes::TList* CellList);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeMergeCells(int ItemNo, int Row, int Col, int ColSpan, int 
		RowSpan);
	void __fastcall Do_MergeCells(int ItemNo, int Row, int Col, int ColSpan, int RowSpan, Rvundo::TRVUndoInfo* 
		ui, bool ChangeBestWidth);
	void __fastcall Do_UndoMergeCells(int ItemNo, int Row, int Col, int OldColSpan, int OldRowSpan, Rvclasses::TRVList* 
		MergedItemsList, TRVHTMLLength OldBestWidth);
	void __fastcall Do_BeforeUnmergeCell(int ItemNo, int Row, int Col, bool UnmergeRows, bool UnmergeCols
		);
	void __fastcall Do_UnmergeCell(int ItemNo, int Row, int Col, bool UnmergeRows, bool UnmergeCols);
	void __fastcall Do_UndoUnmergeCell(int ItemNo, int Row, int Col, int OldColSpan, int OldRowSpan, TRVHTMLLength 
		OldBestWidth, int OldBestHeight);
	Rvundo::TRVUndoInfo* __fastcall Do_BeforeClearCells(int ItemNo, Rvclasses::TRVIntegerList* RowList, 
		Rvclasses::TRVIntegerList* ColList, Classes::TList* &CellsList);
	void __fastcall Do_ClearCells(Classes::TList* CellsList, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* 
		ColList, Rvundo::TRVUndoInfo* ui);
	void __fastcall Do_UnClearCells(Classes::TList* CellsList, Rvclasses::TRVIntegerList* RowList, Rvclasses::TRVIntegerList* 
		ColList);
	void __fastcall InsertPointer(int Index, TRVTableRow* Item);
	
public:
	__fastcall TRVTableRows(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData, TRVTableItemInfo* 
		ATable);
	__fastcall virtual ~TRVTableRows(void);
	void __fastcall MergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC, bool 
		ChangeBestWidth);
	bool __fastcall Empty(void);
	HIDESBASE TRVTableRow* __fastcall Add(int nCols);
	TRVTableCellData* __fastcall GetMainCell(int ARow, int ACol, int &MRow, int &MCol);
	HIDESBASE TRVTableRow* __fastcall Insert(int Index, int nCols);
	void __fastcall Reset(int nRows, int nCols);
	bool __fastcall CanMergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC)
		;
	__property TRVTableRow* Items[int Index] = {read=Get, write=Put/*, default*/};
};

class PASCALIMPLEMENTATION TRVTableRow : public Rvdatalist::TRVDataList 
{
	typedef Rvdatalist::TRVDataList inherited;
	
private:
	TRVCellVAlign FVAlign;
	HIDESBASE TRVTableCellData* __fastcall Get(int Index);
	HIDESBASE void __fastcall Put(int Index, const TRVTableCellData* Value);
	void __fastcall InsertEmpty(int Index);
	void __fastcall InsertPointer(int Index, TRVTableCellData* Item);
	
protected:
	TRVTableRows* FRows;
	virtual Crvdata::TCustomRVData* __fastcall GetParentRVData(void);
	bool __fastcall HasCellsInRange(int Index, int RangeStart, int Count);
	
public:
	__fastcall TRVTableRow(int nCols, TRVTableRows* ARows, Crvdata::TCustomRVData* MainRVData);
	HIDESBASE TRVTableCellData* __fastcall Add(void);
	HIDESBASE TRVTableCellData* __fastcall Insert(int Index);
	int __fastcall GetHeight(void);
	int __fastcall GetBestHeight(void);
	__property TRVCellVAlign VAlign = {read=FVAlign, write=FVAlign, default=0};
	__property TRVTableCellData* Items[int Index] = {read=Get, write=Put/*, default*/};
public:
	/* TRVList.Destroy */ __fastcall virtual ~TRVTableRow(void) { }
	
};

struct TRVTableInplaceParamStorage
{
	bool Stored;
	int StartNo;
	int EndNo;
	int StartOffs;
	int EndOffs;
	int Row;
	int Col;
	Rvitem::TCustomRVItemInfo* PartialSelected;
} ;

class DELPHICLASS TRVTableItemFormattingInfo;
class PASCALIMPLEMENTATION TRVTableItemFormattingInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Rvclasses::TRVIntegerList* ColWidths;
	Rvclasses::TRVIntegerList* RowHeights;
	Rvclasses::TRVIntegerList* ColStarts;
	Rvclasses::TRVIntegerList* RowStarts;
	int FWidth;
	int FHeight;
	Rvclasses::TRVList* Rows;
	
public:
	__fastcall TRVTableItemFormattingInfo(bool CreateRows);
	__fastcall virtual ~TRVTableItemFormattingInfo(void);
	void __fastcall Clear(void);
	void __fastcall QuickClear(void);
};

enum TRVCellDirection { rvcdLeft, rvcdUp, rvcdRight, rvcdDown, rvcdDocTop, rvcdDocBottom, rvcdNext, 
	rvcdPrev };

typedef void __fastcall (__closure *TRVTableDrawBorderEvent)(TRVTableItemInfo* Sender, Graphics::TCanvas* 
	Canvas, int Left, int Top, int Right, int Bottom, int Width, Graphics::TColor LightColor, Graphics::TColor 
	Color, Graphics::TColor BackgroundColor, TRVTableBorderStyle Style, bool Printing, Rvstyle::TRVBooleanRect* 
	VisibleBorders, bool &DoDefault);

enum TRVTableState { rvtsInserted, rvtsEditMode, rvtsModified, rvtsFormatInplace, rvtsVerticalDraggedRule, 
	rvtsDRChangeTableWidth, rvtsJustCreated, rvtsInplaceIsReformatting, rvtsSelExists };

typedef Set<TRVTableState, rvtsInserted, rvtsSelExists>  TRVTableStates;

class PASCALIMPLEMENTATION TRVTableItemInfo : public Rvitem::TRVFullLineItemInfo 
{
	typedef Rvitem::TRVFullLineItemInfo inherited;
	
private:
	TRVCellEditingEvent FOnCellEditing;
	TRVTableStates FState;
	int CachedItemNo;
	int MyTop;
	int MyLeft;
	int MyClientTop;
	int MyClientLeft;
	int MouseRow;
	int MouseCol;
	int DRMin;
	int DRMax;
	int DRNo;
	int DRDelta;
	TRVTableRows* FRows;
	int FCellVSpacing;
	int FCellHSpacing;
	int FCellPadding;
	TRVHTMLLength FBestWidth;
	int FBorderWidth;
	Graphics::TColor FBorderColor;
	Graphics::TColor FColor;
	int FCellBorderWidth;
	int FHRuleWidth;
	int FVRuleWidth;
	Graphics::TColor FHRuleColor;
	Graphics::TColor FCellBorderColor;
	Graphics::TColor FVRuleColor;
	TRVTableBorderStyle FBorderStyle;
	TRVTableBorderStyle FCellBorderStyle;
	int FBorderHSpacing;
	int FBorderVSpacing;
	bool FHOutermostRule;
	bool FVOutermostRule;
	Graphics::TColor FCellBorderLightColor;
	Graphics::TColor FBorderLightColor;
	int FSelStartCol;
	int FSelStartRow;
	int FSelColOffs;
	int FSelRowOffs;
	int BusyCount;
	TRVTableOptions FOptions;
	TRVTablePrintOptions FPrintOptions;
	TRVTableInplaceParamStorage FStoredInplace;
	int FMinWidthPlus;
	int FInplaceMinWidthPlus;
	System::AnsiString FTextRowSeparator;
	System::AnsiString FTextColSeparator;
	int FocusedCellRow;
	int FocusedCellCol;
	int ChosenCellRow;
	int ChosenCellCol;
	int StreamSaveStartRow;
	int StreamSaveRowCount;
	TRVTableDrawBorderEvent FOnDrawBorder;
	int FHeadingRowCount;
	TRVTableCellData* __fastcall GetCells(int Row, int Col);
	void __fastcall SetCells(int Row, int Col, const TRVTableCellData* Value);
	void __fastcall SetBestWidth(const TRVHTMLLength Value);
	int __fastcall GetVerticalRuleNo(int X, int &MinX, int &ZeroChangeX);
	int __fastcall GetHorizontalRuleNo(int Y, int &MinY, int &ZeroChangeY);
	int __fastcall GetColNo(int X);
	int __fastcall GetRowNo(int Y);
	int __fastcall GetCrossed(int Coord, Rvclasses::TRVIntegerList* List);
	void __fastcall UpdateCellXCoords(TRVTableItemFormattingInfo* Fmt, bool NoCaching);
	void __fastcall UpdateCellYCoords(TRVTableItemFormattingInfo* Fmt);
	int __fastcall GetHorzExtra(void);
	void __fastcall InplaceEditorChange(Rvedit::TCustomRichViewEdit* Sender, bool ClearRedo);
	void __fastcall InplaceEditorCaretGetout(Rvedit::TCustomRichViewEdit* Sender, Rvedit::TRVGetOutDirection 
		Direction);
	void __fastcall InplaceEditorMouseDown(Richview::TCustomRichView* Sender, Controls::TMouseButton Button
		, Classes::TShiftState Shift, int ItemNo, int X, int Y);
	void __fastcall InplaceEditorMouseUp(Richview::TCustomRichView* Sender, Controls::TMouseButton Button
		, Classes::TShiftState Shift, int ItemNo, int X, int Y);
	void __fastcall InplaceEditorMouseMove(System::TObject* Sender, Classes::TShiftState Shift, int X, 
		int Y);
	void __fastcall InplaceEditorDragOver(System::TObject* Sender, System::TObject* Source, int X, int 
		Y, Controls::TDragState State, bool &Accept);
	void __fastcall InplaceEditorDragDrop(System::TObject* Sender, System::TObject* Source, int X, int 
		Y);
	void __fastcall InplaceEditorControlAction(Richview::TCustomRichView* Sender, Rvstyle::TRVControlAction 
		ControlAction, int ItemNo, Controls::TControl* &ctrl);
	void __fastcall DestroyInplace(bool ReformatCell);
	void __fastcall StoreRVSelection(Crvfdata::TCustomRVFormattedData* RVData, TRVTableInplaceParamStorage 
		&storage);
	void __fastcall RestoreRVSelection(Crvfdata::TCustomRVFormattedData* RVData, const TRVTableInplaceParamStorage 
		&storage);
	void __fastcall Init(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData);
	void __fastcall CellsWriter(Classes::TWriter* Writer);
	void __fastcall CellsReader(Classes::TReader* Reader);
	void __fastcall ClearTemporal(void);
	void __fastcall SetBorderColor(const Graphics::TColor Value);
	void __fastcall SetBorderHSpacing(const int Value);
	void __fastcall SetBorderLightColor(const Graphics::TColor Value);
	void __fastcall SetBorderStyle(const TRVTableBorderStyle Value);
	void __fastcall SetBorderVSpacing(const int Value);
	void __fastcall SetBorderWidth(const int Value);
	void __fastcall SetCellBorderColorProp(const Graphics::TColor Value);
	void __fastcall SetCellBorderLightColorProp(const Graphics::TColor Value);
	void __fastcall SetCellBorderWidth(const int Value);
	void __fastcall SetCellHSpacing(const int Value);
	void __fastcall SetCellPadding(const int Value);
	void __fastcall SetCellVSpacing(const int Value);
	void __fastcall SetColor(const Graphics::TColor Value);
	void __fastcall SetHOutermostRule(const bool Value);
	void __fastcall SetHRuleColor(const Graphics::TColor Value);
	void __fastcall SetHRuleWidth(const int Value);
	void __fastcall SetVOutermostRule(const bool Value);
	void __fastcall SetVRuleColor(const Graphics::TColor Value);
	void __fastcall SetVRuleWidth(const int Value);
	void __fastcall SetCellBorderStyle(const TRVTableBorderStyle Value);
	void __fastcall SetProperty(const System::AnsiString PropertyName, int Value, bool AffectSize, bool 
		AffectWidth);
	void __fastcall SetCellProperty(int ItemNo, const System::AnsiString PropertyName, int Value, int Row
		, int Col, bool AffectSize, bool AffectWidth);
	bool __fastcall IsFixedWidthTable(void);
	bool __fastcall CompletelySelected(void);
	void __fastcall UnAssignActiveCell(void);
	bool __fastcall DoOnCellEditing(int Row, int Col, bool Automatic);
	bool __fastcall IsInEditor(void);
	bool __fastcall CanUseHeadingRowCount(void);
	void __fastcall SetHeadingRowCount(const int Value);
	
protected:
	TRVTableItemFormattingInfo* Fmt;
	Rvstyle::TRVScreenAndDevice *cursad;
	void __fastcall XorDrawing(System::TObject* Sender, Classes::TShiftState Shift, int X, int Y);
	virtual int __fastcall GetHeight(void);
	virtual int __fastcall GetWidth(void);
	void __fastcall DrawBorder(Graphics::TCanvas* Canvas, int Left, int Top, int Right, int Bottom, int 
		Width, Graphics::TColor LightColor, Graphics::TColor Color, Graphics::TColor BackgroundColor, TRVTableBorderStyle 
		Style, bool DrawEvenEmptyBorder, bool Printing, const Windows::TRect &ClipRect, Rvstyle::TRVBooleanRect* 
		VisibleBorders, int r, int c);
	bool __fastcall GetCellAt_(int X, int Y, int &Row, int &Col);
	void __fastcall UpdateCellSel(void);
	void __fastcall PaintTo(int Left, int Right, int Top, int FromRow, int RowCount, Graphics::TCanvas* 
		Canvas, Rvitem::TRVItemDrawStates State, Rvstyle::TRVStyle* Style, TRVTableItemFormattingInfo* Fmt
		, bool UseHeadingRowCount, const Windows::TRect &ClipRect);
	int __fastcall GetDevX(int x);
	int __fastcall GetDevY(int y);
	void __fastcall InternalOnDocWidthChange(int DocWidth, TRVTableItemFormattingInfo* Fmt, Graphics::TCanvas* 
		Canvas, bool NoCaching);
	void __fastcall Change(void);
	void __fastcall ChangeEx(bool ClearRedo);
	int __fastcall BeginModify(int ItemNo);
	void __fastcall EndModify(int ItemNo, int Data);
	Graphics::TColor __fastcall GetCellColor(TRVTableCellData* Cell);
	int __fastcall GetSplitRowBelow(int Row);
	int __fastcall GetSplitRowAbove(int Row);
	bool __fastcall BeforeChange(void);
	bool __fastcall CanChange(void);
	void __fastcall InitUndo(void);
	void __fastcall DoneUndo(void);
	void __fastcall AssignCellAttributes(int ItemNo, int Row, int Col, TRVTableCellData* SourceCell, bool 
		IncludeSize, int DivColSpan, int DivRowSpan);
	void __fastcall SetCellBestWidth_(int ItemNo, TRVHTMLLength Value, int Row, int Col);
	void __fastcall SetCellBestHeight_(int ItemNo, int Value, int Row, int Col);
	void __fastcall SetCellColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVisibleBorders_(int ItemNo, bool Left, bool Top, bool Right, bool Bottom, int 
		Row, int Col);
	void __fastcall SetCellBorderColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBorderLightColor_(int ItemNo, Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVAlign_(int ItemNo, TRVCellVAlign Value, int Row, int Col);
	void __fastcall SetRowVAlign_(int ItemNo, TRVCellVAlign Value, int Row);
	int __fastcall GetEditorItemNoForUndo(void);
	Rvedit::TCustomRichViewEdit* __fastcall CreateTemporalEditor(void);
	void __fastcall ApplyToPartiallySelected(int Operation, int UserData);
	void __fastcall ValidateFocused(void);
	void __fastcall ValidateChosen(void);
	bool __fastcall CellIsChosen(void);
	void __fastcall AdjustFocus(int Row, int Col, Classes::TPersistent* TopLevelRVData, int TopLevelItemNo
		);
	bool __fastcall UndoEnabled(void);
	void __fastcall ChooseSubRVData_(int r, int c);
	void __fastcall EditCell_(int Row, int Col, bool Unquestioning);
	
public:
	bool FMakingSelection;
	Rvedit::TCustomRichViewEdit* FInplaceEditor;
	DYNAMIC int __fastcall GetSoftPageBreakDY(int Data);
	int __fastcall GetMyItemNo(void);
	void __fastcall SaveRowsToStream(Classes::TStream* Stream, int Index, int Count);
	DYNAMIC void __fastcall ResetSubCoords(void);
	DYNAMIC Classes::TPersistent* __fastcall GetSubRVDataAt(int X, int Y);
	bool __fastcall GetCellWhichOwnsControl(Controls::TControl* AControl, int &ARow, int &ACol, int &AItemNo
		);
	DYNAMIC bool __fastcall AdjustFocusToControl(Controls::TControl* Control, Classes::TPersistent* &TopLevelRVData
		, int &TopLevelItemNo);
	virtual void __fastcall Print(Graphics::TCanvas* Canvas, int x, int y, int x2, bool Preview, bool Correction
		, const Rvstyle::TRVScreenAndDevice &sad, Rvscroll::TRVScroller* RichView, Dlines::TRVDrawLineInfo* 
		dli, int Part);
	void __fastcall CreateInplace(int ItemNo, int Row, int Col, bool BuildJumps, bool CaretAtStart, bool 
		CaretAtEnd, bool SetTime, bool Unquestioning);
	void __fastcall SetInplaceBounds(int Left, int Top, int Width, int Height);
	bool __fastcall StartSelecting(int Row, int Col);
	DYNAMIC void __fastcall MovingToUndoList(int ItemNo, System::TObject* RVData, System::TObject* AContainerUndoItem
		);
	DYNAMIC void __fastcall MovingFromUndoList(int ItemNo, System::TObject* RVData);
	DYNAMIC void __fastcall FinalizeUndoGroup(void);
	virtual void __fastcall AdjustInserted(int x, int y, bool adjusty);
	DYNAMIC bool __fastcall OwnsControl(Controls::TControl* AControl);
	DYNAMIC bool __fastcall OwnsInplaceEditor(Controls::TControl* AEditor);
	virtual int __fastcall GetMinWidth(Rvstyle::PRVScreenAndDevice sad, Graphics::TCanvas* Canvas, Classes::TPersistent* 
		RVData);
	virtual void __fastcall PaintFullWidth(int Left, int Right, int Top, Graphics::TCanvas* Canvas, Rvitem::TRVItemDrawStates 
		State, Rvstyle::TRVStyle* Style, const Windows::TRect &ClipRect, Dlines::TRVDrawLineInfo* dli);
	virtual void __fastcall OnDocWidthChange(int DocWidth, Dlines::TRVDrawLineInfo* dli, bool Printing, 
		Graphics::TCanvas* Canvas, Classes::TPersistent* RVData, Rvstyle::PRVScreenAndDevice sad, int &HShift
		, bool NoCaching);
	DYNAMIC bool __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y, int ItemNo, System::TObject* 
		RVData);
	DYNAMIC bool __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y, int ItemNo, System::TObject* RVData);
	DYNAMIC bool __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y, int ItemNo, System::TObject* RVData);
	DYNAMIC void __fastcall DeselectPartial(void);
	void __fastcall MergeInplaceUndo(bool DestroyLists);
	void __fastcall InplaceDeleted(bool Clearing);
	DYNAMIC bool __fastcall PartiallySelected(void);
	DYNAMIC bool __fastcall CanDeletePartiallySelected(void);
	DYNAMIC void __fastcall DeletePartiallySelected(void);
	virtual bool __fastcall GetBoolValue(Rvitem::TRVItemBoolProperty Prop);
	virtual bool __fastcall GetBoolValueEx(Rvitem::TRVItemBoolPropertyEx Prop, Rvstyle::TRVStyle* RVStyle
		);
	DYNAMIC void __fastcall SaveRVF(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, 
		int ParaNo, const System::AnsiString Name, Rvitem::TRVMultiDrawItemPart* Part, bool ForceSameAsPrev
		);
	DYNAMIC bool __fastcall ReadRVFLine(const System::AnsiString s, Classes::TPersistent* RVData, int ReadType
		, int LineNo, int LineCount, System::AnsiString &Name, Rvitem::TRVFReadMode &ReadMode, Rvitem::TRVFReadState 
		&ReadState);
	DYNAMIC void __fastcall BeforeLoading(Rvstyle::TRVLoadFormat FileFormat);
	DYNAMIC void __fastcall AfterLoading(Rvstyle::TRVLoadFormat FileFormat);
	virtual Dlines::TRVDrawLineInfo* __fastcall CreatePrintingDrawItem(System::TObject* RVData, const Rvstyle::TRVScreenAndDevice 
		&sad);
	void __fastcall SaveInplace(void);
	void __fastcall RestoreInplace(void);
	DYNAMIC void __fastcall StartExport(void);
	DYNAMIC void __fastcall EndExport(void);
	DYNAMIC void __fastcall MarkStylesInUse(Rvclasses::TRVIntegerList* UsedTextStyles, Rvclasses::TRVIntegerList* 
		UsedParaStyles, Rvclasses::TRVIntegerList* UsedListStyles);
	DYNAMIC void __fastcall UpdateStyles(Rvclasses::TRVIntegerList* TextStylesShift, Rvclasses::TRVIntegerList* 
		ParaStylesShift, Rvclasses::TRVIntegerList* ListStylesShift);
	virtual void __fastcall Inserting(System::TObject* RVData, System::AnsiString &Text, bool Safe);
	virtual void __fastcall Inserted(System::TObject* RVData, int ItemNo);
	DYNAMIC void __fastcall BeforeUndoChangeProperty(void);
	DYNAMIC void __fastcall AfterUndoChangeProperty(void);
	DYNAMIC void __fastcall ApplyParaStyleToPartiallySelected(int ParaNo);
	DYNAMIC void __fastcall ApplyParaStyleConversionToPartiallySelected(int UserData);
	DYNAMIC void __fastcall ApplyStyleConversionToPartiallySelected(int UserData);
	bool __fastcall GetCellTo(int Row, int Col, TRVCellDirection Dir, int &NewRow, int &NewCol, bool Quiet
		);
	DYNAMIC void __fastcall SaveRTF(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo, 
		const System::AnsiString Name, double TwipsPerPixel, int Level, Rvclasses::TRVColorList* ColorList
		, Rvclasses::TRVIntegerList* StyleToFont, Rvclasses::TRVIntegerList* ListOverrideOffsetsList1, Rvclasses::TRVIntegerList* 
		ListOverrideOffsetsList2, Rvclasses::TRVList* FontTable);
	DYNAMIC void __fastcall FillRTFTables(Rvclasses::TRVColorList* ColorList, Rvclasses::TRVIntegerList* 
		ListOverrideCountList, Classes::TPersistent* RVData);
	DYNAMIC System::AnsiString __fastcall AsText(int LineWidth, Classes::TPersistent* RVData, const System::AnsiString 
		Text, const System::AnsiString Path, bool TextOnly, bool Unicode);
	DYNAMIC void __fastcall SaveToHTML(Classes::TStream* Stream, Classes::TPersistent* RVData, int ItemNo
		, const System::AnsiString Text, const System::AnsiString Path, const System::AnsiString imgSavePrefix
		, int &imgSaveNo, Graphics::TColor CurrentFileColor, Rvstyle::TRVSaveOptions SaveOptions, bool UseCSS
		, Rvclasses::TRVList* Bullets);
	DYNAMIC bool __fastcall EnterItem(Rvitem::TRVEnterDirection From, int Coord);
	DYNAMIC void __fastcall BuildJumps(int Left, int Top, int &StartJumpNo, Classes::TList* jumps);
	DYNAMIC Classes::TPersistent* __fastcall GetSubRVData(Rvitem::TRVStoreSubRVData* &StoreState, Rvitem::TRVSubRVDataPos 
		Position);
	DYNAMIC void __fastcall ChooseSubRVData(Rvitem::TRVStoreSubRVData* StoreState);
	DYNAMIC void __fastcall CleanUpChosen(void);
	__fastcall virtual TRVTableItemInfo(Classes::TPersistent* RVData);
	__fastcall TRVTableItemInfo(int nRows, int nCols, Crvdata::TCustomRVData* AMainRVData);
	__fastcall virtual ~TRVTableItemInfo(void);
	void __fastcall UnmergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool UnmergeRows, bool 
		UnmergeCols);
	bool __fastcall CanMergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC)
		;
	void __fastcall MergeCells(int TopRow, int LeftCol, int ColSpan, int RowSpan, bool AllowMergeRC);
	void __fastcall MergeSelectedCells(bool AllowMergeRC);
	bool __fastcall CanMergeSelectedCells(bool AllowMergeRC);
	void __fastcall UnmergeSelectedCells(bool UnmergeRows, bool UnmergeCols);
	void __fastcall SplitSelectedCellsVertically(int ColCount);
	void __fastcall SplitSelectedCellsHorizontally(int RowCount);
	bool __fastcall IsCellSelected(int Row, int Col);
	void __fastcall InsertRows(int Index, int Count, int CopyIndex);
	void __fastcall InsertCols(int Index, int Count, int CopyIndex);
	void __fastcall InsertColsLeft(int Count);
	void __fastcall InsertColsRight(int Count);
	void __fastcall InsertRowsAbove(int Count);
	void __fastcall InsertRowsBelow(int Count);
	void __fastcall DeleteRows(int Index, int Count, bool DecreaseHeight);
	void __fastcall DeleteCols(int Index, int Count, bool DecreaseWidth);
	void __fastcall DeleteSelectedRows(void);
	void __fastcall DeleteSelectedCols(void);
	void __fastcall DeleteEmptyRows(void);
	void __fastcall DeleteEmptyCols(void);
	bool __fastcall GetCellAt(int X, int Y, int &Row, int &Col);
	void __fastcall Select(int StartRow, int StartCol, int RowOffs, int ColOffs);
	void __fastcall Deselect(void);
	void __fastcall SelectRows(int StartRow, int Count);
	void __fastcall SelectCols(int StartCol, int Count);
	bool __fastcall GetSelectionBounds(int &StartRow, int &StartCol, int &RowOffs, int &ColOffs);
	bool __fastcall GetNormalizedSelectionBounds(bool IncludeEditedCell, int &TopRow, int &LeftCol, int 
		&ColSpan, int &RowSpan);
	Rvedit::TCustomRichViewEdit* __fastcall GetEditedCell(int &Row, int &Col);
	void __fastcall SaveToStream(Classes::TStream* Stream);
	void __fastcall LoadFromStream(Classes::TStream* Stream);
	void __fastcall EditCell(int Row, int Col);
	void __fastcall Changed(void);
	__property TRVTableRows* Rows = {read=FRows};
	__property TRVTableCellData* Cells[int Row][int Col] = {read=GetCells, write=SetCells};
	void __fastcall SetCellBestWidth(TRVHTMLLength Value, int Row, int Col);
	void __fastcall SetCellBestHeight(int Value, int Row, int Col);
	void __fastcall SetCellColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVisibleBorders(bool Left, bool Top, bool Right, bool Bottom, int Row, int Col
		);
	void __fastcall SetCellBorderColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellBorderLightColor(Graphics::TColor Value, int Row, int Col);
	void __fastcall SetCellVAlign(TRVCellVAlign Value, int Row, int Col);
	void __fastcall SetRowVAlign(TRVCellVAlign Value, int Row);
	DYNAMIC bool __fastcall MoveFocus(bool GoForward, Classes::TPersistent* &TopLevelRVData, int &TopLevelItemNo
		);
	DYNAMIC void __fastcall ClearFocus(void);
	void __fastcall GetCellPosition(TRVTableCellData* Cell, int &Row, int &Col);
	
__published:
	__property TRVTableOptions Options = {read=FOptions, write=FOptions, default=31};
	__property TRVTablePrintOptions PrintOptions = {read=FPrintOptions, write=FPrintOptions, default=3}
		;
	__property TRVHTMLLength BestWidth = {read=FBestWidth, write=SetBestWidth, default=0};
	__property Graphics::TColor Color = {read=FColor, write=SetColor, default=-2147483643};
	__property int HeadingRowCount = {read=FHeadingRowCount, write=SetHeadingRowCount, default=0};
	__property System::AnsiString TextRowSeparator = {read=FTextRowSeparator, write=FTextRowSeparator};
		
	__property System::AnsiString TextColSeparator = {read=FTextColSeparator, write=FTextColSeparator};
		
	__property int BorderWidth = {read=FBorderWidth, write=SetBorderWidth, default=0};
	__property Graphics::TColor BorderColor = {read=FBorderColor, write=SetBorderColor, default=-2147483640
		};
	__property Graphics::TColor BorderLightColor = {read=FBorderLightColor, write=SetBorderLightColor, 
		default=-2147483628};
	__property TRVTableBorderStyle BorderStyle = {read=FBorderStyle, write=SetBorderStyle, default=0};
	__property int BorderVSpacing = {read=FBorderVSpacing, write=SetBorderVSpacing, default=2};
	__property int BorderHSpacing = {read=FBorderHSpacing, write=SetBorderHSpacing, default=2};
	__property int CellBorderWidth = {read=FCellBorderWidth, write=SetCellBorderWidth, default=0};
	__property Graphics::TColor CellBorderColor = {read=FCellBorderColor, write=SetCellBorderColorProp, 
		default=-2147483640};
	__property Graphics::TColor CellBorderLightColor = {read=FCellBorderLightColor, write=SetCellBorderLightColorProp
		, default=-2147483628};
	__property int CellPadding = {read=FCellPadding, write=SetCellPadding, default=1};
	__property TRVTableBorderStyle CellBorderStyle = {read=FCellBorderStyle, write=SetCellBorderStyle, 
		default=1};
	__property int VRuleWidth = {read=FVRuleWidth, write=SetVRuleWidth, default=0};
	__property Graphics::TColor VRuleColor = {read=FVRuleColor, write=SetVRuleColor, default=-2147483640
		};
	__property int HRuleWidth = {read=FHRuleWidth, write=SetHRuleWidth, default=0};
	__property Graphics::TColor HRuleColor = {read=FHRuleColor, write=SetHRuleColor, default=-2147483640
		};
	__property int CellVSpacing = {read=FCellVSpacing, write=SetCellVSpacing, default=2};
	__property int CellHSpacing = {read=FCellHSpacing, write=SetCellHSpacing, default=2};
	__property bool VOutermostRule = {read=FVOutermostRule, write=SetVOutermostRule, default=0};
	__property bool HOutermostRule = {read=FHOutermostRule, write=SetHOutermostRule, default=0};
	__property TRVCellEditingEvent OnCellEditing = {read=FOnCellEditing, write=FOnCellEditing};
	__property TRVTableDrawBorderEvent OnDrawBorder = {read=FOnDrawBorder, write=FOnDrawBorder};
};

class DELPHICLASS TRVTableStoreSubRVData;
class PASCALIMPLEMENTATION TRVTableStoreSubRVData : public Rvitem::TRVStoreSubRVData 
{
	typedef Rvitem::TRVStoreSubRVData inherited;
	
public:
	int Row;
	int Col;
	__fastcall TRVTableStoreSubRVData(int ARow, int ACol);
	DYNAMIC Rvitem::TRVStoreSubRVData* __fastcall Duplicate(void);
public:
	/* TObject.Destroy */ __fastcall virtual ~TRVTableStoreSubRVData(void) { }
	
};

class DELPHICLASS ERVTableInplaceError;
class PASCALIMPLEMENTATION ERVTableInplaceError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall ERVTableInplaceError(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall ERVTableInplaceError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall ERVTableInplaceError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall ERVTableInplaceError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall ERVTableInplaceError(const System::AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall ERVTableInplaceError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall ERVTableInplaceError(int Ident, int AHelpContext) : Sysutils::
		Exception(Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall ERVTableInplaceError(int Ident, const System::TVarRec * 
		Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~ERVTableInplaceError(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define rvsTable (Shortint)(-60)
#define crRVSelectRow (Byte)(104)
#define crRVSelectCol (Byte)(105)
#define RVTABLEDEFAULTOPTIONS (System::Set<TRVTableOption, rvtoEditing, rvtoCellBelowBorders> () << rvtoEditing \
	<< rvtoRowSizing << rvtoColSizing << rvtoRowSelect << rvtoColSelect )
#define RVTABLEDEFAULTPRINTOPTIONS (System::Set<TRVTablePrintOption, rvtoHalftoneBorders, rvtoWhiteBackground> () \
	<< rvtoHalftoneBorders << rvtoRowsSplit )
extern PACKAGE TPenStyle RichViewTableGridStyle;

}	/* namespace Rvtable */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Rvtable;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// RVTable
