{==============================================================================}
{ Example of new item type for RichView:                                       }
{ - TRVBlendBitmapItemInfo                                                     }
{   (semi-transparent image)                                                   }
{ - TRVHotBlendBitmapItemInfo                                                  }
{   (semi-transparent image - hypertext link)                                  }
{------------------------------------------------------------------------------}
{ (c) 2001 by Sergey Tkachenko (svt@trichview.com)                             }
{ http://www.trichview.com                                                     }
{ http://www.richedit.com                                                      }
{==============================================================================}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, RVStyle, RVScroll, RichView, RVBlendBitmap, StdCtrls, ShellApi;

type
  TForm1 = class(TForm)
    RichView1: TRichView;
    RVStyle1: TRVStyle;
    Image1: TImage;
    Image2: TImage;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure RichView1Jump(Sender: TObject; id: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var bmp: TBitmap;
    item: TRVHotBlendBitmapItemInfo;
    i: Integer;
begin
 // Note: not very fast drawing, so do not use for large images
 // Note: you can save RVF documents with semitransparent images
 //       (RVF reader must have RVBlendBMP.pas unit in order to
 //       load such files)

 RichView1.AddBreak;
 RichView1.AddNL('Example of Semi-transparent Image',1,1);
 RichView1.AddBreak;

 for i := 0 to 10 do
    RichView1.AddNL('some text',0,0);

  bmp := TBitmap.Create;
  bmp.Assign(Image1.Picture.Bitmap);
  item := TRVHotBlendBitmapItemInfo.CreateEx(RichView1.RVData, bmp, rvvaBaseline);
  item.Transparency := 100;
  item.HotTransparency := 0;
  // 0 - no transparency,
  // 255 - fully transparent (invisible)

  item.ParaNo := 1;
  RichView1.AddItem('', item);
  RichView1.AddNL('games at www.sapphiregames.com',4,1);

  for i := 0 to 10 do
    RichView1.AddNL('some text',0,0);

  bmp := TBitmap.Create;
  bmp.Assign(Image2.Picture.Bitmap);
  item := TRVHotBlendBitmapItemInfo.CreateEx(RichView1.RVData, bmp, rvvaBaseline);
  item.Transparency := 200;
  item.HotTransparency := 100;
  item.ParaNo := 1;
  RichView1.AddItem('', item);
  RichView1.AddNL('games at www.sapphiregames.com',4,1);

  for i := 0 to 10 do
    RichView1.AddNL('some text',0,0);

  RichView1.Format;
end;

procedure TForm1.RichView1Jump(Sender: TObject; id: Integer);
begin
  ShellExecute(0, 'open', 'http://www.sapphiregames.com', nil, nil, SW_SHOW)
end;

end.
