unit ChartItem;

interface

uses Windows, Classes, Graphics, RVFuncs, RVScroll, DLines, RVItem, Chart, RVStyle;

const
  rvsChart = -1001;

type

  TRVChartItemInfo = class (TRVControlItemInfo)
    public
      constructor Create(RVData: TPersistent); override;
      constructor CreateEx(RVData: TPersistent; AChart: TChart; AVAlign: TRVVAlign);
      function GetBoolValueEx(Prop: TRVItemBoolPropertyEx; RVStyle: TRVStyle): Boolean; override;
      procedure Print(Canvas: TCanvas; x,y,x2: Integer; Preview, Correction: Boolean;
                      const sad: TRVScreenAndDevice; RichView: TRVScroller;
                      dli: TRVDrawLineInfo;
                      Part: Integer); override;
  end;

implementation

{============================ TRVChartItemInfo ================================}
constructor TRVChartItemInfo.Create(RVData: TPersistent);
begin
  inherited Create(RVData);
  StyleNo := rvsChart;
end;

constructor TRVChartItemInfo.CreateEx(RVData: TPersistent; AChart: TChart; AVAlign: TRVVAlign);
begin
  inherited CreateEx(RVData, AChart, AVAlign);
  StyleNo := rvsChart;
end;

function TRVChartItemInfo.GetBoolValueEx(Prop: TRVItemBoolPropertyEx; RVStyle: TRVStyle): Boolean;
begin
  case Prop of
    rvbpPrintToBMP:
      Result := False;
    else
      Result := inherited GetBoolValueEx(Prop, RVStyle);
  end;
end;

procedure TRVChartItemInfo.Print(Canvas: TCanvas; x, y, x2: Integer;
  Preview, Correction: Boolean; const sad: TRVScreenAndDevice;
  RichView: TRVScroller; dli: TRVDrawLineInfo; Part: Integer);
var sv: Integer;
    bmp: TBitmap;
begin
   if Preview then begin
     bmp := TBitmap.Create;
     bmp.Width := Control.Width;
     bmp.Height := Control.Height;
     TChart(Control).Draw(bmp.Canvas, Rect(0,0, Control.Width,Control.Height));
     Canvas.StretchDraw(Bounds(x,y,dli.Width,dli.Height),bmp);
     bmp.Free;
     end
   else begin
     sv := SaveDC(Canvas.Handle);
     TChart(Control).PrintPartial(Bounds(x,y,dli.Width,dli.Height));
     RestoreDC(Canvas.Handle, sv);
   end;
end;

initialization
   RegisterRichViewItemClass(rvsChart, TRVChartItemInfo);

end.
