{==============================================================================}
{ Example: two ways of drawing RichView document onto Canvas                   }
{==============================================================================}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, RVScroll, RichView, RVStyle, ComCtrls,
  PtblRV, RVReport;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    RVStyle1: TRVStyle;
    RichView1: TRichView;
    Image1: TImage;
    Button1: TButton;
    Image2: TImage;
    Button2: TButton;
    RVReportHelper1: TRVReportHelper;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var i: Integer;
begin
  // For Example 1
  RichView1.AddNL('This is a line of text',1,1);
  for i := 1 to 20 do
    RichView1.AddNL('This is a line of text',0,0);
  RichView1.Format;

  // For Example 2
  RVReportHelper1.RichView.Style := RVStyle1;
  RVReportHelper1.RichView.AddNL('This is a line of text',1,1);
  for i := 1 to 20 do
    RVReportHelper1.RichView.AddNL('This is a line of text',0,0);
end;

const VERYLARGEVALUE = $FFFFFFF;

// Example 1
procedure TForm1.Button1Click(Sender: TObject);
var wmf: TMetafile;
    Canvas: TMetafileCanvas;
    Width, Height: Integer;
begin
  RichView1.HScrollPos := 0;
  RichView1.VScrollPos := 0;
  RichView1.Deselect;
  RichView1.Invalidate;
  Width := RichView1.RVData.DocumentWidth+RichView1.LeftMargin+RichView1.RightMargin;
  Height := RichView1.RVData.DocumentHeight;

  wmf := TMetafile.Create;
  wmf.Width := Width;
  wmf.Height := Height;

  Canvas := TMetafileCanvas.Create(wmf, 0);
  Canvas.Brush.Color := clWindow;
  Canvas.FillRect(Rect(0,0,Width,Height));
  RichView1.RVData.PaintTo(Canvas, Rect(0,0,VERYLARGEVALUE,VERYLARGEVALUE));
  Canvas.Free;

  Image1.Picture.Graphic := wmf;
  wmf.Free;
end;

// Example 2

procedure TForm1.Button2Click(Sender: TObject);
var wmf: TMetafile;
    Canvas: TMetafileCanvas;
const Width = 200;
begin
  RVReportHelper1.Init(Self.Canvas, Width);
  while RVReportHelper1.FormatNextPage(VERYLARGEVALUE) do;

  wmf := TMetafile.Create;
  wmf.Width := Width;
  wmf.Height := RVReportHelper1.EndAt;

  Canvas := TMetafileCanvas.Create(wmf, 0);
  RVReportHelper1.DrawPage(1,Canvas,True,RVReportHelper1.EndAt);
  Canvas.Free;

  Image2.Picture.Graphic := wmf;
  wmf.Free;
end;

end.
