// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'abSecurity.pas' rev: 5.00

#ifndef abSecurityHPP
#define abSecurityHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Dialogs.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Absecurity
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS EabSecurityException;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION EabSecurityException : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall EabSecurityException(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall EabSecurityException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall EabSecurityException(int Ident)/* overload */ : Sysutils::Exception(
		Ident) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall EabSecurityException(int Ident, const System::TVarRec 
		* Args, const int Args_Size)/* overload */ : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall EabSecurityException(const AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall EabSecurityException(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall EabSecurityException(int Ident, int AHelpContext)/* overload */
		 : Sysutils::Exception(Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall EabSecurityException(System::PResStringRec ResStringRec
		, const System::TVarRec * Args, const int Args_Size, int AHelpContext)/* overload */ : Sysutils::Exception(
		ResStringRec, Args, Args_Size, AHelpContext) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~EabSecurityException(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TabSecurityOptions { soForceBuildSecurityFromClients, soForceIDFromClients, soForceClientsVisibleAfterLogon, 
	soAutoSaveUsers, soShowCheckedOKOnly, soAutoLogon, soReleaseOwnerOnLogonFail, soCreateSupervisorIfMissing, 
	soShowIcons, soStorePassword, soSilentLogonTry };
#pragma option pop

typedef Set<TabSecurityOptions, soForceBuildSecurityFromClients, soSilentLogonTry>  TabSecurityOptionSet
	;

#pragma option push -b-
enum TabSecurityError { seNone, seUserTemplateMissing, seSecurityTemplateMissing, seSecurityTemplateCannotBuildFromClients, 
	seUsrAccessInitEntryMissing, seUsrAccessUserEntryMissing, seUsrAccessRightEntryMissing, eUsrAccessLoginNameEntryMissing, 
	seUsrAccessLoginNameEntryMissing, seUsrAccessInitFailed };
#pragma option pop

#pragma option push -b-
enum TNodeType { ntNone, ntPassword, ntUserLeave, ntIntermediate, ntUserRegular, ntSupervisor, ntSupervisorLeave 
	};
#pragma option pop

#pragma pack(push, 1)
struct TVersion
{
	int Major;
	int Minor;
	int MinorMinor;
	char Patch;
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct TAdditionalInfo
{
	int iItemIndex;
	int iImageIndex;
	System::SmallString<40>  sOwner;
	char Reserved[80];
} ;
#pragma pack(pop)

#pragma pack(push, 1)
struct TNodeData
{
	int iId;
	System::SmallString<40>  sCaption;
	bool bCheckOK;
	TAdditionalInfo AdditionalInfo;
} ;
#pragma pack(pop)

typedef TNodeData *PNodeData;

class DELPHICLASS TabSecurityTemplate;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TabSecurityTemplate : public Comctrls::TTreeView 
{
	typedef Comctrls::TTreeView inherited;
	
__published:
	AnsiString __fastcall GetPasswordFromUserTreeNode(Comctrls::TTreeNode* tnUser);
	AnsiString __fastcall GetUserPassword(AnsiString sUserName);
	void __fastcall AddUserToUserTemplate(TabSecurityTemplate* tvSourceTemplate, AnsiString sUserName, 
		AnsiString sPassword, bool bGrantAll);
	void __fastcall BuildASecurityUser(Comctrls::TTreeNode* tnDest, Comctrls::TTreeNode* tnSource, bool 
		bGrantAll);
	Comctrls::TTreeNode* __fastcall GetUserNodeByUserName(AnsiString sUserName);
	Comctrls::TTreeNode* __fastcall GetUserNodeForSelected(void);
	Comctrls::TTreeNode* __fastcall GetUserNodeForNode(Comctrls::TTreeNode* tn);
	void __fastcall DeleteNode(Comctrls::TTreeNode* tnUserNode);
	TNodeType __fastcall GetSelectedNodeType(AnsiString &sUser, AnsiString &sPassword);
	TNodeType __fastcall GetNodeType(Comctrls::TTreeNode* tn, AnsiString &sUser, AnsiString &sPassword)
		;
	TNodeType __fastcall GetNodeTypeSecurityTemplate(Comctrls::TTreeNode* tn);
	void __fastcall ClearTemplate(void);
	void __fastcall LoadFromStreamSecurity(Classes::TStream* Stream);
	void __fastcall SaveToStreamSecurity(Classes::TStream* Stream);
	int __fastcall GenerateSecurityId(void);
	bool __fastcall IsValidSecurityId(int iID);
	__fastcall virtual ~TabSecurityTemplate(void);
public:
	#pragma option push -w-inl
	/* TCustomTreeView.Create */ inline __fastcall virtual TabSecurityTemplate(Classes::TComponent* AOwner
		) : Comctrls::TTreeView(AOwner) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TabSecurityTemplate(HWND ParentWindow) : Comctrls::TTreeView(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

class DELPHICLASS TabSecurityDialogs;
class DELPHICLASS TabSecurity;
#pragma pack(push, 1)
class PASCALIMPLEMENTATION TabSecurity : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	unsigned fhFileMap;
	AnsiString fsCurrentUser;
	bool fbIsSupervisor;
	Classes::TList* flClientList;
	bool fbUserBlobChanged;
	bool fbLoggedOn;
	TabSecurityError FLastError;
	TabSecurityOptionSet fSecurityOptions;
	AnsiString fsUserTemplateRegistryKeyName;
	Controls::TImageList* fImglActions;
	Forms::TForm* ffrSecurityTemplate;
	TabSecurityTemplate* ftvUserTemplate;
	TabSecurityTemplate* ftvSecurityTemplate;
	void __fastcall NotifyClientsForBeingDestroyed(void);
	void __fastcall ForceClientsVisible(void);
	bool __fastcall ReadUserTemplateFromRegistry(AnsiString &sPasswordCripted);
	bool __fastcall WriteUserTemplateIntoRegistry(AnsiString sPasswordCripted);
	AnsiString __fastcall GetCurrentUser(void);
	bool __fastcall OnlyInstance(void);
	void __fastcall SetOptions(TabSecurityOptionSet SecurityOptionSet);
	void __fastcall AddInLastUser(AnsiString sUserName);
	
protected:
	virtual void __fastcall Loaded(void);
	
public:
	Classes::TStringList* flstLastUser;
	TabSecurityDialogs* fSecurityDialogs;
	__fastcall virtual TabSecurity(Classes::TComponent* AOwner);
	__fastcall virtual ~TabSecurity(void);
	bool __fastcall Logon(AnsiString sUserName, AnsiString sPassword, bool bTrySilent);
	void __fastcall ShowPrivileges(void);
	bool __fastcall CheckId(int ID);
	void __fastcall AddClientObject(System::TObject* Client);
	void __fastcall RemoveClientObject(System::TObject* Client);
	bool __fastcall DoBuildSecurityTemplateFromClients(TabSecurityTemplate* ftvSecurityTemplate, Controls::TImageList* 
		fimglActions);
	virtual void __fastcall DefineProperties(Classes::TFiler* Filer);
	void __fastcall StoreTreeProperty(Classes::TStream* Stream);
	void __fastcall LoadTreeProperty(Classes::TStream* Stream);
	void __fastcall StoreImageProperty(Classes::TStream* Stream);
	void __fastcall LoadImageProperty(Classes::TStream* Stream);
	__property Controls::TImageList* Images = {read=fImglActions};
	__property TabSecurityTemplate* UserTemplate = {read=ftvUserTemplate, write=ftvUserTemplate};
	__property TabSecurityTemplate* SecurityTemplate = {read=ftvSecurityTemplate, write=ftvSecurityTemplate
		};
	
__published:
	__property AnsiString UserTemplateRegistryKeyName = {read=fsUserTemplateRegistryKeyName, write=fsUserTemplateRegistryKeyName
		};
	__property AnsiString CurrentUser = {read=GetCurrentUser};
	__property bool IsSupervisor = {read=fbIsSupervisor, nodefault};
	__property TabSecurityError LastError = {read=FLastError, nodefault};
	__property TabSecurityOptionSet Options = {read=fSecurityOptions, write=SetOptions, nodefault};
};

#pragma pack(pop)

#pragma pack(push, 1)
class PASCALIMPLEMENTATION TabSecurityDialogs : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TabSecurity* fSecurity;
	void __fastcall SetSecurityObject(TabSecurity* SecurityObject);
	
public:
	TabSecurityTemplate* ftvUserTemplate;
	TabSecurityTemplate* ftvSecurityTemplate;
	__fastcall TabSecurityDialogs(void);
	__fastcall virtual ~TabSecurityDialogs(void);
	bool __fastcall Init(AnsiString &sLogonName, AnsiString &sPassword, bool bTrySilentInit, bool bRestrictToCheckOK
		);
	
__published:
	__property TabSecurity* SecurityObject = {read=fSecurity, write=SetSecurityObject};
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
#define C_SUPERVISOR_NAME "Supervisor"
#define C_DEFAULT_USER_TEMPLATE_REGISTRY_KEY_NAME "\\Software\\AbEclecticVision\\AbEclecticSecurity\\CurrentVersion\\SecurityObject\\UserTemplate"
#define C_YES " (Yes)"
#define C_NO " (No)"
static const Shortint C_LAST_USER_COUNT = 0x5;
extern PACKAGE System::ResourceString _rsAutoLogonFail;
#define Absecurity_rsAutoLogonFail System::LoadResourceString(&Absecurity::_rsAutoLogonFail)
extern PACKAGE System::ResourceString _rsOnlyOneInstanceFail;
#define Absecurity_rsOnlyOneInstanceFail System::LoadResourceString(&Absecurity::_rsOnlyOneInstanceFail)
	
extern PACKAGE System::ResourceString _rsVersionMismatch;
#define Absecurity_rsVersionMismatch System::LoadResourceString(&Absecurity::_rsVersionMismatch)
extern PACKAGE TVersion C_VERSION;
extern PACKAGE void __fastcall Register(void);
extern PACKAGE AnsiString __fastcall GetStringItem(AnsiString Expression, int Count, char Separator)
	;
extern PACKAGE void __fastcall CopyEntireUserTemplate(TabSecurityTemplate* tvSource, TabSecurityTemplate* 
	tvDest);

}	/* namespace Absecurity */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Absecurity;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// abSecurity
