unit Trexdm04;

{
$Log:   W:/users/prodigy/prodig~1/archive/trex/trexdm03.pav  $
 * 
 *    Rev 1.0   07 Apr 1996 18:30:52   PaulK
 * Work in progress on demos
}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, T_Rex, ExtCtrls;

type
  TForm1 = class(TForm)
    Edit3: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    Button1: TButton;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormDeactivate(Sender: TObject);
  private
    { Private declarations }
    re: TRegExp;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);

var
  s: string;

{This shows the way to use TRegExp.Subst when the search pattern is
 known at design time. The finite state recognizer (FSR) is constructed
 once (in FormActivate) and destroyed once (in FormDeactivate). Do this
 because compiling a FSR is slow, but using one via Subst() is fast.}

begin
s := Memo1.Text;
re.Subst(s,Edit3.Text,maxint);
Memo1.Text := s;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
re := TRegExp.Create(#13#10'?| +');
{
 This regular expression says "Look for a carriage return (#13)
 followed by a linefeed (#10) [but the linefeed is optional (?)];
 alternatively (|) look for a space ( ) occurring one or more times (+)."
}
end;

procedure TForm1.FormDeactivate(Sender: TObject);

begin
re.Free;
end;

end.
