/*
 * Decompiled with CFR 0.152.
 */
import com.borland.jbcl.layout.XYConstraints;
import com.borland.jbcl.layout.XYLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import karl.io.DirectoryNode;
import karl.swing.GuiThreadGroup;
import karl.swing.TriggerTimer;

public class jDiskUsage
extends JFrame
implements DirectoryNode.EventListener {
    private int _displayColumns = 4;
    private int _displayMask = 4;
    private int _secondDisplayMask = -1;
    private DirectoryNode _base = null;
    private DirectoryNode _cache = null;
    private boolean _loadCanceled = false;
    private int _progressNumDirs = 0;
    TriggerTimer statusBarUpdate = new TriggerTimer(400, null);
    TriggerTimer popupDissapear = new TriggerTimer(200, null);
    JPanel contentPane;
    JLabel statusBar = new JLabel();
    String statusBarText = " ";
    JPanel fileSizePane = new JPanel();
    XYLayout xYLayout1 = new XYLayout();
    JPanel filePanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButton1 = new JButton();
    JTextField fileField = new JTextField();
    JButton browseButton = new JButton();
    JButton cancelButton = new JButton();
    JPopupMenu popupMenu = new JPopupMenu();
    JCheckBoxMenuItem showHiddenCheckItem = new JCheckBoxMenuItem();
    JCheckBoxMenuItem showFilesCheckItem = new JCheckBoxMenuItem();
    JMenuItem aboutItem = new JMenuItem();
    JMenuItem exitItem = new JMenuItem();

    public jDiskUsage() throws Exception {
        this.enableEvents(64L);
        this.jbInit();
        this.statusBarUpdate.start();
        this.popupDissapear.setDeadtime(200);
        this.popupDissapear.start();
        this.validate();
        ((Component)this).setVisible(true);
    }

    private void jbInit() throws Exception {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(this.gridBagLayout1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle("Java Disk Usage");
        this.statusBar.setBorder(BorderFactory.createEtchedBorder());
        this.statusBar.setText(this.statusBarText);
        this.fileSizePane.setLayout(this.xYLayout1);
        this.filePanel.setLayout(this.borderLayout2);
        this.fileSizePane.setBackground(Color.gray);
        this.fileSizePane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.fileSizePane.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                jDiskUsage.this.fileSizePane_mouseReleased(e);
            }
        });
        this.fileSizePane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                jDiskUsage.this.fileSizePane_componentResized(e);
            }
        });
        this.jButton1.setBorder(BorderFactory.createLineBorder(Color.black));
        this.jButton1.setRequestFocusEnabled(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setText("jButton1");
        this.statusBarUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.statusBarUpdate_actionPerformed(e);
            }
        });
        this.fileField.setVerifyInputWhenFocusTarget(false);
        this.fileField.setEditable(false);
        this.fileField.setText("browse for a directory ---->");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.browseButton_actionPerformed(e);
            }
        });
        this.browseButton.setMaximumSize(new Dimension(82, 27));
        this.browseButton.setMinimumSize(new Dimension(82, 21));
        this.browseButton.setPreferredSize(new Dimension(75, 21));
        this.browseButton.setText("browse");
        this.cancelButton.setEnabled(false);
        this.cancelButton.setMinimumSize(new Dimension(71, 21));
        this.cancelButton.setPreferredSize(new Dimension(71, 21));
        this.cancelButton.setText("cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.cancelButton_actionPerformed(e);
            }
        });
        this.showHiddenCheckItem.setText("Show Hidden");
        this.showHiddenCheckItem.setState(true);
        this.showHiddenCheckItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.showCheckItem_actionPerformed(e);
            }
        });
        this.showFilesCheckItem.setText("Show Files");
        this.showFilesCheckItem.setState(true);
        this.showFilesCheckItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.showCheckItem_actionPerformed(e);
            }
        });
        this.aboutItem.setText("About...");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.aboutItem_actionPerformed(e);
            }
        });
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.exitItem_actionPerformed(e);
            }
        });
        this.popupMenu.addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent e) {
                jDiskUsage.this.popupMenu_mouseExited(e);
            }

            public void mouseEntered(MouseEvent e) {
                jDiskUsage.this.popupMenu_mouseEntered(e);
            }
        });
        this.popupDissapear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                jDiskUsage.this.popupDissapear_actionPerformed(e);
            }
        });
        this.contentPane.add((Component)this.statusBar, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 2, 5, 0), 0, 0));
        this.contentPane.add((Component)this.fileSizePane, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(1, 2, 1, 2), 0, 0));
        this.fileSizePane.add((Component)this.jButton1, new XYConstraints(0, 0, -1, -1));
        this.contentPane.add((Component)this.filePanel, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 2, 1, 2), 0, 0));
        this.contentPane.add((Component)this.fileField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 1, 1), 0, 0));
        this.contentPane.add((Component)this.browseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 1, 1, 2), 0, 0));
        this.contentPane.add((Component)this.cancelButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(1, 1, 5, 2), 0, 0));
        this.popupMenu.add(this.showFilesCheckItem);
        this.popupMenu.add(this.showHiddenCheckItem);
        this.popupMenu.add(this.aboutItem);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.exitItem);
    }

    public void exitItem_actionPerformed(ActionEvent e) {
        System.exit(0);
    }

    public void aboutItem_actionPerformed(ActionEvent e) {
        jDiskUsage_AboutBox dlg = new jDiskUsage_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)dlg).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.exitItem_actionPerformed(null);
        }
    }

    private void showDir(DirectoryNode n, int x, int y, int height) {
        DirectoryNode o;
        if (x >= this.fileSizePane.getWidth()) {
            return;
        }
        int width = (this.fileSizePane.getWidth() - 4) / this._displayColumns;
        long size = n.getTotalSize();
        this.newButton(new FileButton(n), x, y, width, height);
        Iterator i = n.getChildren(this._displayMask).iterator();
        long currentSize = 0L;
        long miscSize = 0L;
        int miscCount = 0;
        double oy = 0.0;
        double oh = 0.0;
        while (i.hasNext()) {
            o = (DirectoryNode)i.next();
            oy = (double)((long)height * currentSize) * 1.0 / (double)n.getTotalSize();
            oh = (double)((long)height * o.getTotalSize()) * 1.0 / (double)n.getTotalSize();
            if (oh < (double)3) {
                miscSize += o.getTotalSize();
                ++miscCount;
                continue;
            }
            this.showDir(o, x + width, y + (int)Math.round(oy), (int)Math.round(oh));
            currentSize += o.getTotalSize();
        }
        if (this._secondDisplayMask >= 0) {
            i = n.getChildren(this._secondDisplayMask).iterator();
            while (i.hasNext()) {
                o = (DirectoryNode)i.next();
                oy = (double)((long)height * currentSize) * 1.0 / (double)n.getTotalSize();
                oh = (double)((long)height * o.getTotalSize()) * 1.0 / (double)n.getTotalSize();
                if (oh < (double)3) {
                    miscSize += o.getTotalSize();
                    ++miscCount;
                    continue;
                }
                this.showDir(o, x + width, y + (int)Math.round(oy), (int)Math.round(oh));
                currentSize += o.getTotalSize();
            }
        }
        if ((oh = (double)((long)height * miscSize) * 1.0 / (double)n.getTotalSize()) > (double)3) {
            JButton jb = new JButton(String.valueOf(String.valueOf(new StringBuffer("(").append(miscCount).append(" other - ").append(DirectoryNode.sizeToSizeH(miscSize)).append(")"))));
            jb.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            jb.setRequestFocusEnabled(false);
            jb.setFocusPainted(false);
            oy = (double)((long)height * currentSize) * 1.0 / (double)n.getTotalSize();
            this.newButton(jb, x + width, y + (int)Math.round(oy), width, (int)Math.round(oh));
        }
    }

    private void newButton(JButton b, int x, int y, int width, int height) {
        b.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                jDiskUsage.this.fileSizePane_mouseReleased(e);
            }
        });
        this.fileSizePane.add((Component)b, new XYConstraints(x, y, width, height));
    }

    void fileSizePane_componentResized(ComponentEvent e) {
        Component[] c = this.fileSizePane.getComponents();
        this.fileSizePane.removeAll();
        this.fileSizePane.repaint();
        if (this._base != null) {
            this.showDir(this._base, 0, 0, this.fileSizePane.getHeight() - 4);
        }
        this.fileSizePane.validate();
    }

    void browseButton_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser("\\");
        fc.setAcceptAllFileFilterUsed(false);
        fc.setControlButtonsAreShown(true);
        fc.setFileSelectionMode(1);
        int ret = fc.showDialog(this, "examine");
        if (ret == 0 && fc.getSelectedFile().exists()) {
            DirectoryNode n = new DirectoryNode(fc.getSelectedFile());
            n.setEventListener(this);
            this.loadNewNode(n);
        }
    }

    public void event(EventObject e) {
        ++this._progressNumDirs;
        this.statusBarText = String.valueOf(String.valueOf(new StringBuffer("Loading directory ").append(this._progressNumDirs).append(" - ").append(e.toString())));
        this.statusBarUpdate.trigger();
        if (this._loadCanceled) {
            throw new ActionCancelException();
        }
    }

    private void loadNewNode(final DirectoryNode n) {
        this.startReload();
        ThreadGroup ctg = Thread.currentThread().getThreadGroup();
        new Thread(GuiThreadGroup.getInstance(this, ctg, "jdu"), new Runnable(){

            public void run() {
                try {
                    long s = n.getTotalSize();
                    jDiskUsage.this._base = n;
                }
                catch (ActionCancelException e) {
                    jDiskUsage.this.endReload();
                    jDiskUsage.this.statusBarText = "Stopped loading: ".concat(String.valueOf(String.valueOf(e.getMessage())));
                    jDiskUsage.this.statusBarUpdate.trigger();
                    return;
                }
                catch (VirtualMachineError e) {
                    n.close();
                    System.gc();
                    GuiThreadGroup.error(jDiskUsage.this, Thread.currentThread(), e);
                }
                jDiskUsage.this.fileField.setText(jDiskUsage.this._base.getFile().getAbsolutePath());
                jDiskUsage.this.endReload();
            }
        }, "jdu directory loading").start();
    }

    void startReload() {
        this.fileSizePane.setEnabled(false);
        this.browseButton.setEnabled(false);
        this.cancelButton.setEnabled(true);
        this.statusBarText = "Loading new directory... ";
        this.statusBarUpdate.trigger();
        this._loadCanceled = false;
        this._progressNumDirs = 0;
    }

    void endReload() {
        this.fileSizePane_componentResized(null);
        this.fileSizePane.setEnabled(true);
        this.browseButton.setEnabled(true);
        this.cancelButton.setEnabled(false);
        this.statusBarText = String.valueOf(String.valueOf(new StringBuffer("Finished loading ").append(this._progressNumDirs > 0 ? "".concat(String.valueOf(String.valueOf(this._progressNumDirs))) : "cached").append(" directories")));
        this.statusBarUpdate.trigger();
        this._loadCanceled = false;
        this._progressNumDirs = 0;
    }

    void statusBarUpdate_actionPerformed(ActionEvent e) {
        this.statusBar.setText(this.statusBarText);
    }

    void cancelButton_actionPerformed(ActionEvent e) {
        this._loadCanceled = true;
    }

    void fileSizePane_mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger() || (e.getModifiers() & 0x10) == 0) {
            this.popupMenu.show(e.getComponent(), e.getX() - 2, e.getY() - 2);
        }
    }

    void showCheckItem_actionPerformed(ActionEvent e) {
        boolean showAll;
        boolean showFiles = this.showFilesCheckItem.getState();
        boolean showHidden = this.showHiddenCheckItem.getState();
        boolean bl = showAll = showFiles && showHidden;
        if (showAll) {
            this._displayMask = 4;
            this._secondDisplayMask = -1;
        } else if (showFiles) {
            this._displayMask = 0;
            this._secondDisplayMask = 1;
        } else if (showHidden) {
            this._displayMask = 0;
            this._secondDisplayMask = 2;
        } else {
            this._displayMask = 0;
            this._secondDisplayMask = -1;
        }
        this.fileSizePane_componentResized(null);
    }

    void popupMenu_mouseExited(MouseEvent e) {
        if (!e.getComponent().contains(e.getPoint())) {
            this.popupDissapear.trigger();
        }
    }

    void popupDissapear_actionPerformed(ActionEvent e) {
        this.popupMenu.setVisible(false);
    }

    void popupMenu_mouseEntered(MouseEvent e) {
        if (e.getComponent().contains(e.getPoint())) {
            this.popupDissapear.deTrigger();
        }
    }

    void directoryUp() {
        if (this._base == null || !this.fileSizePane.isEnabled()) {
            return;
        }
        this.goToNode(this._base.getParent());
    }

    void directoryFirstChild() {
        if (this._base == null || !this.fileSizePane.isEnabled()) {
            return;
        }
        this.goToNode(this._base.getFirstChild(this._displayMask, this._secondDisplayMask, this));
    }

    void directoryPreviousSibling() {
        if (this._base == null || !this.fileSizePane.isEnabled()) {
            return;
        }
        this.goToNode(this._base.getPreviousSibling(this._displayMask, this._secondDisplayMask, this));
    }

    void directoryNextSibling() {
        if (this._base == null || !this.fileSizePane.isEnabled()) {
            return;
        }
        this.goToNode(this._base.getNextSibling(this._displayMask, this._secondDisplayMask, this));
    }

    void goToNode(DirectoryNode n) {
        if (n == null) {
            return;
        }
        n.setEventListener(this);
        this.loadNewNode(n);
    }

    class FileButton
    extends JButton
    implements ActionListener {
        DirectoryNode _node;

        public FileButton(DirectoryNode f) {
            this._node = f;
            this.setText(this._node.toString());
            this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.setRequestFocusEnabled(false);
            this.setFocusPainted(false);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent e) {
            if (!jDiskUsage.this.fileSizePane.isEnabled()) {
                return;
            }
            if (this._node == jDiskUsage.this._base) {
                jDiskUsage.this.directoryUp();
            } else {
                jDiskUsage.this.goToNode(new DirectoryNode(this._node.getFile(), jDiskUsage.this._base.getCache()));
            }
        }
    }
}

