{$I+}

type endcluster_list = array[0..$1FFF] of longint;
     endcluster_array = array[0..9999] of ^endcluster_list;  { dummy index }
     sector = array[0..127] of longint;


var buffer:sector;
    infile:file of sector;
    outfile:text;
    endcluster:^endcluster_array;
    src_offset,dest_offset,indx,num_endclusters:longint;



procedure getclusterlist;
var clusterfile:file of longint;
    numchunks,i:longint;
begin
  assign(clusterfile,paramstr(3));
  reset(clusterfile);
  num_endclusters:=filesize(clusterfile);
  numchunks:=num_endclusters shr 13;
  if (num_endclusters and $1FFF)<>0 then inc(numchunks);
  if numchunks>0 then
    begin
      getmem(endcluster,numchunks*sizeof(pointer));
      for i:=0 to (numchunks-1) do new(endcluster^[i]);
      for i:=0 to (num_endclusters-1) do read(clusterfile,endcluster^[i shr 13]^[i and $1FFF]);
    end;
  close(clusterfile);
end;





procedure freememory;
var numchunks,i:longint;
begin
  if num_endclusters>0 then
    begin
      numchunks:=num_endclusters shr 13;
      if (num_endclusters and $1FFF)<>0 then inc(numchunks);
      for i:=0 to (numchunks-1) do dispose(endcluster^[i]);
      freemem(endcluster,numchunks*sizeof(pointer));
    end;
end;




function dectohex(x:longint):string;
const hex:string[16]='0123456789ABCDEF';
var result:string;
begin
  result:='';
  repeat
    result:=hex[(x and $F)+1]+result;
    x:=x shr 4;
  until x=0;
  result:=copy('00000000',1,8-length(result))+result;  { ensure 8 digits }
  dectohex:=result;
end;





begin
  if (paramcount<2) or (paramcount>3) then
    begin
      writeln;
      writeln('Usage:  MAPRECVR <corrupt CVF> <output file> [<cluster info file>]');
      writeln;
      writeln('See accompanying README.TXT file for more information');
      halt;
    end;

  if paramcount=3 then getclusterlist else num_endclusters:=0;

  src_offset:=0;
  dest_offset:=0;
  indx:=0;
  assign(infile,paramstr(1));
  assign(outfile,paramstr(2));
  reset(infile);
  rewrite(outfile);

  while not(eof(infile)) do
    begin
      read(infile,buffer);
      if (buffer[0]=$4D4A) or (buffer[0]=$1004D4A) or (buffer[0]=$5153) then
        begin
          write(outfile,dectohex(src_offset),'  ',dectohex(dest_offset));
          while (indx<num_endclusters-1) and
                (endcluster^[indx shr 13]^[indx and $1FFF]<(dest_offset shr 15))
            do inc(indx);
          if (indx<num_endclusters) and
             ((dest_offset shr 15)=endcluster^[indx shr 13]^[indx and $1FFF])
            then writeln(outfile,' *')
            else writeln(outfile);
          inc(dest_offset,$8000);
        end;
      inc(src_offset,$200);
      if (src_offset and $FFFFF)=0 then writeln(src_offset shr 20,' Mb');
    end;

  close(infile);
  close(outfile);
  freememory;
end.