<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

  <!-- f2xml custom transformation.                                   -->

  <!-- Email  : help@boulderwall.com                                  -->
  <!-- Web    : http://www.boulderwall.com                            -->
  <!-- Name   : images.xsl                                            -->
  <!-- Purpose: Transform XML filelist into HTML showing all of the   -->
  <!--          images as thumbnails in alphabetical order.            -->

  <xsl:variable name="n" select="'10'"/>

  <xsl:output method="html"/>

  <xsl:template match="/">
    <xsl:comment>
    Created by images.xsl. Input XML created by f2xml from www.boulderwall.com 
    </xsl:comment>
    <html>
      <body>
        <center>
          <h2>Images in<br/>
            <font color="blue">
              <xsl:value-of select="filetree/folder/@name"/>
            </font>
          </h2>
          <h4>created by f2xml via images.xsl<br/>
            <font size="-1">
              <a href="http://www.boulderwall.com">www.boulderwall.com</a>
            </font>
          </h4>
        </center>

        <xsl:if test="//file[@name='BOULDERWALL.com']">
          <h4>NOTE: XML output is from an unlicensed version of f2xml. Some files may be missing or named BOULDERWALL.com</h4>
        </xsl:if>

        <h4>Images</h4>

        <p>There are <xsl:value-of select="count(//file[
                                       contains(@name,'png') or
                                       contains(@name,'jpg') or
                                       contains(@name,'png')])"/> image files:</p>
        <table border="1" cellspacing="1" width="100%">
          <colgroup>
            <col width="40"/>
          </colgroup>
          <xsl:for-each select="//file[contains(@name,'png') or
                                       contains(@name,'jpg') or
                                       contains(@name,'png')]">
            <xsl:sort select="@name"/>
            <tr>
              <td>
                <a>
                  <xsl:attribute name="href">
                    <xsl:value-of select="fullpath"/>
                  </xsl:attribute>
                  <img height="40" width="40">
                    <xsl:attribute name="src">
                      <xsl:value-of select="fullpath"/>
                    </xsl:attribute>
                  </img>
                </a>
              </td>
              <td>
                <b><xsl:value-of select="@name"/></b>
              </td>
            </tr>
          </xsl:for-each>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match="text()"/>

</xsl:stylesheet>
