Attribute VB_Name = "Module2"
'=========================================
' RFSCLT.BAS
' Copyright (c) 2003, DTK Software.
' All rights reserved.
' http://www.dtksoft.com
'=========================================
Declare Function RFS_Connect Lib "rfsclt.dll" (ByVal Host As String, ByVal Port As Integer, ByVal User As String, ByVal Password As String, ByVal lpSock As Long) As Integer
Declare Function RFS_Disconnect Lib "rfsclt.dll" (ByVal nSock As Integer) As Integer
Declare Function RFS_FileCreate Lib "rfsclt.dll" (ByVal nSock As Integer, ByVal FileName As String) As Integer
Declare Function RFS_FileOpen Lib "rfsclt.dll" (ByVal nSock As Long, ByVal FileName As String, ByVal nAccess As Integer, ByVal lphFile As Long) As Integer
Declare Function RFS_FileExists Lib "rfsclt.dll" (ByVal nSock As Long, ByVal FileName As String, ByVal lpResult As Long) As Integer
Declare Function RFS_FileClose Lib "rfsclt.dll" (ByVal nSock As Long, ByVal hFile As Long) As Integer
Declare Function RFS_FileRead Lib "rfsclt.dll" (ByVal nSock As Long, ByVal hFile As Long, ByVal Buffer As String, ByVal nNumberOfBytesToRead As Long, ByVal lpNumberOfBytesRead As Long) As Integer
Declare Function RFS_FileWrite Lib "rfsclt.dll" (ByVal nSock As Long, ByVal hFile As Long, ByVal Buffer As String, ByVal nNumberOfBytesToWrite As Long, ByVal lpNumberOfBytesWritten As Long) As Integer
Declare Function RFS_FileSetPointer Lib "rfsclt.dll" (ByVal nSock As Long, ByVal hFile As Long, ByVal DistanceToMove As Long, ByVal nMoveMethod As Integer, ByVal lpNewPosition As Long) As Integer
Declare Function RFS_FileFindFirst Lib "rfsclt.dll" (ByVal nSock As Long, ByVal FileMask As String, ByVal lphSearch As Long, ByVal FileName As String, ByVal lpFileInfo As Long) As Integer
Declare Function RFS_FileFindNext Lib "rfsclt.dll" (ByVal nSock As Long, ByVal hSearch As Long, ByVal FileName As String, ByVal lpTest As Long) As Integer
Declare Function RFS_FileDelete Lib "rfsclt.dll" (ByVal nSock As Long, ByVal FileName As String) As Integer
Declare Function RFS_CreateDir Lib "rfsclt.dll" (ByVal nSock As Long, ByVal PathName As String) As Integer
Declare Function RFS_DeleteDir Lib "rfsclt.dll" (ByVal nSock As Long, ByVal PathName As String) As Integer
Declare Function RFS_FileGetInfo Lib "rfsclt.dll" (ByVal nSock As Long, ByVal FileName As String, ByVal lpFileInfo As Long) As Integer
Declare Sub RFS_GetErrorText Lib "rfsclt.dll" (ByVal ErrorCode As Integer, ByVal ErrorText As String)

Public Const RFS_FILE_READ = 1
Public Const RFS_FILE_WRITE = 2
Public Const RFS_FILE_READWRITE = 3

Public Const RFS_FILE_BEGIN = 0
Public Const RFS_FILE_CURRENT = 1
Public Const RFS_FILE_END = 2

Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FileTime, lpSystemTime As SYSTEMTIME) As Long
Private Declare Function PtrToStrA Lib "kernel32" Alias "lstrcpyA" (ByVal retval As String, ByVal Ptr As Long) As Long
Private Declare Function StrLen Lib "kernel32" Alias "lstrlenW" (ByVal Ptr As Long) As Long

Type SYSTEMTIME
        wYear As Integer
        wMonth As Integer
        wDayOfWeek As Integer
        wDay As Integer
        wHour As Integer
        wMinute As Integer
        wSecond As Integer
        wMilliseconds As Integer
End Type

Type FileTime
        dwLowDateTime As Long
        dwHighDateTime As Long
End Type

Type RFS_FILE_INFO
  Directory As Byte
  nFileSize As Long
  ftCreationTime As FileTime
  ftLastAccessTime As FileTime
  ftLastWriteTime As FileTime
End Type

'-----------------------------------------------------------------
' ToString function converts null-terminated string to VB string
'-----------------------------------------------------------------
Function ToString(StringValue As String) As String
   NullPos = InStr(StringValue, Chr$(0))
   If NullPos > 0 Then
      ToString = Left$(StringValue, NullPos - 1) 'Lose the null terminator...
   Else
      ToString = StringValue
   End If
End Function
'-----------------------------------------------------------------
' PointerToString function converts pointer to VB string
'-----------------------------------------------------------------
Function PointerToString(ByVal Pointer) As String
  Dim StringValue            As String
  Dim NullPos                As Long
  Dim Temp                   As Long
  ' Copy string to array and convert to a string
  If Pointer > 0 And StrLen(Pointer) > 0 Then
     StringValue = Space$(StrLen(Pointer) + 50)
     Temp = PtrToStrA(StringValue, Pointer)
     PointerToString = ToString(StringValue)
  Else
     PointerToString = ""
  End If
End Function
'---------------------------------------------------------------------
' SystimeToDate function converts SYSTEMTIME structure to VB Date type
'---------------------------------------------------------------------
Function SystimeToDate(st As SYSTEMTIME) As Date
    SystimeToDate = CDate(CStr(st.wMonth) + "/" + CStr(st.wDay) + "/" + CStr(st.wYear) + " " + CStr(st.wHour) + ":" + CStr(st.wMinute) + ":" + CStr(st.wSecond))
End Function
