Attribute VB_Name = "Module2"
'=========================================
' RFSSRV.BAS
' Copyright (c) 2003, DTK Software.
' All rights reserved.
' http://www.dtksoft.com
'=========================================

'====== RFS finctions declarations ======================
Declare Function RFS_StartServer Lib "rfssrv.dll" (ByVal nPort As Integer, ByVal hwnd As Long, ByVal nMsg As Long) As Integer
Declare Function RFS_StopServer Lib "rfssrv.dll" () As Integer
Declare Function RFS_IsRunning Lib "rfssrv.dll" () As Integer
Declare Function RFS_ActiveConnections Lib "rfssrv.dll" () As Integer
Declare Function RFS_UserAdd Lib "rfssrv.dll" (ByVal UserName As String, ByVal Password As String) As Integer
Declare Function RFS_UserDelete Lib "rfssrv.dll" (ByVal UserName As String) As Integer
Declare Function RFS_UserDeleteAll Lib "rfssrv.dll" () As Integer
Declare Function RFS_UserSetPassword Lib "rfssrv.dll" (ByVal UserName As String, ByVal Password As String) As Integer
Declare Function RFS_DeviceAdd Lib "rfssrv.dll" (ByVal DeviceName As String, ByVal Path As String) As Integer
Declare Function RFS_DeviceDelete Lib "rfssrv.dll" (ByVal DeviceName As String) As Integer
Declare Function RFS_DeviceDeleteAll Lib "rfssrv.dll" () As Integer
Declare Function RFS_SetUserDeviceRights Lib "rfssrv.dll" (ByVal UserName As String, ByVal DeviceName As String, ByVal Rights As String) As Integer
Declare Function RFS_GetUserDeviceRights Lib "rfssrv.dll" (ByVal UserName As String, ByVal DeviceName As String, ByVal Rights As String) As Integer
Declare Function RFS_EnumDevicesFirst Lib "rfssrv.dll" (ByVal DeviceName As String, ByVal Path As String) As Integer
Declare Function RFS_EnumDevicesNext Lib "rfssrv.dll" (ByVal DeviceName As String, ByVal Path As String) As Integer
Declare Function RFS_EnumUsersFirst Lib "rfssrv.dll" (ByVal UserName As String) As Integer
Declare Function RFS_EnumUsersNext Lib "rfssrv.dll" (ByVal UserName As String) As Integer
Declare Sub RFS_SetRegistrationCode Lib "rfssrv.dll" (ByVal Code As String)
Declare Sub RFS_GetErrorText Lib "rfssrv.dll" (ByVal ErrorCode As Integer, ByVal ErrorText As String)

Private Declare Function PtrToStrA Lib "kernel32" Alias "lstrcpyA" (ByVal retval As String, ByVal Ptr As Long) As Long
Private Declare Function StrLen Lib "kernel32" Alias "lstrlenW" (ByVal Ptr As Long) As Long

' define types of RFS event message
Public Const MSG_SERVER_STARTED = 1
Public Const MSG_SERVER_STOPPED = 2
Public Const MSG_CLIENT_AUTH_FAILED = 3
Public Const MSG_CLIENT_CONNECTED = 4
Public Const MSG_CLIENT_DISCONNECTED = 5
Public Const MSG_CLIENT_FILEOPEN = 6
Public Const MSG_CLIENT_FILECLOSE = 7
Public Const MSG_CLIENT_FILEEXISTS = 8
Public Const MSG_CLIENT_FILEREAD = 9
Public Const MSG_CLIENT_FILEWRITE = 10
Public Const MSG_CLIENT_FILECREATE = 11
Public Const MSG_CLIENT_FILEDELETE = 12
Public Const MSG_CLIENT_FILESETPOINTER = 13
Public Const MSG_CLIENT_FILEFINDFIRST = 14
Public Const MSG_CLIENT_FILEFINDNEXT = 15
Public Const MSG_CLIENT_CREATEDIR = 16
Public Const MSG_CLIENT_DELETEDIR = 17
Public Const MSG_CLIENT_GETFILEINFO = 18
'-----------------------------------------------------------------
' ToString function converts null-terminated string to VB string
'-----------------------------------------------------------------
Function ToString(StringValue As String) As String
   NullPos = InStr(StringValue, Chr$(0))
   If NullPos > 0 Then
      ToString = Left$(StringValue, NullPos - 1) 'Lose the null terminator...
   Else
      ToString = StringValue 'Just pass the string...
   End If
End Function
'-----------------------------------------------------------------
' PointerToString function converts pointer to VB string
'-----------------------------------------------------------------
Function PointerToString(ByVal Pointer) As String
  Dim StringValue            As String
  Dim NullPos                As Long
  Dim Temp                   As Long
  'Copy string to array and convert to a string
  If Pointer > 0 And StrLen(Pointer) > 0 Then
     StringValue = Space$(StrLen(Pointer) + 50)
     Temp = PtrToStrA(StringValue, Pointer)
     PointerToString = ToString(StringValue)
  Else
     PointerToString = ""
  End If
End Function
