//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/ 
// RFSCLT.H 
// Copyright (c) 2003, DTK Software.
// All rights reserved.
// http://www.dtksoft.com
//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/ 

#include <wtypes.h>

#ifdef RFSCLT_EXPORTS
#define RFSCLT_API __declspec(dllexport)
#else
#define RFSCLT_API __declspec(dllimport)
#endif

#define RFS_FILE_READ		1
#define RFS_FILE_WRITE		2
#define RFS_FILE_READWRITE	3

#define RFS_FILE_BEGIN		0
#define RFS_FILE_CURRENT	1
#define RFS_FILE_END		2

struct RFS_FILE_INFO
{
  BOOL bDirectory;
  DWORD dwFileSize;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
};

RFSCLT_API int _stdcall RFS_Connect(
						   LPTSTR lpHost,
						   int nPort,
						   LPTSTR lpUser,
						   LPTSTR lpPassword,
						   int* pnSock);

RFSCLT_API int _stdcall RFS_Disconnect(int sock);

RFSCLT_API int _stdcall RFS_FileOpen(
							 int nSock,
							 LPTSTR lpFileName,
							 int nAccess,
							 HANDLE *hFile
							 );

RFSCLT_API int _stdcall RFS_FileDelete(
						   int nSock,
						   LPTSTR lpFileName
						   );

RFSCLT_API int _stdcall RFS_FileExists(
						     int nSock,
							 LPTSTR lpFileName,
							 int *lpExists
						 );

RFSCLT_API BOOL _stdcall RFS_FileRead(
						      int nSock,
							  HANDLE hFile,
							  LPVOID lpBuffer,
							  DWORD nNumberOfBytesToRead,
							  LPDWORD lpNumberOfBytesRead
							  );
RFSCLT_API BOOL _stdcall RFS_FileWrite(
						       int nSock,
							   HANDLE hFile,
							   LPCVOID lpBuffer,
							   DWORD nNumberOfBytesToWrite,
							   LPDWORD lpNumberOfBytesWritten
							   );


RFSCLT_API BOOL _stdcall RFS_FileClose(
						     int nSock,
							 HANDLE hFile
							 );

RFSCLT_API int _stdcall RFS_FileSetPointer(
						 int nSock,
						 HANDLE hFile,
						 LONG lDistanceToMove, 
						 int nMoveMethod,
						 LPDWORD ldwNewPosition
						 );

RFSCLT_API int _stdcall RFS_FileFindFirst(
						 int nSock,
						 LPTSTR lpFileMask,
						 HANDLE *phSearch,
						 LPTSTR lpFileName,
						 RFS_FILE_INFO * lpFileInfo
						 );

RFSCLT_API int _stdcall RFS_FileFindNext(
						 int nSock,
						 HANDLE hSearch,
						 LPTSTR lpFileName,
						 RFS_FILE_INFO * lpFileInfo
						 );

RFSCLT_API BOOL _stdcall RFS_FileCreate(
						   int nSock,
						   LPTSTR lpFileName
						   );

RFSCLT_API void _stdcall RFS_GetErrorText(
								 int nErrorCode,
								 LPTSTR lpErrorText
							);

RFSCLT_API int _stdcall RFS_CreateDir(
						     int nSock,
							 LPTSTR lpPathName
						 );

RFSCLT_API int _stdcall RFS_DeleteDir(
						     int nSock,
							 LPTSTR lpPathName
						 );

RFSCLT_API int _stdcall RFS_FileGetInfo(
						     int nSock,
							 LPTSTR lpFileName,
							 RFS_FILE_INFO * lpFileInfo
						 );