/*
 * Decompiled with CFR 0.152.
 */
package com.jshift.ccu.gui;

import com.jshift.ccu.Attribute;
import com.jshift.ccu.Entity;
import com.jshift.ccu.ExtrapolationParameters;
import com.jshift.ccu.IZ;
import com.jshift.ccu.Project;
import com.jshift.ccu.ProjectElement;
import com.jshift.ccu.ProjectElementMgr;
import com.jshift.ccu.WorkArea;
import com.jshift.ccu.gui.AttributePanel;
import com.jshift.ccu.gui.CB;
import com.jshift.ccu.gui.EntityPanel;
import com.jshift.ccu.gui.FC;
import com.jshift.ccu.gui.IB;
import com.jshift.ccu.gui.JB;
import com.jshift.ccu.gui.JF;
import com.jshift.ccu.gui.ProjectWindowPropertiesBox;
import com.jshift.ccu.gui.ProjectWindowTreePane;
import com.jshift.ccu.gui.RC;
import com.jshift.ccu.gui.TC;
import com.jshift.ccu.gui.UC;
import com.jshift.ccu.gui.V;
import com.jshift.ccu.gui.VC;
import com.jshift.ccu.gui.WC;
import com.jshift.ccu.gui.WorkAreaWindow;
import com.jshift.ccu.gui.XC;
import com.jshift.ccu.gui.YC;
import com.jshift.ccu.gui.ZB;
import com.jshift.ccu.util.C;
import com.jshift.ccu.util.I;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;

public class ProjectWindow
extends JB {
    private Dimension add = new Dimension(600, 400);
    private static File addAll;
    public static final boolean APPEND_MODE = true;
    public static final boolean PREPEND_MODE = false;
    private static final FileFilter addChoosableFileFilter;
    private static final FileFilter addEntities;
    private static final FileFilter append;
    private static final FileFilter asList;
    private static final FileFilter captureState;
    private static final FileFilter charAt;
    private static final FileFilter class$;
    static Class clear;
    static Class I;
    static final boolean close;

    public ProjectWindow(WorkAreaWindow workAreaWindow, Project project) {
        this(workAreaWindow, project, workAreaWindow.getWorkArea().nextProjectName());
    }

    public ProjectWindow(WorkAreaWindow workAreaWindow, Project project, File file) {
        this(workAreaWindow, project, (String)null);
        this.setProjFile(file);
    }

    public ProjectWindow(WorkAreaWindow workAreaWindow, Project project, String string) {
        super(string, true, true, true, true);
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)1, "Constructing window for " + project);
        }
        this.setProj(project);
        this.setWorkAreaWin(workAreaWindow);
        this.I(new ZB(this));
        this.I(new JSplitPane(1, new ProjectWindowTreePane(this), new ProjectWindowPropertiesBox(this)));
        this.getContentPane().add(this.B());
        this.pack();
        this.setSize(this.add);
        this.setVisible(true);
        this.addInternalFrameListener(new CB(this));
        this.S().addChoosableFileFilter(WorkAreaWindow.I);
        this.F().setAccessory(new FC(this));
        this.F().setMultiSelectionEnabled(true);
        this.F().setFileSelectionMode(2);
        this.F().setAcceptAllFileFilterUsed(false);
        this.F().addChoosableFileFilter(append);
        this.F().addChoosableFileFilter(addChoosableFileFilter);
        this.F().addChoosableFileFilter(captureState);
        this.F().addChoosableFileFilter(asList);
        this.F().addChoosableFileFilter(class$);
        this.F().addChoosableFileFilter(charAt);
        this.F().addChoosableFileFilter(addEntities);
        this.J().setAccessory(new V(this));
        this.J().setFileSelectionMode(2);
        this.J().setAcceptAllFileFilterUsed(false);
        this.J().addChoosableFileFilter(append);
        this.J().addChoosableFileFilter(addChoosableFileFilter);
        this.J().addChoosableFileFilter(captureState);
        this.J().addChoosableFileFilter(asList);
        this.J().addChoosableFileFilter(class$);
        this.J().addChoosableFileFilter(charAt);
        this.J().addChoosableFileFilter(addEntities);
        this.setDefaultCloseOperation(0);
        this.addInternalFrameListener(this.addAll());
        this.getPropertiesBox().refreshActivePropertiesPanel();
    }

    public final WorkArea getWorkArea() {
        return this.getWorkAreaWin().getWorkArea();
    }

    public final ProjectWindowTreePane getTreePane() {
        return (ProjectWindowTreePane)this.B().getLeftComponent();
    }

    public final ProjectWindowPropertiesBox getPropertiesBox() {
        return (ProjectWindowPropertiesBox)this.B().getRightComponent();
    }

    public final boolean getInsertionMode() {
        return ((JF)this.getWorkAreaWin().getJMenuBar()).F().J().isSelected();
    }

    public final Entity[] getSelectedAttributeParents() {
        TreePath[] treePathArray = this.getTreePane().getTree().getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int n = 0; n < treePathArray.length; n = (int)((byte)(n + 1))) {
            if (treePathArray[n].getPath().length <= 0) continue;
            hashSet.add(treePathArray[n].getPath()[1]);
        }
        return hashSet.toArray(new Entity[0]);
    }

    public final void deleteElements() {
        int n;
        TreePath[] treePathArray = this.getTreePane().getTree().getSelectionPaths();
        C c = C.captureState(this.getTreePane().getTree());
        CompoundEdit compoundEdit = this.getProj().startEdit("Remove " + this.add());
        boolean bl = ((AttributePanel)this.getPropertiesBox().getAttributesPane().getSelectedComponent()).isListeningForUserInput();
        ((AttributePanel)this.getPropertiesBox().getAttributesPane().getSelectedComponent()).setListeningForUserInput(false);
        for (n = 0; n < treePathArray.length; n = (int)((byte)(n + 1))) {
            if (!(treePathArray[n].getLastPathComponent() instanceof Attribute)) continue;
            ((Entity)treePathArray[n].getPath()[1]).getAttributes().remove(treePathArray[n].getLastPathComponent());
        }
        n = ((EntityPanel)this.getPropertiesBox().getEntitiesPane().getSelectedComponent()).isListeningForUserInput() ? 1 : 0;
        ((EntityPanel)this.getPropertiesBox().getEntitiesPane().getSelectedComponent()).setListeningForUserInput(false);
        for (int n2 = 0; n2 < treePathArray.length; n2 = (int)((byte)(n2 + 1))) {
            if (!(treePathArray[n2].getLastPathComponent() instanceof Entity)) continue;
            this.getProj().getEntities().remove(treePathArray[n2].getLastPathComponent());
        }
        compoundEdit.end();
        c.restoreState(this.getTreePane().getTree());
        ((EntityPanel)this.getPropertiesBox().getEntitiesPane().getSelectedComponent()).setListeningForUserInput(n != 0);
        ((AttributePanel)this.getPropertiesBox().getAttributesPane().getSelectedComponent()).setListeningForUserInput(bl);
    }

    public final void moveElements(boolean bl) {
        Object[] objectArray = this.getSelectedElements();
        C c = C.captureState(this.getTreePane().getTree());
        if (objectArray instanceof Entity[]) {
            this.getProj().getEntities().move(objectArray, bl);
        } else if (objectArray instanceof Attribute[]) {
            Entity[] entityArray = this.getSelectedAttributeParents();
            for (int n = 0; n < entityArray.length; n = (int)((byte)(n + 1))) {
                entityArray[n].getAttributes().move(objectArray, bl);
            }
        } else if (!close) {
            throw new AssertionError();
        }
        c.restoreState(this.getTreePane().getTree());
    }

    public final void addEntity(Entity entity) {
        this.addEntities(new Entity[]{entity});
    }

    public final void addEntities(Entity[] entityArray) {
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)1, "Preparing to add " + entityArray.length + " entity/entities to project " + this.getProj());
        }
        int n = this.getProj().getEntities().size();
        try {
            n = this.getProj().getEntities().indexOf(this.getTreePane().getSelectedElementPath()[0]);
            if (this.getInsertionMode()) {
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.getProj().getEntities().addAll(n, Arrays.asList(entityArray));
        if (entityArray.length > 0) {
            TreePath treePath = new TreePath(new Object[]{this.getProj().getRoot(), entityArray[0]});
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)this, (byte)1, "Setting path to " + IZ.expandGroup(treePath));
            }
            this.getTreePane().getTree().expandPath(treePath);
            this.getTreePane().getTree().setLeadSelectionPath(treePath);
            this.getTreePane().getTree().setAnchorSelectionPath(treePath);
            this.getTreePane().getTree().setSelectionPath(treePath);
        }
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)1, "Finished adding " + entityArray.length + " entity/entities to project " + this.getProj());
        }
    }

    public final void addAttribute(Attribute attribute) {
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, "Adding attribute " + attribute + " to project " + this.getProj());
        }
        Entity entity = (Entity)this.getTreePane().getSelectedElementPath()[0];
        int n = this.getProj().getEntities().indexOf(entity);
        int n2 = entity.getAttributes().size();
        try {
            n2 = entity.getAttributes().indexOf(this.getTreePane().getSelectedElementPath()[1]);
            if (this.getInsertionMode()) {
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        entity.getAttributes().add(n2, attribute);
        TreePath treePath = new TreePath(new Object[]{this.getProj().getRoot(), entity, attribute});
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)1, "Setting path to " + IZ.expandGroup(treePath));
        }
        this.getTreePane().getTree().setSelectionPath(treePath);
        this.getTreePane().getTree().expandPath(treePath);
        this.getTreePane().getTree().setLeadSelectionPath(treePath);
        this.getTreePane().getTree().setAnchorSelectionPath(treePath);
        this.getTreePane().getTree().setSelectionPath(treePath);
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)1, "Finished adding " + attribute + " to project " + this.getProj());
        }
    }

    private String add() {
        ProjectElement[] projectElementArray = this.getSelectedElements();
        return projectElementArray == null ? null : (projectElementArray instanceof Entity[] ? (projectElementArray.length > 1 ? "entities" : "entity") : (projectElementArray instanceof Attribute[] ? (projectElementArray.length > 1 ? "attributes" : "attribute") : (projectElementArray.length > 1 ? "elements" : "element")));
    }

    public final ProjectElement[] getSelectedElementPath() {
        return this.getTreePane().getSelectedElementPath();
    }

    public final ProjectElement getSelectedElement() {
        return this.getTreePane().getSelectedElement();
    }

    public final ProjectElement[] getSelectedElements() {
        return this.getTreePane().getSelectedElements();
    }

    public final File save() {
        if (this.Z() == null) {
            return this.saveAs();
        }
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, "Saving " + this.getProj() + " to " + this.Z());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.Z());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.getProj());
            objectOutputStream.flush();
            fileOutputStream.close();
            this.setLastSavePoint(this.getProj().getUndoMgr().editToBeUndone());
            return this.Z();
        }
        catch (Exception exception) {
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)this, (byte)3, "Error saving: " + exception);
            }
            IZ.showErrorMsg(this, exception, "Failed to save.");
            return null;
        }
    }

    public final File saveAs() {
        int n = this.S().showSaveDialog(this.getWorkAreaWin());
        if (n == -1 || n == 1) {
            return null;
        }
        File file = this.S().getSelectedFile();
        if (this.S().getFileFilter() == WorkAreaWindow.I && !file.getPath().endsWith(".ccu")) {
            file = new File(file.getPath() + '.' + "ccu");
        }
        if (file.exists() && JOptionPane.showConfirmDialog(this.getWorkAreaWin(), file + " already exists.  Do you want to replace it?", "Save File As...", 0, 2) != 0) {
            return this.saveAs();
        }
        this.setProjFile(file);
        return this.save();
    }

    public final void doImport() {
        int n = this.F().showDialog(this.getWorkAreaWin(), "Import");
        if (n == 0) {
            IZ.showComingSoonMsg(this.getWorkAreaWin());
        }
    }

    public final void doExport() {
        int n = this.J().showDialog(this.getWorkAreaWin(), "Export");
        if (n == 0) {
            IZ.showComingSoonMsg(this.getWorkAreaWin());
        }
    }

    public final void launchEditor() {
        File file;
        TreePath treePath;
        block6: {
            ProjectElement projectElement = this.getSelectedElement();
            treePath = this.getTreePane().getTree().getSelectionPath();
            String string = "code";
            file = new File(addAll, ProjectWindow.C() + ".tmp");
            ProjectWindow.I(ProjectWindow.C() + 1);
            try {
                FileWriter fileWriter = new FileWriter(file);
                String string2 = ((ProjectElementMgr)projectElement.getElementMgr(this.getProj().getActiveLang())).getCode(this.newParams());
                if (string2 != null) {
                    fileWriter.write(string2);
                }
                fileWriter.flush();
                fileWriter.close();
            }
            catch (IOException iOException) {
                if (!com.jshift.ccu.util.I.isLogging()) break block6;
                com.jshift.ccu.util.I.log((Object)this, (byte)3, "Error creating temp file " + file.getPath() + iOException);
            }
        }
        try {
            Runtime.getRuntime().exec("notepad.exe " + file);
        }
        catch (IOException iOException) {
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)this, (byte)3, "Error lauching editor " + iOException);
            }
            file.delete();
            return;
        }
        this.D().put(file, new Object[]{treePath, "code", this.getProj().getActiveLang(), new Long(file.lastModified())});
    }

    public final ExtrapolationParameters newParams() {
        return this.newParams(this.getSelectedElementPath());
    }

    public final ExtrapolationParameters newParams(TreePath treePath) {
        return this.newParams(ProjectWindowTreePane.I(treePath));
    }

    public final ExtrapolationParameters newParams(ProjectElement[] projectElementArray) {
        ExtrapolationParameters extrapolationParameters = projectElementArray == null || projectElementArray.length == 0 ? new ExtrapolationParameters(this.getWorkAreaWin().getWorkArea(), this.getProj()) : new ExtrapolationParameters(this.getWorkAreaWin().getWorkArea(), this.getProj(), (Entity)projectElementArray[0]);
        return extrapolationParameters;
    }

    public final int checkTempFilesForUpdates() {
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)0, "Got the focus.  About to check temp files...");
        }
        int n = 0;
        Enumeration enumeration = this.D().keys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            ExtrapolationParameters extrapolationParameters;
            String string3;
            String string4;
            ProjectElement projectElement;
            Object[] objectArray;
            File file;
            block12: {
                file = (File)enumeration.nextElement();
                if (com.jshift.ccu.util.I.isLogging()) {
                    com.jshift.ccu.util.I.log((Object)this, (byte)1, "Checking " + file.getPath() + " for updates");
                }
                if (!file.exists() || !file.isFile()) {
                    if (com.jshift.ccu.util.I.isLogging()) {
                        com.jshift.ccu.util.I.log((Object)this, file.getPath() + " removed");
                    }
                    this.D().remove(file);
                    continue;
                }
                Object[] objectArray2 = (Object[])this.D().get(file);
                if (file.lastModified() == ((Long)objectArray2[3]).longValue()) continue;
                ++n;
                objectArray2[3] = new Long(file.lastModified());
                TreePath treePath = (TreePath)objectArray2[0];
                objectArray = new Object[treePath.getPathCount() - 1];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = treePath.getPathComponent(i + 1);
                }
                projectElement = (ProjectElement)treePath.getLastPathComponent();
                string4 = (String)objectArray2[1];
                string3 = (String)objectArray2[2];
                extrapolationParameters = this.newParams();
                string2 = (String)projectElement.getElementMgr(string3).getPropertyVal(string4, extrapolationParameters);
                string = null;
                try {
                    string = IZ.fileToString(file);
                }
                catch (IOException iOException) {
                    if (!com.jshift.ccu.util.I.isLogging()) break block12;
                    com.jshift.ccu.util.I.log((Object)this, (byte)3, "Failed to read file " + file);
                }
            }
            if (string2 == null ? string == null : string2.equals(string)) {
                if (!com.jshift.ccu.util.I.isLogging()) continue;
                com.jshift.ccu.util.I.log((Object)this, file.getPath() + " has been re-saved but not updated.");
                continue;
            }
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)this, file.getPath() + " has been updated.  User must decide whether to " + "reset property '" + string4 + "' in lang '" + string3 + "' for element path '" + IZ.expandGroup(objectArray) + "'\n" + "old value:\n" + string2 + "\nnew value:\n" + string);
            }
            String string5 = "explicit" + Character.toUpperCase(string4.charAt(0)) + string4.substring(1);
            projectElement.getElementMgr(string3).setPropertyVal(string5, true, extrapolationParameters);
            projectElement.getElementMgr(string3).setPropertyVal(string4, string, extrapolationParameters);
        }
        if (n > 0) {
            this.getPropertiesBox().refreshActivePropertiesPanel();
        }
        if (com.jshift.ccu.util.I.isLogging()) {
            com.jshift.ccu.util.I.log((Object)this, (byte)0, "Finished checking temp files.  " + n + " updates.");
        }
        return n;
    }

    private InternalFrameListener addAll() {
        return new TC(this);
    }

    final void I() {
        Enumeration enumeration = this.D().keys();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            if (file.delete() || !com.jshift.ccu.util.I.isLogging()) continue;
            com.jshift.ccu.util.I.log((Object)this, (byte)2, "Failed to delete temp file: " + file.getPath());
        }
        this.D().clear();
    }

    public final void setProjFile(File file) {
        super.setProjFile(file);
        this.setTitle(ProjectWindow.addChoosableFileFilter(file));
    }

    protected static final String addChoosableFileFilter(File file) {
        return file.getName();
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        close = !(I == null ? (I = ProjectWindow.class$("com.jshift.ccu.gui.ProjectWindow")) : I).desiredAssertionStatus();
        try {
            addAll = new File(System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "ccu");
        }
        catch (Exception exception) {
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)(clear == null ? (clear = ProjectWindow.class$("com.jshift.ccu.gui.WorkAreaWindow")) : clear), (byte)2, "Can't find temp dir: " + exception);
            }
            addAll = new File(".\\temp");
        }
        if (!addAll.exists()) {
            if (com.jshift.ccu.util.I.isLogging()) {
                com.jshift.ccu.util.I.log((Object)(I == null ? (I = ProjectWindow.class$("com.jshift.ccu.gui.ProjectWindow")) : I), (byte)1, "Creating temp dir: " + addAll);
            }
            addAll.mkdirs();
        }
        addChoosableFileFilter = new RC();
        addEntities = new UC();
        append = new VC();
        asList = new WC();
        captureState = new XC();
        charAt = new YC();
        class$ = new IB();
    }
}

