package ishitai.oopad;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/**
 * EditorMenu.java
 *
 *
 * Created: Thu Sep 02 1999
 *
 * @author Richard Harris
 * @version 1.0
 */
public class EditorMenu extends MenuBar 
	implements IEditorMenu, ActionListener{

   private Menu mnuFile = new Menu("File");
   private MenuItem mniNew = new MenuItem("New");
   private MenuItem mniOpen = new MenuItem("Open");
   private MenuItem mniSave = new MenuItem("Save");
   private MenuItem mniExit = new MenuItem("Exit");
   private Vector menuEventListeners = new Vector();
   private EditorGui dumbGui = new EditorGui("OOPad : original", this);

   EditorMenu(){
      super();
      _init();
   }

   private void _init(){
      add(mnuFile);
      mniNew.addActionListener(this);
      mnuFile.add(mniNew);
      mniOpen.addActionListener(this);
      mnuFile.add(mniOpen);
      mniSave.addActionListener(this);
      mnuFile.add(mniSave);
      mnuFile.addSeparator();
      mniExit.addActionListener(this);
      mnuFile.add(mniExit);
   }

	/**
	 * Pass-through call than connects the Module's WindowListener to
	 * the Frame and returns references to the TextArea, status line,
	 * and outer frame.
	 *
	 * @param o The module that needs the gui references
	 * @param wl The AppCloser to be hooked to the Frame
	 * @return An array of Components 
	 */
   public Component[] addListeners(Object o, WindowListener wl){
      return dumbGui.addListeners(o, wl);
   }

	/**
	 * Required for ActionListener
	 */
   public void actionPerformed(ActionEvent e){
      MenuEvent me = new MenuEvent(this, e.getActionCommand());
      notifyMenuEventListeners(me);
   }

	/**
	 * Required for MenuEventListener
	 */
   public void addMenuEventListener(MenuEventListener mel){
      if (!menuEventListeners.contains(mel)){
	 menuEventListeners.add(mel);
      }
   }

   private void notifyMenuEventListeners(MenuEvent me){
      Vector v = null;
      synchronized(this){
			v = (Vector)menuEventListeners.clone();
      }
      int i = v.size();
      for (int j = 0; j < i; j++){
			MenuEventListener mel = (MenuEventListener)v.elementAt(j);
			mel.handleMenuEvent(me);
      }
   }
}//EditorMenu


