package ishitai.oopad;

import ishitai.bots.*;
import java.awt.*;
import java.io.*;
import java.awt.event.*;

/**
 * TXTmodule.java
 *
 *
 * Created: Wed Sep 01 21:01:06 1999
 *
 * @author Richard Harris
 * @version 1.0
 * changes:
 * 3.5.00 removing frame reference
 * 3.5.00 READ ONLY handling
 */
public class TXTmodule implements Module, TextListener, ActionListener{
   public AppCloser appcloser = new AppCloser(this);

   final private String dirtyQuery = "Current file dirty -- save? (y or n): ";

   private TextArea textarea = null;
   private TextField status = null;
   private TXTdata data = null;
   private Adapter adapter = null;
   private String query = null;
   private boolean dirty = false;
	private boolean start = true;
   private int state = -1;
   private ExcepBot ebot = BotFactory.getExcepBot();

   TXTmodule(Adapter a){
      adapter = a;
      Component[] components = adapter.setTarget(this, appcloser);
      textarea = (TextArea)components[0];
      status = (TextField)components[1];
      registerCalls();
		if (start){
         setData();
			textarea.setText(data.showLicense());
         if(data.readOnly()){
            textarea.setEditable(false);
         }
			start = false;
		}
   }

	/**
	 * Required by TextListener; currently used only for dirty flag
	 */
   public void textValueChanged(TextEvent e){
      if (!dirty){
			dirty = true;
      }
   }

	/**
	 * Required by ActionListener; used to received user input
	 * from the status line.
	 */
   public void actionPerformed(ActionEvent ae){
      String reply = status.getText();
      status.setText("");
      reply = getReply(reply);
      if(query.compareTo(dirtyQuery) == 0){
			if(reply.compareTo("y") == 0){
			   saveFile();
			}
         setState();
      }
   }

	/**
	 * Registered with "New" into Adapter.
	 */
   public void newFile(){
      state = NEW;
      if(dirty){
			clean();
      } else {
			_new();
      }
   }

	/**
	 * Registered with "Open" into Adapter.
	 */
   public void openFile(){
      state = OPEN;
      if (dirty){
			clean();
      } else {
			_open();
      }
   }

	/**
	 * Registered with "Save" into Adapter.
	 */
   public void saveFile(){
      if (!data.readOnly()){
         String tmp = textarea.getText();
         if (tmp.compareTo("") != 0){
            if(data  == null){
               data = new TXTdata();
            }
           data.write(tmp);
           dirty = false;
           status.setText(data.getFilename() +  " saved.");
         }
         if (status.hasFocus()){
            status.setText(status.getText() +  "  TAB to edit.");
         }
      } else {
         status.setText("Current file is READ ONLY.");
      }
   }

	/**
	 * Registered with "Exit" into Adapter.
	 */	
   public void exitFile(){
      state = EXIT;
      if (dirty){
			clean();
      } else {
			_exit();
      }
   }
   
   // private methods //
   
   private void _new(){
      setData();
      status.setEditable(false);
      textarea.setEditable(true);
      textarea.setText("");
      status.setText("New file loaded.");
      if (status.hasFocus()){
         status.setText(status.getText() +  "  TAB to edit.");
         dirty = false;
      }
   }

   private void _open(){
      setData();
      status.setEditable(false);
      textarea.setEditable(true);
      String tmp = data.open();
      if (tmp.compareTo("") == 0){
         //open dialog cancelled
         status.setText("Current file retained.");
      } else {
         //file found
         textarea.setText(tmp);
         status.setText(data.getFilename() +  " loaded.");
         if(data.readOnly()){
            textarea.setEditable(false);
            status.setText(status.getText() +  " READ ONLY.");
         }
      }
      if (status.hasFocus() & !data.readOnly()){
         status.setText(status.getText() +  "  TAB to edit.");
      }
   }

   private void _exit(){
      System.exit(0);
   }
	
   private void setData(){
      if (data != null){
			data.close();
      }
      data = new TXTdata();
   }
   
   private void setState(){
      switch (state){
         case NEW: _new();break;
         case OPEN: _open();break;
         case EXIT: _exit();break;
      }
   }
	
   private void clean(){
      query = dirtyQuery;
      textarea.setEditable(false);
      status.setEditable(true);
      status.requestFocus();
      status.setText(dirtyQuery);
      status.setCaretPosition(status.getText().length());
   }

   private String getReply(String tmp){
      tmp.trim();
      StringBuffer sb = new StringBuffer(tmp);
      sb.reverse();
      byte[] temp = sb.toString().getBytes();
      StringBuffer entry = new StringBuffer();
      int i = 0;
      char ch = (char)temp[i];
      while(!Character.isWhitespace(ch)){
         entry.append(ch);
         ch = (char)temp[++i];
      }
      entry.reverse();
      tmp  = new String(entry);
      return tmp;
   }

   private void registerCalls(){
      adapter.registerCall("New", "newFile");
      adapter.registerCall("Open", "openFile");
      adapter.registerCall("Save", "saveFile");
      adapter.registerCall("Exit", "exitFile");
   }

}


