* PE32 Default Keys

* Tabs at 9 17 25 ...
set tabs 9 8

* Set screen colors (data, selected data, command line, dialog boxes)
*          Background  Foreground
set colors blue        brightwhite \
           red         brightwhite \
           green       brightwhite \
           brightwhite red

* Set extentions to use coloring scheme 0
set syntaxcoloringext0 .cxx .cpp .c .inl .hxx .hpp .h .tlh .tli

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring0 blue        lightaqua   \
                    blue        lightaqua   \
                    blue        lightyellow \
                    blue        lightyellow \
                    blue        green       \
                    blue        aqua

* Set extentions to use coloring scheme 1
set syntaxcoloringext1 .htm .html

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring1 black       lightaqua   \
                    black       lightaqua   \
                    black       lightyellow \
                    black       lightyellow \
                    black       green       \
                    black       aqua

* Set extentions to use coloring scheme 2
set syntaxcoloringext2 .asm

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring2 black       lightaqua   \
                    black       lightaqua   \
                    black       lightyellow \
                    black       lightyellow \
                    black       green       \
                    black       aqua

* Set extentions to use coloring scheme 3
set syntaxcoloringext3 .bat .cmd

* Set screen colors for syntax coloring
* (language keywords, operators, strings, numbers, remarks and system keywords)
*                   Background  Foreground
set syntaxcoloring3 black       lightaqua   \
                    black       lightaqua   \
                    black       lightyellow \
                    black       lightyellow \
                    black       green       \
                    black       aqua

* Margins 1 to 80, paragraph starts at 1
set margins 1 80 1

* Set screen display size
set display 25 80

* Set default printer
set printer lpt1

* Set extentions to backup
set backup .cpp .c .hpp .h

* Modifier to up/down arrows to control history (when on command line)
* Modifier to up/down arrows to enter history dialog (when on not command line)
set historyon shift

* When saving file trim trailing blanks from lines
set linetrim trailing

* No context help file ... set to path for the compiler help of your choice
set helpfile

* Set to overwrite existing files without a confirming message
set confirm off

* Start in replace character mode
set insert off

* Define format of [date] command ... s-f11 will insert actual date as text
set date [dd]/[mm]/[yyyy]

* Define format of [time] command ... s-f12 will insert actual time as text
set time [24]:[mm]

* Disable password protection for files
set encryption off

* Set to remember cursor position between edits
set restorecursor on

* Status line enabled with bright white on black color
*        (lightyellow on black if file is modified)
set statusline on black brightwhite lightyellow

* Enable the command line
* Moving off command line set to move from prior cursor position
set commandline on off

* Enable backspace over dummy blank lines at end of line
set bkspinfreespace on

* Set no ctrl-Z in file
set eof off

* Set both CR and LF to seperate lines
set linefeed on

* Disable word wrapping at right margin
set wordwrap off

* Allow lower case characters
set uppercase off

* Force the initial cursor onto the command line
set oncommand on

* Start with menu system on
set onmenu on

* When opening file tabs will be expanded to columns 8 columns apart
set tabexpand 8

* Set Tab, CR, LF, and blank as characters that seperate words
set delimiters "\t\n\r "

* Disable blanks compression to tab while saving
set blankcompress off

*
* Synonyms
*

* Shortcuts to screen display sizes
syn s25 = [set display 25 80]
syn s30 = [set display 30 80]
syn s40 = [set display 40 80]
syn s50 = [set display 50 80]

* Shortcuts to C++ instructions
syn if     = [cursor data] 'if (  )' [key f10] [right 4] '{' [key f10]        \
             '}' [key f10] [left 4] 'else' [key f10] [right 4] '{'            \
             [key f10] '}' [up 5] [begin line] [first nonblank] [right 5]     \
             [insert mode]

syn while  = [cursor data] 'while (  )' [key f10] [right 4] '{' [key f10]     \
             '}' [up 2] [begin line] [first nonblank] [right 8] [insert mode]

syn for    = [cursor data] 'for (  ;  ;  )' [key f10] [right 4] '{'           \
             [key f10] '}' [up 2] [begin line] [first nonblank] [right 6]     \
             [insert mode]

syn switch = [cursor data] 'switch (  )' [key f10] [right 4] '{'              \
             [key f10] 'case  :' [key f10] [right 4] 'break;' [key f10]       \
             [key f10] [left 4] 'default:' [key f10] [right 4] 'break;'       \
             [key f10] [left 4] '}' [up 7] [begin line] [first nonblank]      \
             [right 9] [insert mode]

syn case   = [switch]

syn do     = [cursor data] 'do' [key f10] [right 4] '{' [key f10] '}'         \
             [key f10] [left 4] 'while (  );' [left 3] [insert mode]

syn ??     = [cursor data] [insert mode] '(  ) ?  : ' [left 8]

* Shortcut to see key definitions
syn keys = [edit .keydefs]

* Shortcut to write a date/time C++ remark
syn dtr = [cursor data] [insert mode] '/* ' [date] [insert mode] ' ' [time] [insert mode] ' */' [insert toggle]

* Shortcut to write an author name C++ remark
syn anr = [cursor data] [insert mode] '/* Author: <%"Type author name"="Your name"%> */' [insert toggle]

* Shortcut to write a C++ header
syn head = [import header.txt]


*
* Regular keys
*

* Cursor movement keys
def up = [up]
def down = [down]
def left = [left]
def right = [right]

* Page up (two lines overlap)
def pgup = [page up]

* Page down (two lines overlap)
def pgdn = [page down]

* Move cursor to beginning of line
def home = [begin line]

* Move cursor to end of Line
def end = [end line]

* Flip between insert and replace character modes
def ins = [insert toggle]

* Delete character under the cursor
def del = [delete char]

* Position cursor to start of line one line below
def enter = [begin line] [down]

* Erase character before cursor and move cursor left (stop at first column)
def backspace = [rubout]

* Flip cursor between command line and file text (command toggle)
def esc = [command toggle]

* Move cursor to next tab position
def tab = [tab]

* View help text
def f1 = [edit pe32.hlp]

* Save changes to file
def f2 = [save]

* Setup to save changes to file and close
def f3 = [cursor command] [begin line] [erase end line] 'file '

* Exit file without saving changes
def f4 = [quit]

* Open popup window with directory of current files
def f5 = [dir]

* Erase to end of line
def f6 = [erase end line]

* Open popup window with recently entered commands
def f7 = [history]

* Edit next file
def f8 = [edit]

* Insert a blank line
def f9 = [insert line]

* Insert line with cursor aligned below prior non-blank data (skip blank lines)
def f10 = [insert line] [push mark] [mark line] [backtab word] [begin line] \
          [begin word] [begin mark] [pop mark]

* Finish typing using best match keyword
def f11 = [autocomplete]

* Move to command line and copy next executed command back to command line
*    Use c-f12 first else there is no next command
def f12 = [next history]

def padplus = '+'
def padminus = '-'
def space = ' '

*
* Shift keys
*

def s-up = '8'
def s-down = '2'
def s-left = '4'
def s-right = '6'
def s-pgup = '9'
def s-pgdn = '3'
def s-home = '7'
def s-end = '1'
def s-ins = '0'
def s-del = '.'

* Move cursor to prior tab
def s-tab = [backtab]

* Get compiler contextual help from set helpfile <file>
def s-f1 = [context help]

* Next full page up
def s-f2 = [page up] [top edge] [up] [up] [cursor command]

* Next full page down
def s-f3 = [page down] [bottom edge] [down] [down] [cursor command]

* Undo edits
def s-f4 = [undo]

* Edit file described on this file directory line (assumed in default directory)
*     Move to next directory entry after the file is opened
def s-f5 = [push mark] [cursor data] [begin line] [mark line] [locate] '/(/' \
            [erase end line] [begin line] [shift right] [shift right] 'e '    \
            [copy to command] [down] [execute] [unmark] [pop mark]

* Erase current character and all data on the line before it
def s-f6 = [erase begin line] [begin line]

* Erase first column of marked area
def s-f7 = [shift left]

* Add blank column to start of marked area and erase last column
def s-f8 = [shift right]

* Open most recently used file list
def s-f9 = [mru]

* Open opened file list
def s-f10 = [open]

* Insert date as text
def s-f11 = [date]

* Insert time as text
def s-f12 = [time]

def s-pad5 = '5'

*
* Ctrl keys
*

* Fix cursor position and scroll viewing area
def c-up = [scrollup]
def c-down = [scrolldown]
def c-left = [scrollleft]
def c-right = [scrollright]

* Move cursor to top edge of screen
def c-pgup = [top edge]

* Move cursor to bottom edge of screen
def c-pgdn = [bottom edge]

* Move cursor to top of file
def c-home = [top]

* Move cursor to bottom of file
def c-end = [bottom]

* Execute command on command line
def c-enter = [execute]

* Delete current line
def c-backspace = [delete line]

* Delete current line
def c-a = [delete line]

* Move cursor to beginning of word
def c-b = [begin word]

* Copy to clipboard
def c-c = [copy to clipboard]

* Center data on line (see set margins)
def c-d = [push mark] [mark line] [center in margins] [unmark] [pop mark]

* Move cursor beyond end of word
def c-e = [end word]

* Copy From command line onto new line below cursor
def c-f = [copy from command]

* Play current macro
def c-g = [macro play]

* Delete the current word
def c-h = [delete word]

* Zoom out using this view (see c-s)
def c-i = [zoom window]

* Join with following line
def c-j = [push mark] [down] [first nonblank] [mark block] [end line] \
          [end word] [mark block] [up] [end line] [end word] [right]  \
          [copy mark] [down] [unmark] [delete line] [up] [pop mark]

* Erase to beginning of line
def c-k = [erase begin line]

* Force mark to lower case
def c-l = [lowercase]

* Center text in margins
def c-m = [center in margins]

* Like [edit] for windows
def c-n = [next window]

* Move cursor to paragraph margin locatiom
def c-o = [paragraph margin]

* Print marked area
def c-p = [print mark]

* Record a macro
def c-q = [macro define]

* Goto next view same file (when file is split ... key c-s)
def c-r = [next view]

* Split screen
def c-s = [split screen]

* Copy line with cursor on it to command line
def c-t = [copy to command]

* Force mark to upper case
def c-u = [uppercase]

* Copy from clipboard
def c-v = [copy from clipboard]

* Mark the current word
def c-w = [get word]

* Cut to clipboard
def c-x = [begin mark] [copy to clipboard] [delete mark]

* After undo re-apply the change
def c-y = [redo]

* Undo edits
def c-z = [undo]

* Build a C if block with insert cursor placed at condition
def c-f1 = 'if (  )' [key f10]  '{' [key f10] '}' [up] [up] [right]      \
            [right] [right] [right] [insert mode]

* Build a C else clause and indent to same level
def c-f2 = 'else' [key f10]

* Build a C while block with insert cursor placed at condition
def c-f3 = 'while (  )' [key f10] '{' [key f10] '}' [up] [up] [right]   \
            [right] [right] [right] [right] [right] [right] [insert mode]

* Build a C for block with insert cursor placed at loop definition
def c-f4 = 'for (  ;  ;  )' [key f10] '{' [key f10] '}' [up] [up]       \
            [right] [right] [right] [right] [right] [insert mode]

* Build a C switch block with insert cursor placed at switch variable
def c-f5 = 'switch (  )' [key f10] '{' [key f10] '}' [up] [up] [right]  \
            [right] [right] [right] [right] [right] [right] [right]          \
            [insert mode]

* Build a C case statement with insert cursor placed at case designator
def c-f6 = 'case  :' [key f10] 'break ;' [up] [left] [left] [insert mode]

* Build a C if if-then-else statement with insert cursor placed at condition
def c-f7 = '(  ) ?  : ' [left] [left] [left] [left] [left] [left] [left]    \
            [left] [insert mode]

* Build a C do while block with insert cursor placed at condition
def c-f8 = 'do' [key f10] '{' [key f10] '}' [key f10] 'while (  )'    \
            [left] [left] [insert mode]

* Build a C block with insert cursor placed at condition
def c-f9 = '(' [key f10] [tab] ') ;' [up] [key f10] [tab]

* Build a C block comment with insert cursor placed at comment start
def c-f10 = '/**    **/' [insert mode] [left] [left] [left] [left] [left]

* Expand the synonym at the cursor position
def c-f11 = [expand]

* Move to command line and copy prior executed command back to command line
def c-f12 = [prev history]

* Turn command and status lines off
def c-padminus = [cursor command] [begin line] [erase end line]   \
                  'set commandline off' [execute] [cursor command] \
                  'set statusline off' [execute] [cursor data]

* Turn command and status lines on
def c-padplus = [cursor command] [begin line] [erase end line]   \
                  'set commandline on' [execute] [cursor command]  \
                  'set statusline on' [execute] [cursor command]

* Move cursor to matching brace
def c-space = [match brace]

*
* Alt keys
*

* Duplicate current line
def a-a = [dup line]

* Mark one corner of a rectangular block mark
def a-b = [mark block]

* Mark first or last character of a paragraph style block
def a-c = [mark char]

* Delete mark
def a-d = [delete mark]

* Move to end of marked area
def a-e = [end mark]

* Fill marked area (character will be prompted)
def a-f = [fill mark]

* Delete to start of word
def a-g = [unmark] [mark char] [backtab word] [tab word] [mark char]        \
          [delete mark]

* Delete to start of next word
def a-h = [unmark] [mark char] [tab word] [left] [left] [mark char]         \
          [begin mark] [delete mark]

* Make current word lower case and skip to next word
def a-i = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [end mark] [right] [lowercase] [unmark]

* Join two lines
def a-j = [join]

* Make current word upper case and skip to next word
def a-k = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [end mark] [right] [uppercase] [unmark]

* Mark first/last/only line of a group of lines
def a-l = [mark line]

* Move mark to current location
def a-m = [move mark]

* Add Next page seperator (form feed)
def a-n = [insert line] [012]

* Overlay marked block at current location
def a-o = [overlay block]

* Reflow the remainder of the current paragraph,
*   position cursor to presumed start of next paragraph
def a-p = [cursor data] [unmark] [mark line] [find blank line] [up]         \
          [mark line] [reflow] [end mark] [down] [down] [unmark]

* Pause the recording of a macro
def a-q = [macro pause]

* Repeat the last command
def a-r = [repeat command]

* Split line into two lines at cursor position (cursor does not move)
def a-s = [split]

* Overlay block at cursor position then blank fill prior copy and erase mark
def a-t = [overlay block] [fill mark] ' ' [unmark]

* Unmark block
def a-u = [unmark]

* Make current word lower case except for leading capital and skip to next word
def a-v = [unmark] [tab word] [left] [mark char] [backtab word] [mark char] \
          [lowercase] [unmark] [mark char] [uppercase] [unmark] [tab word]

* Mark next Word
def a-w = [unmark] [tab word] [mark char] [end word] [right] [mark char]    \
          [begin mark]

* Delete all file lines
def a-x = [delete all]

* Goto top of marked area
def a-y = [begin mark]

* Copy marked area
def a-z = [copy mark]

* Move cursor to next word
def a-f1 = [tab word]

* Move cursor to prior word
def a-f2 = [backtab word]

* Center current line on screen
def a-f3 = [center line]

* Exit all edits
def a-f4 = [quit all]

* Move cursor to next totally blank line
def a-f5 = [find blank line]

* Delete fron beginning of line up to and including cursor position
def a-f6 = [unmark] [mark char] [begin line] [mark char] [delete mark]

* Move cursor to next non-blank character
def a-f7 = [first nonblank]

* Edit prior file
def a-f8 = [edit -]

* Open menu
def a-f10 = [menu]

* Push mark
def a-f11 = [push mark]

* Pop mark
def a-f12 = [pop mark]

* Align all lines to be within left and right margins
def a-0 = [reformat all]

* Align all lines to the right margin
def a-1 = [justify all]

* Remove leading blanks from current line
def a-2 = [trim leading]

* Remove trailing blanks from current line
def a-3 = [trim trailing]

* Remove multiple blanks from current line
def a-4 = [trim compress]

* Align marked lines to be within left and right margins
def a-5 = [reflow]

* Align paragraph to be within left and right margins
def a-6 = [reformat paragraph]

* Align the paragraph to the right margin
def a-7 = [justify paragraph]

* Align the line to the right margin
def a-8 = [justify line]

* Edit file with current definitions for all keys
def a-9 = [edit .keydefs]

*
* Ctrl+Shift keys (User keys)
*

def u-b = 'BOOL '
def u-c = 'char '
def u-d = 'double '
def u-e = 'extern '
def u-h = 'HWND '
def u-i = 'int '
def u-j = 'long '
def u-k = 'const '
def u-l = 'LPCTSTR'
def u-o = 'CObject'
def u-p = 'CPoint '
def u-r = 'CRect '
def u-s = 'CString '
def u-t = 'this'
def u-u = 'unsigned '
def u-v = 'void'

* Prompt for bookmark letter and remember current position
def u-f1 = [bookmark set]

* Prompt for bookmark letter and restore cursor position
def u-f2 = [bookmark goto]

* Prompt for bookmark letter and erase bookmark memory
def u-f3 = [bookmark remove]

* Move corsor to left margin
def u-f4 = [left margin]

* Move corsor to right margin
def u-f5 = [right margin]

* Up all files
def u-up = [up all]

* Down all files
def u-down = [down all]

* Move corsor to left edge of screen
def u-left = [left edge]

* Move corsor to right edge of screen
def u-right = [right edge]

* Page up all files
def u-pgup = [page up all]

* Page down all files
def u-pgdn = [page down all]

* Top all files
def u-home = [top all]

* Bottom all files
def u-end = [bottom all]

