/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.io.Serializable;

public class GEraseDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "erase.gif";
    public static final Dimension ICONDIM = new Dimension(120, 33);
    private TextField p;
    private TextField p1;
    private TextField p2;
    private GSolid solid;

    public GEraseDialog(GFrame gFrame, GSolid gSolid, int n, Object[] objectArray) {
        super(gFrame, "Erase");
        this.helpTopic = "erase drawings";
        this.solid = gSolid;
        this.p = new TextField(3);
        this.p.setFont(gFrame.labelFont);
        this.p1 = new TextField(3);
        this.p1.setFont(gFrame.labelFont);
        this.p2 = new TextField(3);
        this.p2.setFont(gFrame.labelFont);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        Label label = new Label("Erase the line labeled:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        this.dataPanel.add(this.p1);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 10;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p2, gridBagConstraints);
        this.dataPanel.add(this.p2);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.fill = 2;
        Label label2 = new Label("Erase the point labeled:");
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.p, gridBagConstraints);
        this.dataPanel.add(this.p);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{null, null, null};
        if (this.p1.getText().length() > 0) {
            objectArray[0] = this.p1.getText().toUpperCase();
        }
        if (this.p2.getText().length() > 0) {
            objectArray[1] = this.p2.getText().toUpperCase();
        }
        if (this.p.getText().length() > 0) {
            objectArray[2] = this.p.getText().toUpperCase();
        }
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        if (objectArray[0] != null) {
            ((TextComponent)this.p1).setText((String)objectArray[0]);
            ((TextComponent)this.p2).setText((String)objectArray[1]);
        }
        if (objectArray[2] != null) {
            ((TextComponent)this.p).setText((String)objectArray[2]);
        }
    }

    protected boolean onOk() {
        String[] stringArray = new String[]{this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase(), this.p.getText().toUpperCase()};
        if (stringArray[2].equals("") && (stringArray[0].equals("") || stringArray[1].equals(""))) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Nothing to erase");
            return false;
        }
        if (!stringArray[0].equals("") && stringArray[0].equals(stringArray[1])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[0]) + stringArray[1] + " is no line");
            return false;
        }
        String string = this.solid.erase(stringArray);
        if (string != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Erase Failed", string);
            return false;
        }
        return true;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            Serializable serializable;
            this.setTitle("Erase in Solid " + this.solid.getLabel());
            GEdgeNode gEdgeNode = this.solid.getSelectedEdges().getHead();
            if (gEdgeNode != null) {
                serializable = gEdgeNode.getEdge();
                ((TextComponent)this.p1).setText(((GEdge)serializable).getHead().getLabel());
                ((TextComponent)this.p2).setText(((GEdge)serializable).getTail().getLabel());
            }
            if ((serializable = this.solid.getSelectedVertices().getHead()) != null) {
                ((TextComponent)this.p).setText(((GVertexNode)serializable).getVertex().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

