/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class GFacetColorDialog
extends GOkCancelHelpDialog
implements MouseListener {
    public static final int DEFAULT = 0;
    public static final int ROWS = 5;
    public static final int COLUMNS = 5;
    private static GSampleColor[] samples;
    private GSampleColor oldColor;
    private GSampleColor newColor;
    private GMarkSpectrum spectrum;
    private GFacet facet;
    private int selected;

    public GFacetColorDialog(GFrame gFrame, String string, GFacet gFacet) {
        super(gFrame, "Facet Color in " + string);
        this.helpTopic = "facet color";
        this.facet = gFacet;
        this.selected = 0;
        this.initColorTable();
        this.spectrum = new GMarkSpectrum(samples[0].getColor());
        this.spectrum.addMouseListener(this);
        this.layComponents();
        this.init();
        this.pack();
        this.spectrum.mark(-1);
        this.positionLeft();
        this.show();
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        Label label = new Label("Sample colors:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.gridwidth = 1;
        int n = 0;
        while (n < 5) {
            int n2 = 0;
            while (n2 < 5) {
                int n3 = gridBagConstraints.insets.left = n2 == 0 ? 10 : 5;
                if (n > 0) {
                    gridBagConstraints.insets.top = 10;
                    gridBagConstraints.gridx = n2;
                }
                int n4 = n * 5 + n2;
                gridBagLayout.setConstraints(samples[n4], gridBagConstraints);
                this.dataPanel.add(samples[n4]);
                if (n == 0 && n2 == 4) {
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.gridheight = 5;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.insets.left = 15;
                    gridBagConstraints.insets.right = 10;
                    gridBagLayout.setConstraints(this.spectrum, gridBagConstraints);
                    this.dataPanel.add(this.spectrum);
                    gridBagConstraints.insets.right = 5;
                    gridBagConstraints.fill = 2;
                    gridBagConstraints.gridwidth = 1;
                    gridBagConstraints.gridheight = 1;
                }
                ++n2;
            }
            ++n;
        }
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        Label label2 = new Label("Current color:", 2);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.left = 5;
        gridBagLayout.setConstraints(this.oldColor, gridBagConstraints);
        this.dataPanel.add(this.oldColor);
        gridBagConstraints.gridwidth = 2;
        Label label3 = new Label("New color:", 2);
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 10;
        gridBagLayout.setConstraints(this.newColor, gridBagConstraints);
        this.dataPanel.add(this.newColor);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    protected boolean onOk() {
        this.newColor.setColor(this.spectrum.getMarkedColor());
        this.facet.setColor(this.spectrum.getMarkedColor());
        this.facet.setSelected(false);
        return true;
    }

    public int getBasicColor() {
        return this.selected;
    }

    public void init() {
        this.oldColor.setColor(this.facet.getColor());
        this.newColor.setColor(this.spectrum.getMarkedColor());
        this.selected = 0;
        GSampleColor gSampleColor = samples[this.selected];
        gSampleColor.setSelected(true);
        Color color = gSampleColor.getColor();
        this.spectrum.setBasicColor(color);
        this.newColor.setColor(color);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.spectrum) {
            this.spectrum.mark(mouseEvent.getY());
        } else {
            GSampleColor gSampleColor = (GSampleColor)mouseEvent.getSource();
            samples[this.selected].setSelected(false);
            samples[this.selected].repaint();
            this.selected = gSampleColor.position;
            gSampleColor.setSelected(true);
            gSampleColor.repaint();
            this.spectrum.setBasicColor(gSampleColor.getColor());
        }
        this.spectrum.repaint();
        this.newColor.setColor(this.spectrum.getMarkedColor());
        this.newColor.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    protected void initColorTable() {
        this.oldColor = new GSampleColor(0, 125, 125, 125, false);
        this.newColor = new GSampleColor(0, 125, 125, 125, false);
        samples = new GSampleColor[25];
        GFacetColorDialog.samples[0] = new GSampleColor(0, 125, 125, 125, true);
        samples[0].addMouseListener(this);
        GFacetColorDialog.samples[1] = new GSampleColor(1, 50, 140, 140, false);
        samples[1].addMouseListener(this);
        GFacetColorDialog.samples[2] = new GSampleColor(2, 150, 75, 150, false);
        samples[2].addMouseListener(this);
        GFacetColorDialog.samples[3] = new GSampleColor(3, 75, 100, 150, false);
        samples[3].addMouseListener(this);
        GFacetColorDialog.samples[4] = new GSampleColor(4, 50, 125, 50, false);
        samples[4].addMouseListener(this);
        GFacetColorDialog.samples[5] = new GSampleColor(5, 200, 50, 50, false);
        samples[5].addMouseListener(this);
        GFacetColorDialog.samples[6] = new GSampleColor(6, 200, 150, 50, false);
        samples[6].addMouseListener(this);
        GFacetColorDialog.samples[7] = new GSampleColor(7, 150, 75, 75, false);
        samples[7].addMouseListener(this);
        GFacetColorDialog.samples[8] = new GSampleColor(8, 100, 50, 200, false);
        samples[8].addMouseListener(this);
        GFacetColorDialog.samples[9] = new GSampleColor(9, 25, 25, 150, false);
        samples[9].addMouseListener(this);
        GFacetColorDialog.samples[10] = new GSampleColor(10, 25, 200, 125, false);
        samples[10].addMouseListener(this);
        GFacetColorDialog.samples[11] = new GSampleColor(11, 200, 25, 125, false);
        samples[11].addMouseListener(this);
        GFacetColorDialog.samples[12] = new GSampleColor(12, 125, 125, 200, false);
        samples[12].addMouseListener(this);
        GFacetColorDialog.samples[13] = new GSampleColor(13, 50, 125, 200, false);
        samples[13].addMouseListener(this);
        GFacetColorDialog.samples[14] = new GSampleColor(14, 125, 25, 75, false);
        samples[14].addMouseListener(this);
        GFacetColorDialog.samples[15] = new GSampleColor(15, 200, 125, 125, false);
        samples[15].addMouseListener(this);
        GFacetColorDialog.samples[16] = new GSampleColor(16, 50, 125, 125, false);
        samples[16].addMouseListener(this);
        GFacetColorDialog.samples[17] = new GSampleColor(17, 50, 175, 200, false);
        samples[17].addMouseListener(this);
        GFacetColorDialog.samples[18] = new GSampleColor(18, 200, 75, 175, false);
        samples[18].addMouseListener(this);
        GFacetColorDialog.samples[19] = new GSampleColor(19, 200, 200, 50, false);
        samples[19].addMouseListener(this);
        GFacetColorDialog.samples[20] = new GSampleColor(20, 200, 175, 100, false);
        samples[20].addMouseListener(this);
        GFacetColorDialog.samples[21] = new GSampleColor(21, 75, 25, 150, false);
        samples[21].addMouseListener(this);
        GFacetColorDialog.samples[22] = new GSampleColor(22, 125, 25, 75, false);
        samples[22].addMouseListener(this);
        GFacetColorDialog.samples[23] = new GSampleColor(23, 125, 75, 75, false);
        samples[23].addMouseListener(this);
        GFacetColorDialog.samples[24] = new GSampleColor(24, 25, 125, 75, false);
        samples[24].addMouseListener(this);
    }
}

