/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

public class GLayDistanceDialog
extends GOkCancelHelpDialog {
    public static final String ICONFILE = "laydist.gif";
    public static final Dimension ICONDIM = new Dimension(105, 67);
    private TextField distance;
    private TextField p;
    private TextField p1;
    private TextField p2;
    private GSolid solid;
    private GNotepad notepad;
    private Object distObject;
    private double scaleFactor;

    public GLayDistanceDialog(GFrame gFrame, GNotepad gNotepad, GSolid gSolid, double d, int n, Object[] objectArray) {
        super(gFrame, "Lay Distance");
        this.helpTopic = "lay distance";
        this.notepad = gNotepad;
        this.solid = gSolid;
        this.scaleFactor = d;
        this.distance = new TextField(7);
        this.distance.setFont(gFrame.numberFont);
        this.p = new TextField(3);
        this.p.setFont(gFrame.labelFont);
        this.p1 = new TextField(3);
        this.p1.setFont(gFrame.labelFont);
        this.p2 = new TextField(3);
        this.p2.setFont(gFrame.labelFont);
        this.layComponents();
        this.pack();
        this.positionLeft();
        this.set(n, objectArray);
    }

    private void layComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.layPanels(gridBagLayout, gridBagConstraints, true);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        Label label = new Label("Lay distance:");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.dataPanel.add(label);
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.distance, gridBagConstraints);
        this.dataPanel.add(this.distance);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        Label label2 = new Label("Off point:");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.dataPanel.add(label2);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p, gridBagConstraints);
        this.dataPanel.add(this.p);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.fill = 2;
        Label label3 = new Label("To line:");
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.dataPanel.add(label3);
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.p1, gridBagConstraints);
        this.dataPanel.add(this.p1);
        gridBagConstraints.anchor = 10;
        Image image = this.getToolkit().getImage(String.valueOf(GDialog.frame.imageDir) + "\\" + ICONFILE);
        GIconCanvas gIconCanvas = new GIconCanvas(image, ICONDIM);
        gridBagLayout.setConstraints(gIconCanvas, gridBagConstraints);
        this.dataPanel.add(gIconCanvas);
        gridBagConstraints.anchor = 16;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.right = 10;
        gridBagLayout.setConstraints(this.p2, gridBagConstraints);
        this.dataPanel.add(this.p2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 20;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.buttonsPanel.add(this.okButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.buttonsPanel.add(this.cancelButton);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 20;
        gridBagLayout.setConstraints(this.helpButton, gridBagConstraints);
        this.buttonsPanel.add(this.helpButton);
    }

    public Object[] getFields() {
        Object[] objectArray = new Object[]{this.p.getText().toUpperCase(), this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase(), this.distObject};
        return objectArray;
    }

    protected void setFields(Object[] objectArray) {
        ((TextComponent)this.p).setText((String)objectArray[0]);
        ((TextComponent)this.p1).setText((String)objectArray[1]);
        ((TextComponent)this.p2).setText((String)objectArray[2]);
        this.distObject = objectArray[3];
    }

    protected boolean onOk() {
        double d;
        String[] stringArray = new String[]{this.p.getText().toUpperCase(), this.p1.getText().toUpperCase(), this.p2.getText().toUpperCase()};
        if (this.distObject != null) {
            double d2 = this.distObject instanceof GVariable ? ((GVariable)this.distObject).getValue() : ((Double)this.distObject).doubleValue();
            this.solid.layDistance(stringArray, d2 / this.scaleFactor);
            return true;
        }
        String string = this.distance.getText();
        if (stringArray[0].equals("") || stringArray[1].equals("") || stringArray[2].equals("") || string.equals("")) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Label", "Operation improperly referenced");
            return false;
        }
        if (stringArray[1].equals(stringArray[2])) {
            new GAlertDialog(GDialog.frame, "warn.gif", "No Line", String.valueOf(stringArray[1]) + stringArray[2] + " is no line");
            return false;
        }
        this.distObject = this.notepad.seekDoubleObject(string);
        if (this.distObject == null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Wrong number format or incorrect variable reference: " + string);
            return false;
        }
        double d3 = d = this.distObject instanceof GVariable ? ((GVariable)this.distObject).getValue() : ((Double)this.distObject).doubleValue();
        if (d <= 0.0) {
            new GAlertDialog(GDialog.frame, "warn.gif", "GEOMETRIA", "Distance must be positive");
            this.distObject = null;
            return false;
        }
        String string2 = this.solid.layDistance(stringArray, d / this.scaleFactor);
        if (string2 != null) {
            new GAlertDialog(GDialog.frame, "warn.gif", "Draw Failed", string2);
            this.distObject = null;
            return false;
        }
        return true;
    }

    public void set(int n, Object[] objectArray) {
        if (n == 2) {
            this.setFields(objectArray);
        } else {
            GEdgeNode gEdgeNode;
            this.setTitle("Lay Distance in Solid " + this.solid.getLabel());
            GVertexNode gVertexNode = this.solid.getSelectedVertices().getHead();
            if (gVertexNode != null) {
                ((TextComponent)this.p).setText(gVertexNode.getVertex().getLabel());
            }
            if ((gEdgeNode = this.solid.getSelectedEdges().getHead()) != null) {
                GEdge gEdge = gEdgeNode.getEdge();
                ((TextComponent)this.p1).setText(gEdge.getHead().getLabel());
                ((TextComponent)this.p2).setText(gEdge.getTail().getLabel());
            }
        }
        if (n == 0) {
            this.show();
            return;
        }
        this.result = this.onOk() ? 0 : 1;
    }
}

