/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;

public abstract class GProblem
implements Serializable,
ActionListener,
WindowListener,
ComponentListener,
ItemListener {
    public static final int SOLIDWND_BASINSET = 10;
    public static final int ANGLE_TYPE = 0;
    public static final int RATIO_TYPE = 1;
    public static final int LENGTH_TYPE = 2;
    public static final int AREA_TYPE = 3;
    public static final int VOLUME_TYPE = 4;
    public static final int MENUBAR_GEN = 0;
    public static final int POPUPMENU_GEN = 1;
    public static final int LOG_GEN = 2;
    protected static GFrame frame;
    protected static GMenuBar menuBar;
    protected static boolean saved;
    protected static boolean modified;
    protected int newSolidCount;
    public GSolidWndList solidWndList;
    protected static int solidWndInset;
    protected static GLabelBag labelBag;
    public static GProjSystem projSystem;
    protected static boolean windowsMaximized;
    protected static String name;
    protected String hypothesis;
    protected String comments;
    protected String year;
    protected String author;
    protected String authorEmail;
    protected String authorWeb;
    protected double scaleFactor;
    protected GAnswer answer;
    protected boolean validated;
    protected boolean randomized;
    protected boolean lineAvail;
    protected boolean perpAvail;
    protected boolean midpointAvail;
    protected boolean bisectorAvail;
    protected boolean layDistAvail;
    protected boolean layAngleAvail;
    protected boolean cutAvail;
    public static GCalculator calculator;
    public GNotepad notepad;
    public GLog log;

    public GProblem() {
    }

    public GProblem(GFrame gFrame, GMenuBar gMenuBar, GCalculator gCalculator, GNotepad gNotepad) {
        frame = gFrame;
        menuBar = gMenuBar;
        calculator = gCalculator;
        this.notepad = gNotepad;
        this.scaleFactor = 1.0;
        this.solidWndList = new GSolidWndList();
        labelBag = new GLabelBag();
        projSystem = new GProjSystem();
    }

    public void print() {
        System.out.println(name);
    }

    public abstract boolean onClose();

    public abstract boolean onSolidWindowClose(GSolidWindow var1);

    public abstract boolean onSave();

    protected abstract boolean save();

    protected abstract boolean saveAs();

    public abstract boolean logAlert(String var1);

    public boolean isValidated() {
        return this.validated;
    }

    public boolean isRandomized() {
        return this.randomized;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
    }

    public boolean isLineAvailable() {
        return this.lineAvail;
    }

    public boolean isPerpAvailable() {
        return this.perpAvail;
    }

    public boolean isMidpointAvailable() {
        return this.midpointAvail;
    }

    public boolean isBisectorAvailable() {
        return this.bisectorAvail;
    }

    public boolean isLayDistAvailable() {
        return this.layDistAvail;
    }

    public boolean isLayAngleAvailable() {
        return this.layAngleAvail;
    }

    public boolean isCutAvailable() {
        return this.cutAvail;
    }

    public String getName() {
        return name;
    }

    public void setName(String string) {
        name = string;
    }

    public String getHypothesis() {
        return this.hypothesis;
    }

    public void setModified(boolean bl) {
        modified = bl;
    }

    public void close() {
        this.solidWndList.flush();
    }

    /*
     * Unable to fully structure code
     */
    public void unfoldSolidWnds(boolean var1_1) {
        GProblem.windowsMaximized = false;
        GProblem.solidWndInset = 0;
        var2_2 = this.solidWndList.getHead();
        if (var2_2 != null) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            var3_3 = var2_2.getSolid();
            if (var1_1) {
                var3_3.enforce();
                this.initCutCount(var3_3);
            }
            var4_4 = new GSolidWindow(GProblem.frame, this, var3_3, -1.0, GProblem.solidWndInset, false, true);
            var2_2.setWindow(var4_4);
            var4_4.updateContent(null);
            GProblem.menuBar.addWindowMenuItem(this, "Solid " + var3_3.getLabel());
            GProblem.solidWndInset = (GProblem.solidWndInset + 10) % (GSolidWindow.getInitSize() / 2);
            var4_4.show();
            this.solidWndList.setTop(var4_4);
            var2_2 = var2_2.getNext();
lbl18:
            // 2 sources

            ** while (var2_2 != null)
        }
lbl19:
        // 1 sources

        GProblem.menuBar.update(this, this.solidWndList.getTop().getWindow());
        this.updateLabelBag();
    }

    public void cascadeSolidWnds() {
        windowsMaximized = false;
        solidWndInset = 0;
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        if (gSolidWndNode == null) {
            return;
        }
        gSolidWndNode.getWindow().setInitSize();
        while (gSolidWndNode != null) {
            GSolidWindow gSolidWindow = gSolidWndNode.getWindow();
            gSolidWindow.setResizable(true);
            gSolidWindow.layBounds(solidWndInset, -1.0, false);
            gSolidWindow.toFront();
            gSolidWindow.getCanvas().requestFocus();
            solidWndInset = (solidWndInset + 10) % (GSolidWindow.getInitSize() / 2);
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    public GSolidWindow setTopSolidWnd(String string) {
        GSolidWndNode gSolidWndNode = this.solidWndList.setTop(string);
        if (gSolidWndNode != null) {
            GSolidWindow gSolidWindow = gSolidWndNode.getWindow();
            gSolidWindow.toFront();
            gSolidWindow.getCanvas().requestFocus();
            return gSolidWindow;
        }
        return null;
    }

    protected void updateLabelBag() {
        labelBag.unmarkAll();
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            GVertexNode gVertexNode = gSolidWndNode.getSolid().vertexList.getHead();
            while (gVertexNode != null) {
                labelBag.mark(gVertexNode.getVertex().getLabel());
                gVertexNode = gVertexNode.getNext();
            }
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    public String supplyLabel() {
        return labelBag.supplyLabel();
    }

    public GLabelList supplyLabels(int n) {
        return labelBag.supplyLabels(n);
    }

    protected void adjustBounds(Object object) {
        if (object == frame && this.solidWndList != null) {
            this.solidWndList.adjustBounds(windowsMaximized);
            return;
        }
        if (object instanceof GSolidWindow) {
            GSolidWindow gSolidWindow = (GSolidWindow)object;
            gSolidWindow.adjustBounds(windowsMaximized);
        }
    }

    protected void flushTempEdges() {
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            gSolidWndNode.getSolid().facetList.flushTempEdges();
            gSolidWndNode = gSolidWndNode.getNext();
        }
    }

    protected void initCutCount(GSolid gSolid) {
        String string = gSolid.getLabel();
        int n = string.length();
        int n2 = 0;
        GSolidWndNode gSolidWndNode = this.solidWndList.getHead();
        while (gSolidWndNode != null) {
            String string2 = gSolidWndNode.getSolid().getLabel();
            if (string2.startsWith(string) && string2.length() > n && string2.charAt(n) == ':') {
                int n3 = string2.indexOf(58, n + 1);
                String string3 = n3 < 0 ? string2.substring(n + 1) : string2.substring(n + 1, n3);
                n2 = Math.max(n2, Integer.valueOf(string3));
            }
            gSolidWndNode = gSolidWndNode.getNext();
        }
        gSolid.setCutCount((n2 % 2 == 0 ? n2 : n2 + 1) / 2);
    }

    protected void distance(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("measure")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GDistanceDialog gDistanceDialog = new GDistanceDialog(frame, this.notepad);
        boolean bl = gDistanceDialog.set(gSolid, gSolidWindow.getCanvas(), this.scaleFactor, n, objectArray);
        gSolid.clearSelection(true, true, true);
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.repaint();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (n != 2 && bl) {
            modified = true;
            if (this instanceof GRProblem) {
                this.log.add("Measure distance", gDistanceDialog.getFields(), gSolidWindow.getTitle());
            }
        }
    }

    protected void angle(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("measure")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GAngleDialog gAngleDialog = new GAngleDialog(frame, this.notepad);
        boolean bl = gAngleDialog.set(gSolid, gSolidWindow.getCanvas(), n, objectArray);
        gSolid.clearSelection(true, true, true);
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.repaint();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
        if (n != 2 && bl) {
            modified = true;
            if (this instanceof GRProblem) {
                this.log.add("Measure angle", gAngleDialog.getFields(), gSolidWindow.getTitle());
            }
        }
    }

    protected void drawLine(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GLineDialog gLineDialog = new GLineDialog(frame, gSolid, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gLineDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Draw line", gLineDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void drawMidpoint(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GMidpointDialog gMidpointDialog = new GMidpointDialog(frame, gSolid, this, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gMidpointDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Draw midpoint", gMidpointDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void drawBisector(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GBisectorDialog gBisectorDialog = new GBisectorDialog(frame, gSolid, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gBisectorDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Draw bisector", gBisectorDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void drawIntersection(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GIntersectDialog gIntersectDialog = new GIntersectDialog(frame, gSolid, this, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gIntersectDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Draw intersection", gIntersectDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void drawPerpendicular(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GPerpDialog gPerpDialog = new GPerpDialog(frame, gSolid, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gPerpDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Draw perp", gPerpDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void layDistance(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GLayDistanceDialog gLayDistanceDialog = new GLayDistanceDialog(frame, this.notepad, gSolid, this.scaleFactor, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gLayDistanceDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Lay distance", gLayDistanceDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void layAngle(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("draw")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GLayAngleDialog gLayAngleDialog = new GLayAngleDialog(frame, this.notepad, gSolid, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gLayAngleDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            menuBar.update(this, gSolidWindow);
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Lay angle", gLayAngleDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void erase(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("erase")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        GEraseDialog gEraseDialog = new GEraseDialog(frame, gSolid, n, objectArray);
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        if (gEraseDialog.result == 0 || n == 2) {
            gSolidWindow.updateContent(null);
            this.updateLabelBag();
            menuBar.update(this, gSolidWindow);
            this.notepad.update(gSolid, gSolid, n != 2);
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Erase", gEraseDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void eraseAll(GSolidWindow gSolidWindow, int n) {
        if (n != 2 && this.logAlert("erase")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        gSolidWindow.toFront();
        gSolidWindow.getCanvas().requestFocus();
        GYNPromptDialog gYNPromptDialog = null;
        if (n != 2) {
            gYNPromptDialog = new GYNPromptDialog(frame, "Erase all drawings in Solid " + gSolid.getLabel() + " ?");
        }
        if (n == 2 || gYNPromptDialog.result == 2) {
            gSolid.eraseAll();
            gSolidWindow.updateContent(null);
            this.updateLabelBag();
            menuBar.update(this, gSolidWindow);
            this.notepad.update(gSolid, gSolid, n != 2);
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Erase all drawings", null, gSolidWindow.getTitle());
                }
            }
        }
    }

    public void cut(GSolidWindow gSolidWindow, int n, Object[] objectArray) {
        if (n != 2 && this.logAlert("cut")) {
            return;
        }
        GSolid gSolid = gSolidWindow.getSolid();
        gSolid.getLabel();
        GCutDialog gCutDialog = new GCutDialog(frame, gSolid, n, objectArray);
        if (gCutDialog.result == 0 || n == 2) {
            gSolidWindow.repaint();
            int n2 = 0;
            while (n2 < 2) {
                GSolid gSolid2 = gCutDialog.solidKids[n2];
                GSolidWindow gSolidWindow2 = new GSolidWindow(frame, this, gSolid2, gSolidWindow.getCanvas().getScale(), solidWndInset, windowsMaximized, true);
                this.solidWndList.addToTail(gSolidWindow2);
                solidWndInset = (solidWndInset + 10) % (GSolidWindow.getInitSize() / 2);
                menuBar.addWindowMenuItem(this, "Solid " + gSolid2.getLabel());
                ++n2;
            }
            this.updateLabelBag();
            if (n != 2) {
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Cut", gCutDialog.getFields(), gSolidWindow.getTitle());
                }
            }
        }
    }

    protected void initAttitude(GSolidWindow gSolidWindow) {
        GSolid gSolid = gSolidWindow.getSolid();
        gSolid.initAttitude();
        gSolid.project();
        GXYGrid gXYGrid = gSolidWindow.getXYGrid();
        if (gXYGrid.isVisible()) {
            gXYGrid.project(gSolid);
        }
        GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
        gSolidCanvas.repaint();
        gSolidWindow.toFront();
        gSolidCanvas.requestFocus();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        if (windowEvent.getSource() instanceof GSolidWindow) {
            GSolidWindow gSolidWindow = (GSolidWindow)windowEvent.getWindow();
            this.solidWndList.setTop(gSolidWindow);
            menuBar.selectWindowMenuItem(gSolidWindow.getTitle());
            menuBar.update(this, gSolidWindow);
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() instanceof GSolidWindow) {
            GSolidWindow gSolidWindow = (GSolidWindow)windowEvent.getWindow();
            if (!this.onSolidWindowClose(gSolidWindow) || this.logAlert("close window")) {
                return;
            }
            GSolid gSolid = gSolidWindow.getSolid();
            String string = gSolidWindow.getTitle();
            GYNPromptDialog gYNPromptDialog = new GYNPromptDialog(frame, "Remove " + string + " ?");
            if (gYNPromptDialog.result == 2) {
                this.solidWndList.remove(gSolidWindow);
                gSolidWindow.dispose();
                menuBar.removeWindowMenuItem("Solid " + gSolid.getLabel());
                this.notepad.removeSolid(gSolid, true);
                GSolidWndNode gSolidWndNode = this.solidWndList.getTop();
                if (gSolidWndNode != null) {
                    gSolidWindow = gSolidWndNode.getWindow();
                    menuBar.selectWindowMenuItem(gSolidWindow.getTitle());
                    gSolidWindow.toFront();
                    gSolidWindow.getCanvas().requestFocus();
                } else {
                    menuBar.update(this, null);
                }
                if (string.equals(this.answer.getSolidName())) {
                    this.answer.setSolidName(null);
                }
                this.updateLabelBag();
                modified = true;
                if (this instanceof GRProblem) {
                    this.log.add("Close window", null, string);
                }
            }
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.adjustBounds(componentEvent.getSource());
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.adjustBounds(componentEvent.getSource());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        GCheckboxMenuItem gCheckboxMenuItem = (GCheckboxMenuItem)itemEvent.getSource();
        GMenu gMenu = (GMenu)gCheckboxMenuItem.getParent();
        if (gMenu == GProblem.menuBar.windowMenu) {
            this.setTopSolidWnd(gCheckboxMenuItem.getLabel());
            return;
        }
        if (gMenu == GProblem.menuBar.viewMenu) {
            if (gCheckboxMenuItem == GProblem.menuBar.labelsMenuItem) {
                GSolidWindow gSolidWindow = this.solidWndList.getTop().getWindow();
                gSolidWindow.getSolid().setLabeled(GProblem.menuBar.labelsMenuItem.getState());
                GSolidCanvas gSolidCanvas = gSolidWindow.getCanvas();
                gSolidCanvas.repaint();
                gSolidWindow.toFront();
                gSolidCanvas.requestFocus();
                return;
            }
            if (gCheckboxMenuItem == GProblem.menuBar.transparentMenuItem || gCheckboxMenuItem == GProblem.menuBar.polychromeMenuItem || gCheckboxMenuItem == GProblem.menuBar.monochromeMenuItem) {
                GSolidWindow gSolidWindow = this.solidWndList.getTop().getWindow();
                if (gCheckboxMenuItem.getState()) {
                    int n = menuBar.checkViewMode(gCheckboxMenuItem);
                    gSolidWindow.getSolid().setViewMode(n);
                    if (n != 0) {
                        gSolidWindow.getXYGrid().setVisible(false);
                        menuBar.update(this, gSolidWindow);
                    }
                    gSolidWindow.getCanvas().repaint();
                } else {
                    gCheckboxMenuItem.setState(true);
                }
                gSolidWindow.toFront();
                gSolidWindow.getCanvas().requestFocus();
                return;
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        GMenuItem gMenuItem = menuBar.seek(keyEvent.getKeyCode());
        if (gMenuItem != null) {
            this.actionPerformed(new ActionEvent(gMenuItem, 0, null));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block36: {
            GSolidWindow gSolidWindow;
            GMenu gMenu;
            GMenuItem gMenuItem;
            block33: {
                block35: {
                    block34: {
                        gMenuItem = (GMenuItem)actionEvent.getSource();
                        gMenu = (GMenu)gMenuItem.getParent();
                        GSolidWindow gSolidWindow2 = gSolidWindow = this.solidWndList.getDim() > 0 ? this.solidWndList.getTop().getWindow() : null;
                        if (gMenu != GProblem.menuBar.fileMenu) break block33;
                        if (gMenuItem != GProblem.menuBar.saveMenuItem) break block34;
                        if (this instanceof GCProblem) {
                            frame.notForShare();
                            return;
                        }
                        if (this.onSave()) {
                            if (saved) {
                                this.save();
                                return;
                            }
                            this.saveAs();
                            return;
                        }
                        break block35;
                    }
                    if (gMenuItem != GProblem.menuBar.saveAsMenuItem) break block36;
                    if (this instanceof GCProblem) {
                        frame.notForShare();
                        return;
                    }
                    if (!this.onSave()) break block36;
                    this.saveAs();
                }
                return;
            }
            if (gMenu == GProblem.menuBar.measureMenu) {
                if (gMenuItem == GProblem.menuBar.distanceMenuItem) {
                    this.distance(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.angleMenuItem) {
                    this.angle(gSolidWindow, 0, null);
                    return;
                }
            } else if (gMenu == GProblem.menuBar.drawMenu) {
                if (gMenuItem == GProblem.menuBar.lineMenuItem) {
                    this.drawLine(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.midpointMenuItem) {
                    this.drawMidpoint(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.bisectorMenuItem) {
                    this.drawBisector(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.intersectMenuItem) {
                    this.drawIntersection(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.perpMenuItem) {
                    this.drawPerpendicular(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.layDistanceMenuItem) {
                    this.layDistance(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.layAngleMenuItem) {
                    this.layAngle(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.cutMenuItem) {
                    this.cut(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.eraseMenuItem) {
                    this.erase(gSolidWindow, 0, null);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.eraseAllMenuItem) {
                    this.eraseAll(gSolidWindow, 0);
                    return;
                }
            } else if (gMenu == GProblem.menuBar.viewMenu) {
                if (gMenuItem == GProblem.menuBar.initAttMenuItem) {
                    this.initAttitude(gSolidWindow);
                    return;
                }
                if (gMenuItem == GProblem.menuBar.zoomInMenuItem) {
                    gSolidWindow.getCanvas().zoomIn();
                    return;
                }
                if (gMenuItem == GProblem.menuBar.zoomOutMenuItem) {
                    gSolidWindow.getCanvas().zoomOut();
                    return;
                }
                if (gMenuItem == GProblem.menuBar.bestFitMenuItem) {
                    gSolidWindow.getCanvas().bestFit();
                    return;
                }
            } else {
                if (gMenu == GProblem.menuBar.revolveMenu) {
                    gSolidWindow.toFront();
                    gSolidWindow.getCanvas().requestFocus();
                    KeyEvent keyEvent = new KeyEvent(gSolidWindow.getCanvas(), 0, 0L, 0, gMenuItem.getShortcut().getKey());
                    gSolidWindow.getCanvas().keyPressed(keyEvent);
                    gSolidWindow.getCanvas().keyReleased(keyEvent);
                    return;
                }
                if (gMenu == GProblem.menuBar.windowMenu) {
                    if (gMenuItem == GProblem.menuBar.cascadeMenuItem) {
                        this.cascadeSolidWnds();
                        return;
                    }
                    if (gMenuItem == GProblem.menuBar.maximizeMenuItem) {
                        this.solidWndList.maximize(frame.getSolidsArea());
                        windowsMaximized = true;
                    }
                }
            }
        }
    }
}

